/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Classifier;
import LBJ2.classify.DiscreteFeature;
import LBJ2.classify.RealConjunctiveFeature;
import LBJ2.classify.RealFeature;
import LBJ2.learn.ChildLexicon;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ClassUtils;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class Feature
implements Cloneable,
Comparable,
Serializable {
    protected String containingPackage;
    protected String generatingClassifier;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Feature() {
    }

    public Feature(String string, String string2) {
        this.containingPackage = string;
        this.generatingClassifier = string2;
    }

    public String getPackage() {
        return this.containingPackage;
    }

    public String getGeneratingClassifier() {
        return this.generatingClassifier;
    }

    public abstract String getStringIdentifier();

    public abstract ByteString getByteStringIdentifier();

    public abstract String getStringValue();

    public abstract ByteString getByteStringValue();

    public abstract boolean valueEquals(String var1);

    public abstract boolean isDiscrete();

    public boolean hasByteStringIdentifier() {
        return false;
    }

    public boolean hasStringIdentifier() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isConjunctive() {
        return false;
    }

    public boolean isReferrer() {
        return false;
    }

    public boolean fromArray() {
        return false;
    }

    public int depth() {
        return 0;
    }

    public short getValueIndex() {
        return -1;
    }

    public short totalValues() {
        return 0;
    }

    public void setArrayLength(int n) {
    }

    public abstract double getStrength();

    public Feature getFeatureKey(Lexicon lexicon) {
        return this.getFeatureKey(lexicon, true, -1);
    }

    public abstract Feature getFeatureKey(Lexicon var1, boolean var2, int var3);

    public abstract RealFeature makeReal();

    public abstract Feature conjunction(Feature var1, Classifier var2);

    protected Feature conjunctWith(DiscreteFeature discreteFeature, Classifier classifier) {
        return new RealConjunctiveFeature(classifier, discreteFeature, this);
    }

    protected Feature conjunctWith(RealFeature realFeature, Classifier classifier) {
        return new RealConjunctiveFeature(classifier, realFeature, this);
    }

    public abstract Feature withStrength(double var1);

    public abstract Feature encode(String var1);

    public void removeFromChildLexicon(ChildLexicon childLexicon) {
    }

    public int childLexiconLookup(ChildLexicon childLexicon, int n) {
        return childLexicon.childLexiconLookup(this, n);
    }

    public int hashCode() {
        return 31 * this.containingPackage.hashCode() + this.generatingClassifier.hashCode();
    }

    public boolean equals(Object object) {
        if (!$assertionsDisabled && this.getClass() == object.getClass() != this.getClass().getName().equals(object.getClass().getName())) {
            throw new AssertionError((Object)"getClass() doesn't behave as expected.");
        }
        if (!(object instanceof Feature)) {
            return false;
        }
        Feature feature = (Feature)object;
        if (this.getClass() != object.getClass() && !this.classEquivalent(feature)) {
            return false;
        }
        if (!$assertionsDisabled && feature.containingPackage.equals(this.containingPackage) && feature.containingPackage != this.containingPackage) {
            throw new AssertionError((Object)("Features \"" + feature + "\" and \"" + this + " have equivalent package strings in different objects."));
        }
        if (!$assertionsDisabled && feature.generatingClassifier.equals(this.generatingClassifier) && feature.generatingClassifier != this.generatingClassifier) {
            throw new AssertionError((Object)("Features \"" + feature + "\" and \"" + this + " have equivalent classifier name strings in different objects."));
        }
        return feature.containingPackage == this.containingPackage && feature.generatingClassifier == this.generatingClassifier;
    }

    public boolean classEquivalent(Feature feature) {
        return false;
    }

    public abstract int compareTo(Object var1);

    public int compareNameStrings(Object object) {
        int n = this.compareTypes(object);
        if (n != 0) {
            return n;
        }
        Feature feature = (Feature)object;
        n = this.containingPackage.compareTo(feature.containingPackage);
        if (n != 0) {
            return n;
        }
        return this.generatingClassifier.compareTo(feature.generatingClassifier);
    }

    private int compareTypes(Object object) {
        int n;
        if (!(object instanceof Feature)) {
            return -1;
        }
        Feature feature = (Feature)object;
        boolean bl = this.isDiscrete();
        boolean bl2 = feature.isDiscrete();
        int n2 = (bl2 ? 1 : 0) - (bl ? 1 : 0);
        if (n2 != 0) {
            return n2;
        }
        int n3 = this.depth();
        n2 = n3 - (n = feature.depth());
        if (n2 != 0) {
            return n2;
        }
        bl = this.isReferrer();
        bl2 = feature.isReferrer();
        n2 = (bl2 ? 1 : 0) - (bl ? 1 : 0);
        if (n2 != 0) {
            return n2;
        }
        bl = this.fromArray();
        n2 = (bl ? 1 : 0) - ((bl2 = feature.fromArray()) ? 1 : 0);
        if (n2 != 0) {
            return n2;
        }
        bl = this.hasStringIdentifier();
        bl2 = feature.hasStringIdentifier();
        return (bl ? 1 : 0) - (bl2 ? 1 : 0);
    }

    public abstract void write(StringBuffer var1);

    public void writeNameString(StringBuffer stringBuffer) {
        if (this.containingPackage != null && this.containingPackage.length() > 0) {
            stringBuffer.append(this.containingPackage);
            stringBuffer.append(".");
        }
        stringBuffer.append(this.generatingClassifier);
        if (this.hasByteStringIdentifier()) {
            stringBuffer.append("|B|");
        }
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        exceptionlessOutputStream.writeString(this.getClass().getName());
        exceptionlessOutputStream.writeString(this.containingPackage);
        exceptionlessOutputStream.writeString(this.generatingClassifier);
    }

    public void writeNoPackage(StringBuffer stringBuffer) {
        String string = this.containingPackage;
        this.containingPackage = null;
        this.write(stringBuffer);
        this.containingPackage = string;
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = this.getClass().getName();
        exceptionlessOutputStream.writeString(string5.equals(string) ? null : string5);
        exceptionlessOutputStream.writeString(this.containingPackage == string2 ? null : this.containingPackage);
        exceptionlessOutputStream.writeString(this.generatingClassifier == string3 ? null : this.generatingClassifier);
        return string5;
    }

    public static Feature readFeature(ExceptionlessInputStream exceptionlessInputStream) {
        String string = exceptionlessInputStream.readString();
        if (string == null) {
            return null;
        }
        Class clazz = ClassUtils.getClass(string);
        Feature feature = null;
        try {
            feature = (Feature)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("Error instantiating feature '" + string + "':");
            exception.printStackTrace();
            exceptionlessInputStream.close();
            System.exit(1);
        }
        feature.read(exceptionlessInputStream);
        return feature;
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.containingPackage = exceptionlessInputStream.readString().intern();
        this.generatingClassifier = exceptionlessInputStream.readString().intern();
    }

    public static Feature lexReadFeature(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, Class clazz, String string, String string2, String string3, ByteString byteString) {
        String string4 = exceptionlessInputStream.readString();
        if (string4 != null) {
            clazz = ClassUtils.getClass(string4);
        }
        Feature feature = null;
        try {
            feature = (Feature)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("Error instantiating feature '" + string4 + "':");
            exception.printStackTrace();
            exceptionlessInputStream.close();
            System.exit(1);
        }
        feature.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        return feature;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        this.containingPackage = exceptionlessInputStream.readString();
        this.containingPackage = this.containingPackage == null ? string : this.containingPackage.intern();
        this.generatingClassifier = exceptionlessInputStream.readString();
        this.generatingClassifier = this.generatingClassifier == null ? string2 : this.generatingClassifier.intern();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.write(stringBuffer);
        return stringBuffer.toString();
    }

    public String toStringNoPackage() {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeNoPackage(stringBuffer);
        return stringBuffer.toString();
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            System.err.println("Can't clone feature '" + this + "':");
            exception.printStackTrace();
        }
        return object;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.containingPackage = this.containingPackage.intern();
        this.generatingClassifier = this.generatingClassifier.intern();
    }

    static {
        $assertionsDisabled = !Feature.class.desiredAssertionStatus();
    }
}

