/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Feature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import LBJ2.util.FVector;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class FeatureVector
implements Cloneable,
Serializable {
    protected FVector features = new FVector();
    protected FVector labels = new FVector();
    protected double weight = 1.0;
    protected FeatureVector realCache;

    public FeatureVector() {
    }

    public FeatureVector(Feature feature) {
        this();
        this.addFeature(feature);
    }

    public FeatureVector(Feature[] featureArray) {
        this();
        for (int i = 0; i < featureArray.length; ++i) {
            this.addFeature(featureArray[i]);
        }
    }

    public FeatureVector(Object[] objectArray, Lexicon lexicon, Lexicon lexicon2) {
        this();
        Object object;
        int[] nArray = (int[])objectArray[0];
        double[] dArray = (double[])objectArray[1];
        for (int i = 0; i < nArray.length; ++i) {
            object = lexicon.lookupKey(nArray[i]);
            Feature feature = ((Feature)object).withStrength(dArray[i]);
            this.addFeature((Feature)(feature == null ? object : feature));
        }
        if (objectArray.length > 2) {
            int[] nArray2 = (int[])objectArray[2];
            object = (double[])objectArray[3];
            for (int i = 0; i < nArray2.length; ++i) {
                Feature feature = lexicon2.lookupKey(nArray2[i]);
                if (!feature.isDiscrete()) {
                    feature = feature.withStrength((double)object[i]);
                }
                this.addLabel(feature);
            }
        }
    }

    public int size() {
        return this.features.size() + this.labels.size();
    }

    public int featuresSize() {
        return this.features.size();
    }

    public int labelsSize() {
        return this.labels.size();
    }

    public Feature getFeature(int n) {
        return this.features.get(n);
    }

    public Feature getLabel(int n) {
        return this.labels.get(n);
    }

    public double getWeight() {
        return this.weight;
    }

    public void clear() {
        this.features = new FVector();
        this.labels = new FVector();
        this.realCache = null;
    }

    public void clearLabels() {
        this.labels = new FVector();
    }

    public void sort() {
        this.features.sort();
        this.labels.sort();
    }

    public void addFeature(Feature feature) {
        this.features.add(feature);
        this.realCache = null;
    }

    public void addFeatures(FeatureVector featureVector) {
        this.features.addAll(featureVector.features);
        this.realCache = null;
    }

    public void addLabel(Feature feature) {
        this.labels.add(feature);
    }

    public void addLabels(FeatureVector featureVector) {
        this.labels.addAll(featureVector.features);
    }

    public boolean isLabeled() {
        return this.labels.size() > 0;
    }

    public FeatureVector makeReal() {
        if (this.realCache == null) {
            int n;
            this.realCache = (FeatureVector)this.clone();
            int n2 = this.realCache.labels.size();
            for (n = 0; n < n2; ++n) {
                this.realCache.labels.set(n, this.realCache.labels.get(n).makeReal());
            }
            n2 = this.realCache.features.size();
            for (n = 0; n < n2; ++n) {
                this.realCache.features.set(n, this.realCache.features.get(n).makeReal());
            }
        }
        return this.realCache;
    }

    public String[] discreteValueArray() {
        String[] stringArray = new String[this.features.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.features.get(i).getStringValue();
        }
        return stringArray;
    }

    public double[] realValueArray() {
        double[] dArray = new double[this.features.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.features.get(i).getStrength();
        }
        return dArray;
    }

    public Feature firstFeature() {
        return this.features.get(0);
    }

    public Feature firstLabel() {
        return this.labels.get(0);
    }

    public double L2NormSquared() {
        double d = 0.0;
        int n = this.features.size();
        for (int i = 0; i < n; ++i) {
            double d2 = this.features.get(i).getStrength();
            d += d2 * d2;
        }
        return d;
    }

    public static double L2NormSquared(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        int n3 = this.features.size();
        for (n = 0; n < n3; ++n) {
            n2 = 17 * n2 + this.features.get(n).hashCode();
        }
        n3 = this.labels.size();
        for (n = 0; n < n3; ++n) {
            n2 = 31 * n2 + this.labels.get(n).hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FeatureVector)) {
            return false;
        }
        FeatureVector featureVector = (FeatureVector)object;
        return this.features.equals(featureVector.features) && this.labels.equals(featureVector.labels);
    }

    public static SortedMap getSortedMap(int[] nArray, double[] dArray) {
        TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = nArray[i];
            Object v = treeMap.get(n);
            if (v == null) {
                treeMap.put(n, dArray[i]);
                continue;
            }
            treeMap.put(n, (Double)v + dArray[i]);
        }
        return treeMap;
    }

    public static double dot(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2) {
        Set set = FeatureVector.getSortedMap(nArray, dArray).entrySet();
        Set set2 = FeatureVector.getSortedMap(nArray2, dArray2).entrySet();
        double d = 0.0;
        try {
            Iterator iterator = set.iterator();
            Iterator iterator2 = set2.iterator();
            Map.Entry entry = iterator.next();
            Map.Entry entry2 = iterator2.next();
            while (true) {
                int n;
                int n2;
                if ((n2 = ((Integer)entry.getKey()).intValue()) == (n = ((Integer)entry2.getKey()).intValue())) {
                    d += (Double)entry.getValue() * (Double)entry2.getValue();
                    entry = iterator.next();
                    entry2 = iterator2.next();
                    continue;
                }
                if (n2 < n) {
                    entry = iterator.next();
                    continue;
                }
                entry2 = iterator2.next();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return d;
        }
    }

    public double dot(FeatureVector featureVector) {
        if (this.features.size() == 0 || featureVector.features.size() == 0) {
            return 0.0;
        }
        FVector fVector = (FVector)this.features.clone();
        FVector fVector2 = (FVector)featureVector.features.clone();
        fVector.sort();
        fVector2.sort();
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        Feature feature = fVector.get(0);
        Feature feature2 = fVector2.get(0);
        while (feature != null && feature2 != null) {
            if (feature.equals(feature2)) {
                d += feature.getStrength() * feature2.getStrength();
                feature = fVector.get(++n);
                feature2 = fVector2.get(++n2);
                continue;
            }
            if (feature.compareTo(feature2) < 0) {
                feature = fVector.get(++n);
                continue;
            }
            feature2 = fVector2.get(++n2);
        }
        return d;
    }

    public boolean valueEquals(FeatureVector featureVector) {
        int n;
        if (this.features.size() != featureVector.features.size() || this.labels.size() != featureVector.labels.size()) {
            return false;
        }
        int n2 = this.features.size();
        for (n = 0; n < n2; ++n) {
            if (this.features.get(n).valueEquals(featureVector.features.get(n).getStringValue())) continue;
            return false;
        }
        n2 = this.labels.size();
        for (n = 0; n < n2; ++n) {
            if (this.labels.get(n).valueEquals(featureVector.labels.get(n).getStringValue())) continue;
            return false;
        }
        return true;
    }

    public void write(StringBuffer stringBuffer) {
        this.write(stringBuffer, true);
    }

    public void write(StringBuffer stringBuffer, boolean bl) {
        int n;
        stringBuffer.append("[");
        int n2 = this.labels.size();
        if (n2 > 0) {
            if (bl) {
                this.labels.get(0).write(stringBuffer);
            } else {
                this.labels.get(0).writeNoPackage(stringBuffer);
            }
            for (n = 1; n < n2; ++n) {
                stringBuffer.append(", ");
                if (bl) {
                    this.labels.get(n).write(stringBuffer);
                    continue;
                }
                this.labels.get(n).writeNoPackage(stringBuffer);
            }
        }
        stringBuffer.append("]");
        n2 = this.features.size();
        if (n2 > 0) {
            stringBuffer.append(" ");
            if (bl) {
                this.features.get(0).write(stringBuffer);
            } else {
                this.features.get(0).writeNoPackage(stringBuffer);
            }
            for (n = 1; n < n2; ++n) {
                stringBuffer.append(", ");
                if (bl) {
                    this.features.get(n).write(stringBuffer);
                    continue;
                }
                this.features.get(n).writeNoPackage(stringBuffer);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.write(stringBuffer);
        return stringBuffer.toString();
    }

    public String toStringNoPackage() {
        StringBuffer stringBuffer = new StringBuffer();
        this.write(stringBuffer, false);
        return stringBuffer.toString();
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        exceptionlessOutputStream.writeDouble(this.weight);
        this.features.write(exceptionlessOutputStream);
        this.labels.write(exceptionlessOutputStream);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.realCache = null;
        this.weight = exceptionlessInputStream.readDouble();
        this.features = new FVector();
        this.features.read(exceptionlessInputStream);
        this.labels = new FVector();
        this.labels.read(exceptionlessInputStream);
    }

    public Object clone() {
        FeatureVector featureVector = new FeatureVector();
        featureVector.features = (FVector)this.features.clone();
        featureVector.labels = (FVector)this.labels.clone();
        featureVector.weight = this.weight;
        return featureVector;
    }
}

