/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Feature;
import LBJ2.classify.RealFeature;
import LBJ2.classify.RealPrimitiveFeature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class RealPrimitiveStringFeature
extends RealFeature {
    protected String identifier;
    protected double value;

    protected RealPrimitiveStringFeature() {
    }

    public RealPrimitiveStringFeature(String string, String string2, String string3, double d) {
        super(string, string2);
        this.identifier = string3;
        this.value = d;
    }

    public boolean hasStringIdentifier() {
        return true;
    }

    public boolean isPrimitive() {
        return true;
    }

    public String getStringIdentifier() {
        return this.identifier;
    }

    public ByteString getByteStringIdentifier() {
        return new ByteString(this.identifier);
    }

    public double getStrength() {
        return this.value;
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        return new RealPrimitiveStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, 0.0);
    }

    public RealFeature multiply(double d) {
        return new RealPrimitiveStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, this.value * d);
    }

    public Feature withStrength(double d) {
        return new RealPrimitiveStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, d);
    }

    public Feature encode(String string) {
        if (string == null || string == "String") {
            return this;
        }
        ByteString byteString = this.identifier.length() == 0 ? ByteString.emptyString : new ByteString(this.identifier, string);
        return new RealPrimitiveFeature(this.containingPackage, this.generatingClassifier, byteString, this.value);
    }

    public int hashCode() {
        return 31 * super.hashCode() + 17 * this.identifier.hashCode() + new Double(this.value).hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof RealPrimitiveStringFeature) {
            RealPrimitiveStringFeature realPrimitiveStringFeature = (RealPrimitiveStringFeature)object;
            return this.identifier.equals(realPrimitiveStringFeature.identifier) && this.value == realPrimitiveStringFeature.value;
        }
        RealPrimitiveFeature realPrimitiveFeature = (RealPrimitiveFeature)object;
        return realPrimitiveFeature.identifier.equals(this.identifier) && this.value == realPrimitiveFeature.value;
    }

    public boolean classEquivalent(Feature feature) {
        return feature instanceof RealPrimitiveFeature;
    }

    public int compareTo(Object object) {
        int n = this.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        RealPrimitiveStringFeature realPrimitiveStringFeature = (RealPrimitiveStringFeature)object;
        n = this.identifier.compareTo(realPrimitiveStringFeature.identifier);
        if (n != 0) {
            return n;
        }
        double d = this.value - realPrimitiveStringFeature.value;
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public void write(StringBuffer stringBuffer) {
        this.writeNameString(stringBuffer);
        stringBuffer.append("(");
        stringBuffer.append(this.value);
        stringBuffer.append(")");
    }

    public void writeNameString(StringBuffer stringBuffer) {
        super.writeNameString(stringBuffer);
        stringBuffer.append(":");
        stringBuffer.append(this.identifier);
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeString(this.identifier);
        exceptionlessOutputStream.writeDouble(this.value);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.identifier = exceptionlessInputStream.readString();
        this.value = exceptionlessInputStream.readDouble();
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        exceptionlessOutputStream.writeString(this.identifier.equals(string4) ? null : this.identifier);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.identifier = exceptionlessInputStream.readString();
        if (this.identifier == null) {
            this.identifier = string3;
        }
        this.value = 0.0;
    }
}

