/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.ILPSolver;
import LBJ2.infer.ZeroOneILPProblem;
import LBJ2.util.IVector;
import LBJ2.util.Sort;

public class BalasHook
extends ZeroOneILPProblem
implements ILPSolver {
    private static boolean debug = false;
    protected boolean first;
    protected int verbosity;
    private int[] solution;
    private double objectiveValue;
    private boolean[] negated;
    private int[] x;
    private double[] slack;
    private boolean[] cancelled;

    public BalasHook() {
        this(0);
    }

    public BalasHook(int n) {
        this(false, n);
    }

    public BalasHook(boolean bl) {
        this(bl, 0);
    }

    public BalasHook(boolean bl, int n) {
        this.first = bl;
        this.verbosity = n;
    }

    public BalasHook(String string) {
        this(string, 0);
    }

    public BalasHook(String string, boolean bl) {
        this(string, bl, 0);
    }

    public BalasHook(String string, int n) {
        this(string, false, n);
    }

    public BalasHook(String string, boolean bl, int n) {
        super(string);
        this.first = bl;
        this.verbosity = n;
    }

    public void setFirst(boolean bl) {
        this.first = bl;
    }

    public void reset() {
        super.reset();
        this.x = null;
        this.solution = null;
        this.negated = null;
        this.slack = null;
        this.objectiveValue = Double.POSITIVE_INFINITY;
    }

    protected void addConstraint(int[] nArray, double[] dArray, int n, double d) {
        this.addConstraint(nArray, dArray, d);
    }

    public void addEqualityConstraint(int[] nArray, double[] dArray, double d) {
        this.addLessThanConstraint(nArray, dArray, d);
        this.addGreaterThanConstraint(nArray, dArray, d);
    }

    public void addGreaterThanConstraint(int[] nArray, double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = -dArray[i];
        }
        this.addLessThanConstraint(nArray, dArray, -d);
    }

    public void addLessThanConstraint(int[] nArray, double[] dArray, double d) {
        this.addConstraint(nArray, dArray, d);
    }

    public boolean solve() throws Exception {
        int n;
        int n2 = this.objectiveCoefficients.size();
        int n3 = this.Ac.size();
        if (this.verbosity > 0) {
            System.out.println("  variables: " + n2);
            System.out.println("  constraints: " + n3);
        }
        this.negated = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            double d = this.objectiveCoefficients.get(n);
            if (Math.abs(d) < 1.0E-10) {
                this.objectiveCoefficients.set(n, 0.0);
                continue;
            }
            if (this.maximize) {
                d = -d;
            }
            if (d < 0.0) {
                d = -d;
                for (int i = 0; i < n3; ++i) {
                    int n4 = this.Av.binarySearch(i, n);
                    if (n4 < 0) continue;
                    double d2 = this.Ac.get(i, n4);
                    this.bounds.set(i, this.bounds.get(i) - d2);
                    this.Ac.set(i, n4, -d2);
                }
                this.negated[n] = true;
            }
            this.objectiveCoefficients.set(n, d);
        }
        if (this.verbosity == 2) {
            n = this.maximize ? 1 : 0;
            this.maximize = false;
            StringBuffer stringBuffer = new StringBuffer();
            this.write(stringBuffer);
            System.out.print(stringBuffer);
            this.maximize = n;
        }
        this.x = new int[n2];
        this.slack = this.slack(this.x);
        this.cancelled = new boolean[n2];
        n = this.solve(this.evaluate(this.x)) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            if (!this.negated[i]) continue;
            this.x[i] = 1 - this.x[i];
            this.objectiveValue -= this.objectiveCoefficients.get(i);
        }
        if (this.maximize) {
            this.objectiveValue = -this.objectiveValue;
        }
        return n != 0;
    }

    private double[] slack(int[] nArray) {
        double[] dArray = new double[this.bounds.size()];
        for (int i = 0; i < this.Ac.size(); ++i) {
            double d = 0.0;
            for (int j = 0; j < this.Ac.size(i); ++j) {
                d += (double)nArray[this.Av.get(i, j)] * this.Ac.get(i, j);
            }
            dArray[i] = this.bounds.get(i) - d;
            double d2 = Math.round(dArray[i]);
            if (!(Math.abs(d2 - dArray[i]) < 1.0E-10)) continue;
            dArray[i] = d2;
        }
        return dArray;
    }

    public boolean solve(double d) {
        int n;
        IVector iVector = new IVector();
        for (n = 0; n < this.slack.length; ++n) {
            if (!(this.slack[n] < 0.0)) continue;
            iVector.add(n);
        }
        n = iVector.size();
        if (n == 0) {
            this.solution = (int[])this.x.clone();
            this.objectiveValue = d;
            if (debug) {
                int[] nArray = (int[])this.x.clone();
                double d2 = this.objectiveValue;
                System.out.print("[");
                for (int i = 0; i < nArray.length; ++i) {
                    if (this.negated[i]) {
                        nArray[i] = 1 - nArray[i];
                        d2 -= this.objectiveCoefficients.get(i);
                    }
                    System.out.print(nArray[i]);
                    if (i + 1 >= nArray.length) continue;
                    System.out.print(", ");
                }
                if (this.maximize) {
                    d2 = -d2;
                }
                System.out.println("]: " + d2);
            }
            return true;
        }
        IVector iVector2 = this.getEligibleVariables(d, iVector);
        int n2 = iVector2.size();
        if (n2 == 0) {
            return false;
        }
        IVector iVector3 = new IVector();
        double[] dArray = this.constraintSatisfiability(iVector, iVector2, iVector3);
        if (dArray == null) {
            return false;
        }
        IVector iVector4 = new IVector();
        int[] nArray = null;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 1;
        while (n5 != 0) {
            int n6;
            int n7;
            if (iVector3.size() > 0) {
                bl |= this.satisfyAll(iVector3, d, iVector2);
                n5 = 0;
                continue;
            }
            if (nArray == null) {
                nArray = this.sortVariablesByViolations(iVector2);
            }
            int n8 = iVector2.get(nArray[n3]);
            while (++n3 < n2 && this.cancelled[n8]) {
                n8 = iVector2.get(nArray[n3]);
                --n4;
            }
            if (this.cancelled[n8]) break;
            this.setVariableOn(n8);
            this.cancelled[n8] = true;
            iVector4.add(n8);
            double d3 = this.objectiveValue;
            if (this.first && (bl |= this.solve(d + this.objectiveCoefficients.get(n8)))) break;
            this.setVariableOff(n8);
            IVector iVector5 = new IVector();
            iVector5.add(n8);
            if (d3 != this.objectiveValue) {
                for (n7 = n3; n7 < n2; ++n7) {
                    n6 = iVector2.get(n7);
                    if (this.cancelled[n6] || !(d + this.objectiveCoefficients.get(n6) >= this.objectiveValue - 1.0E-10)) continue;
                    iVector5.add(n6);
                    this.cancelled[n6] = true;
                    iVector4.add(n6);
                }
                n4 += iVector5.size() - 1;
            }
            n5 = n2 - n3 - n4 > 0 ? 1 : 0;
            for (n7 = 0; n7 < n && n5 != 0; ++n7) {
                n6 = iVector.get(n7);
                for (int i = 0; i < iVector5.size(); ++i) {
                    double d4;
                    int n9 = this.Av.binarySearch(n6, iVector5.get(i));
                    if (n9 < 0 || !((d4 = this.Ac.get(n6, n9)) < 0.0)) continue;
                    int n10 = n7;
                    dArray[n10] = dArray[n10] - d4;
                }
                int n11 = n5 = dArray[n7] - 1.0E-10 <= this.slack[n6] ? 1 : 0;
                if (n5 == 0 || !(Math.abs(this.slack[n6] - dArray[n7]) < 1.0E-10)) continue;
                iVector3.add(n6);
            }
        }
        for (n5 = 0; n5 < iVector4.size(); ++n5) {
            this.cancelled[iVector4.get((int)n5)] = false;
        }
        return bl;
    }

    private IVector getEligibleVariables(double d, IVector iVector) {
        IVector iVector2 = new IVector();
        int n = iVector.size();
        for (int i = 0; i < this.x.length; ++i) {
            if (this.cancelled[i] || !(d + this.objectiveCoefficients.get(i) < this.objectiveValue - 1.0E-10)) continue;
            boolean bl = false;
            for (int j = 0; j < n && !bl; ++j) {
                int n2 = iVector.get(j);
                int n3 = this.Av.binarySearch(n2, i);
                bl = n3 >= 0 && this.Ac.get(n2, n3) < 0.0;
            }
            if (!bl) continue;
            iVector2.add(i);
        }
        return iVector2;
    }

    private boolean satisfyAll(IVector iVector, double d, IVector iVector2) {
        int n;
        int n2;
        IVector iVector3 = new IVector();
        int n3 = iVector.size();
        boolean bl = false;
        for (n2 = 0; n2 < n3; ++n2) {
            n = iVector.get(n2);
            int n4 = this.Ac.size(n);
            for (int i = 0; i < n4; ++i) {
                double d2;
                int n5 = this.Av.get(n, i);
                if (this.cancelled[n5] || !((d2 = this.Ac.get(n, i)) < 0.0) || iVector2.binarySearch(n5) < 0) continue;
                iVector3.add(n5);
                this.cancelled[n5] = true;
                d += this.objectiveCoefficients.get(n5);
            }
        }
        n2 = iVector3.size();
        if (d < this.objectiveValue - 1.0E-10) {
            for (n = 0; n < n2; ++n) {
                this.setVariableOn(iVector3.get(n));
            }
            bl = this.solve(d);
            for (n = 0; n < n2; ++n) {
                this.setVariableOff(iVector3.get(n));
            }
        }
        for (n = 0; n < n2; ++n) {
            this.cancelled[iVector3.get((int)n)] = false;
        }
        return bl;
    }

    private double[] constraintSatisfiability(IVector iVector, IVector iVector2, IVector iVector3) {
        int n = iVector.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = iVector.get(i);
            for (int j = 0; j < this.Ac.size(n2); ++j) {
                double d = this.Ac.get(n2, j);
                if (!(d < 0.0) || iVector2.binarySearch(this.Av.get(n2, j)) < 0) continue;
                int n3 = i;
                dArray[n3] = dArray[n3] + d;
            }
            if (dArray[i] - 1.0E-10 > this.slack[n2]) {
                return null;
            }
            if (!(Math.abs(this.slack[n2] - dArray[i]) < 1.0E-10)) continue;
            iVector3.add(n2);
        }
        return dArray;
    }

    private void setVariableOn(int n) {
        this.x[n] = 1;
        for (int i = 0; i < this.slack.length; ++i) {
            int n2 = this.Av.binarySearch(i, n);
            if (n2 < 0) continue;
            int n3 = i;
            this.slack[n3] = this.slack[n3] - this.Ac.get(i, n2);
        }
    }

    private void setVariableOff(int n) {
        this.x[n] = 0;
        for (int i = 0; i < this.slack.length; ++i) {
            int n2 = this.Av.binarySearch(i, n);
            if (n2 < 0) continue;
            int n3 = i;
            this.slack[n3] = this.slack[n3] + this.Ac.get(i, n2);
        }
    }

    private int[] sortVariablesByViolations(final IVector iVector) {
        int n = iVector.size();
        int[] nArray = new int[n];
        final double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
            int n2 = iVector.get(i);
            for (int j = 0; j < this.slack.length; ++j) {
                int n3 = this.Av.binarySearch(j, n2);
                double d = n3 < 0 ? 0.0 : this.Ac.get(j, n3);
                int n4 = i;
                dArray[n4] = dArray[n4] + Math.max(0.0, d - this.slack[j]);
            }
        }
        Sort.sort(nArray, new Sort.IntComparator(){

            public int compare(int n, int n2) {
                if (Math.abs(dArray[n] - dArray[n2]) < 1.0E-10) {
                    double d;
                    double d2 = BalasHook.this.objectiveCoefficients.get(iVector.get(n));
                    if (Math.abs(d2 - (d = BalasHook.this.objectiveCoefficients.get(iVector.get(n2)))) < 1.0E-10) {
                        return n - n2;
                    }
                    if (d2 < d) {
                        return -1;
                    }
                    return 1;
                }
                if (dArray[n] < dArray[n2]) {
                    return -1;
                }
                return 1;
            }
        });
        return nArray;
    }

    public boolean isSolved() {
        return this.solution != null;
    }

    public boolean getBooleanValue(int n) {
        return this.solution[n] == 1;
    }

    public double objectiveValue() {
        return this.objectiveValue;
    }

    public void write(StringBuffer stringBuffer) {
        int n;
        if (this.maximize) {
            stringBuffer.append("max");
        } else {
            stringBuffer.append("min");
        }
        int n2 = this.objectiveCoefficients.size();
        for (n = 0; n < n2; ++n) {
            double d = this.objectiveCoefficients.get(n);
            stringBuffer.append(" ");
            if (d >= 0.0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(d);
            stringBuffer.append(" ");
            if (this.negated[n]) {
                stringBuffer.append("(");
            }
            stringBuffer.append("x_");
            stringBuffer.append(n);
            if (!this.negated[n]) continue;
            stringBuffer.append(")");
        }
        stringBuffer.append("\n");
        n = this.Ac.size();
        for (int i = 0; i < n; ++i) {
            int n3 = this.Ac.size(i);
            stringBuffer.append(" ");
            for (int j = 0; j < n3; ++j) {
                double d = this.Ac.get(i, j);
                stringBuffer.append(" ");
                if (d >= 0.0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append(d);
                stringBuffer.append(" x_");
                stringBuffer.append(this.Av.get(i, j));
            }
            stringBuffer.append(" <= ");
            stringBuffer.append(this.bounds.get(i));
            stringBuffer.append("\n");
        }
    }
}

