/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.AtLeastQuantifier;
import LBJ2.infer.AtMostQuantifier;
import LBJ2.infer.Constraint;
import LBJ2.infer.ExistentialQuantifier;
import LBJ2.infer.FirstOrderConjunction;
import LBJ2.infer.FirstOrderConstant;
import LBJ2.infer.FirstOrderDisjunction;
import LBJ2.infer.FirstOrderDoubleImplication;
import LBJ2.infer.FirstOrderEqualityTwoValues;
import LBJ2.infer.FirstOrderEqualityWithValue;
import LBJ2.infer.FirstOrderEqualityWithVariable;
import LBJ2.infer.FirstOrderImplication;
import LBJ2.infer.FirstOrderNegation;
import LBJ2.infer.FirstOrderVariable;
import LBJ2.infer.PropositionalAtLeast;
import LBJ2.infer.PropositionalConjunction;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalDisjunction;
import LBJ2.infer.PropositionalDoubleImplication;
import LBJ2.infer.PropositionalImplication;
import LBJ2.infer.PropositionalNegation;
import LBJ2.infer.PropositionalVariable;
import LBJ2.infer.QuantifiedConstraintInvocation;
import LBJ2.infer.UniversalQuantifier;
import LBJ2.learn.IdentityNormalizer;
import LBJ2.learn.Learner;
import LBJ2.learn.Normalizer;
import java.util.LinkedHashMap;

public abstract class Inference {
    protected LinkedHashMap variables;
    protected Constraint constraint;
    protected Object head;

    public static String exampleToString(Object object) {
        String string = "";
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            string = string + "[";
            if (objectArray.length > 0) {
                string = string + objectArray[0];
            }
            for (int i = 1; i < objectArray.length; ++i) {
                string = string + ", " + objectArray[i];
            }
            string = string + "]";
        } else {
            string = string + object;
        }
        return string;
    }

    public Inference() {
        this(null);
    }

    public Inference(Object object) {
        this.head = object;
        this.variables = new LinkedHashMap();
    }

    public Object getHead() {
        return this.head;
    }

    protected abstract void infer() throws Exception;

    public abstract String valueOf(Learner var1, Object var2) throws Exception;

    public Normalizer getNormalizer(Learner learner) {
        return new IdentityNormalizer();
    }

    public String getHeadType() {
        return "java.lang.Object";
    }

    public String[] getHeadFinderTypes() {
        return new String[0];
    }

    public boolean satisfied() {
        return this.constraint.evaluate();
    }

    public PropositionalVariable getVariable(PropositionalVariable propositionalVariable) {
        PropositionalVariable propositionalVariable2 = (PropositionalVariable)this.variables.get(propositionalVariable);
        if (propositionalVariable2 == null) {
            propositionalVariable2 = (PropositionalVariable)propositionalVariable.clone();
            this.variables.put(propositionalVariable2, propositionalVariable2);
        }
        return propositionalVariable2;
    }

    public FirstOrderVariable getVariable(FirstOrderVariable firstOrderVariable) {
        FirstOrderVariable firstOrderVariable2 = (FirstOrderVariable)this.variables.get(firstOrderVariable);
        if (firstOrderVariable2 == null) {
            firstOrderVariable2 = (FirstOrderVariable)firstOrderVariable.clone();
            this.variables.put(firstOrderVariable2, firstOrderVariable2);
        }
        return firstOrderVariable2;
    }

    public void visitAll(Constraint constraint) {
        Constraint[] constraintArray = constraint.getChildren();
        for (int i = 0; i < constraintArray.length; ++i) {
            constraintArray[i].runVisit(this);
        }
    }

    public void visit(FirstOrderDoubleImplication firstOrderDoubleImplication) {
        this.visitAll(firstOrderDoubleImplication);
    }

    public void visit(FirstOrderImplication firstOrderImplication) {
        this.visitAll(firstOrderImplication);
    }

    public void visit(FirstOrderConjunction firstOrderConjunction) {
        this.visitAll(firstOrderConjunction);
    }

    public void visit(FirstOrderDisjunction firstOrderDisjunction) {
        this.visitAll(firstOrderDisjunction);
    }

    public void visit(FirstOrderEqualityTwoValues firstOrderEqualityTwoValues) {
        this.visitAll(firstOrderEqualityTwoValues);
    }

    public void visit(FirstOrderEqualityWithValue firstOrderEqualityWithValue) {
        this.visitAll(firstOrderEqualityWithValue);
    }

    public void visit(FirstOrderEqualityWithVariable firstOrderEqualityWithVariable) {
        this.visitAll(firstOrderEqualityWithVariable);
    }

    public void visit(FirstOrderNegation firstOrderNegation) {
        this.visitAll(firstOrderNegation);
    }

    public void visit(FirstOrderConstant firstOrderConstant) {
        this.visitAll(firstOrderConstant);
    }

    public void visit(UniversalQuantifier universalQuantifier) {
        this.visitAll(universalQuantifier);
    }

    public void visit(ExistentialQuantifier existentialQuantifier) {
        this.visitAll(existentialQuantifier);
    }

    public void visit(AtLeastQuantifier atLeastQuantifier) {
        this.visitAll(atLeastQuantifier);
    }

    public void visit(AtMostQuantifier atMostQuantifier) {
        this.visitAll(atMostQuantifier);
    }

    public void visit(QuantifiedConstraintInvocation quantifiedConstraintInvocation) {
        this.visitAll(quantifiedConstraintInvocation);
    }

    public void visit(PropositionalDoubleImplication propositionalDoubleImplication) {
        this.visitAll(propositionalDoubleImplication);
    }

    public void visit(PropositionalImplication propositionalImplication) {
        this.visitAll(propositionalImplication);
    }

    public void visit(PropositionalConjunction propositionalConjunction) {
        this.visitAll(propositionalConjunction);
    }

    public void visit(PropositionalDisjunction propositionalDisjunction) {
        this.visitAll(propositionalDisjunction);
    }

    public void visit(PropositionalAtLeast propositionalAtLeast) {
        this.visitAll(propositionalAtLeast);
    }

    public void visit(PropositionalConstant propositionalConstant) {
        this.visitAll(propositionalConstant);
    }

    public void visit(PropositionalNegation propositionalNegation) {
        this.visitAll(propositionalNegation);
    }

    public void visit(PropositionalVariable propositionalVariable) {
        this.visitAll(propositionalVariable);
    }
}

