/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.Inference;
import LBJ2.infer.PropositionalAtLeast;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.PropositionalDisjunction;
import LBJ2.infer.PropositionalDoubleImplication;
import LBJ2.infer.PropositionalImplication;
import LBJ2.infer.PropositionalNAryConstraint;
import LBJ2.infer.PropositionalNegation;
import LBJ2.infer.PropositionalVariable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class PropositionalConjunction
extends PropositionalNAryConstraint {
    private PropositionalConjunction() {
    }

    public PropositionalConjunction(PropositionalConstraint propositionalConstraint, PropositionalConstraint propositionalConstraint2) {
        this.add(propositionalConstraint);
        this.add(propositionalConstraint2);
    }

    public boolean evaluate() {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            if (((PropositionalConstraint)iterator.next()).evaluate()) continue;
            return false;
        }
        return true;
    }

    public PropositionalConstraint simplify() {
        return this.simplify(false);
    }

    public PropositionalConstraint simplify(boolean bl) {
        PropositionalConjunction propositionalConjunction = new PropositionalConjunction();
        if (bl) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                PropositionalConstraint propositionalConstraint = (PropositionalConstraint)iterator.next();
                if (propositionalConstraint instanceof PropositionalDoubleImplication) {
                    PropositionalDoubleImplication propositionalDoubleImplication = (PropositionalDoubleImplication)propositionalConstraint;
                    propositionalDoubleImplication.left = propositionalDoubleImplication.left.simplify();
                    propositionalDoubleImplication.right = propositionalDoubleImplication.right.simplify();
                    if (propositionalDoubleImplication.left.equals(propositionalDoubleImplication.right)) {
                        propositionalConstraint = PropositionalConstant.True;
                    } else if (propositionalDoubleImplication.left.equals(PropositionalConstant.False)) {
                        propositionalConstraint = propositionalDoubleImplication.right.negate().simplify();
                    } else if (propositionalDoubleImplication.left.equals(PropositionalConstant.True)) {
                        propositionalConstraint = propositionalDoubleImplication.right;
                    } else if (propositionalDoubleImplication.right.equals(PropositionalConstant.False)) {
                        propositionalConstraint = propositionalDoubleImplication.left.negate().simplify();
                    } else if (propositionalDoubleImplication.right.equals(PropositionalConstant.True)) {
                        propositionalConstraint = propositionalDoubleImplication.left;
                    }
                } else {
                    propositionalConstraint = propositionalConstraint.simplify();
                }
                propositionalConjunction.add(propositionalConstraint);
            }
        } else {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                propositionalConjunction.add(((PropositionalConstraint)iterator.next()).simplify());
            }
        }
        if (propositionalConjunction.children.contains(PropositionalConstant.False)) {
            return PropositionalConstant.False;
        }
        propositionalConjunction.children.remove(PropositionalConstant.True);
        if (propositionalConjunction.children.size() == 1) {
            return (PropositionalConstraint)propositionalConjunction.children.iterator().next();
        }
        if (propositionalConjunction.children.size() == 0) {
            return PropositionalConstant.True;
        }
        return propositionalConjunction;
    }

    public PropositionalConstraint negate() {
        if (this.children.size() == 1) {
            return ((PropositionalConstraint)this.children.iterator().next()).negate();
        }
        PropositionalConstraint[] propositionalConstraintArray = this.children.toArray(new PropositionalConstraint[this.children.size()]);
        for (int i = 0; i < propositionalConstraintArray.length; ++i) {
            propositionalConstraintArray[i] = propositionalConstraintArray[i].negate();
        }
        PropositionalDisjunction propositionalDisjunction = new PropositionalDisjunction(propositionalConstraintArray[0], propositionalConstraintArray[1]);
        for (int i = 2; i < propositionalConstraintArray.length; ++i) {
            propositionalDisjunction.add(propositionalConstraintArray[i]);
        }
        return propositionalDisjunction;
    }

    public PropositionalConstraint CNF() {
        PropositionalConjunction propositionalConjunction = new PropositionalConjunction();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            propositionalConjunction.add(((PropositionalConstraint)iterator.next()).CNF());
        }
        return propositionalConjunction.simplify();
    }

    public PropositionalConstraint DNF() {
        PropositionalConstraint propositionalConstraint;
        PropositionalConstraint propositionalConstraint2 = this.factor();
        if (!(propositionalConstraint2 instanceof PropositionalConjunction)) {
            return propositionalConstraint2.DNF();
        }
        PropositionalConjunction propositionalConjunction = (PropositionalConjunction)propositionalConstraint2;
        PropositionalConjunction propositionalConjunction2 = new PropositionalConjunction();
        PropositionalConstraint[][] propositionalConstraintArray = propositionalConjunction.children.iterator();
        while (propositionalConstraintArray.hasNext()) {
            propositionalConjunction2.add(((PropositionalConstraint)propositionalConstraintArray.next()).DNF());
        }
        if (propositionalConjunction2.children.size() == 1) {
            return (PropositionalConstraint)propositionalConjunction2.getChildren()[0];
        }
        propositionalConstraintArray = new PropositionalConstraint[propositionalConjunction2.children.size()][];
        int n = 0;
        boolean bl = false;
        Object object = propositionalConjunction2.children.iterator();
        while (object.hasNext()) {
            propositionalConstraint = (PropositionalConstraint)object.next();
            if (propositionalConstraint instanceof PropositionalDisjunction) {
                propositionalConstraintArray[n] = (PropositionalConstraint[])propositionalConstraint.getChildren();
                bl = true;
            } else {
                propositionalConstraintArray[n] = new PropositionalConstraint[1];
                propositionalConstraintArray[n][0] = propositionalConstraint;
            }
            ++n;
        }
        if (!bl) {
            return propositionalConjunction2;
        }
        object = new int[propositionalConstraintArray.length];
        propositionalConstraint = new PropositionalConjunction(propositionalConstraintArray[0][0], propositionalConstraintArray[1][0]);
        for (n = 2; n < propositionalConstraintArray.length; ++n) {
            propositionalConstraint = new PropositionalConjunction(propositionalConstraint, propositionalConstraintArray[n][0]);
        }
        while (PropositionalDisjunction.increment(propositionalConstraintArray, (int[])object)) {
            PropositionalConjunction propositionalConjunction3 = new PropositionalConjunction(propositionalConstraintArray[0][object[0]], propositionalConstraintArray[1][object[1]]);
            for (n = 2; n < propositionalConstraintArray.length; ++n) {
                propositionalConjunction3 = new PropositionalConjunction(propositionalConjunction3, propositionalConstraintArray[n][object[n]]);
            }
            propositionalConstraint = new PropositionalDisjunction(propositionalConstraint, propositionalConjunction3);
        }
        return propositionalConstraint;
    }

    public boolean moreGeneralThan(PropositionalConstraint propositionalConstraint) {
        return propositionalConstraint.moreSpecificThan(this);
    }

    public boolean moreSpecificThan(PropositionalImplication propositionalImplication) {
        return this.size() > 1 && this.contains(propositionalImplication);
    }

    public boolean moreSpecificThan(PropositionalDoubleImplication propositionalDoubleImplication) {
        return this.size() > 1 && this.contains(propositionalDoubleImplication);
    }

    public boolean moreSpecificThan(PropositionalConjunction propositionalConjunction) {
        return this.size() > propositionalConjunction.size() && this.containsAll(propositionalConjunction);
    }

    public boolean moreSpecificThan(PropositionalDisjunction propositionalDisjunction) {
        return this.size() > 1 && this.contains(propositionalDisjunction);
    }

    public boolean moreSpecificThan(PropositionalAtLeast propositionalAtLeast) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalNegation propositionalNegation) {
        return this.size() > 1 && this.contains(propositionalNegation);
    }

    public boolean moreSpecificThan(PropositionalVariable propositionalVariable) {
        return this.size() > 1 && this.contains(propositionalVariable);
    }

    public boolean moreSpecificThan(PropositionalConstant propositionalConstant) {
        return propositionalConstant.evaluate();
    }

    public void add(PropositionalConstraint propositionalConstraint) {
        if (propositionalConstraint instanceof PropositionalConjunction) {
            PropositionalConstraint[] propositionalConstraintArray = (PropositionalConstraint[])propositionalConstraint.getChildren();
            for (int i = 0; i < propositionalConstraintArray.length; ++i) {
                this.add(propositionalConstraintArray[i]);
            }
        } else {
            this.children.add(propositionalConstraint);
        }
    }

    public PropositionalConstraint factor() {
        PropositionalConstraint propositionalConstraint = this.simplify();
        if (!(propositionalConstraint instanceof PropositionalConjunction)) {
            return propositionalConstraint;
        }
        PropositionalConjunction propositionalConjunction = (PropositionalConjunction)propositionalConstraint;
        PropositionalConstraint[] propositionalConstraintArray = new PropositionalConstraint[]{};
        while (propositionalConstraintArray != null) {
            Object object;
            int n;
            int n2 = -1;
            int n3 = -1;
            propositionalConstraintArray = null;
            PropositionalConstraint[] propositionalConstraintArray2 = (PropositionalConstraint[])propositionalConjunction.getChildren();
            Arrays.sort(propositionalConstraintArray2, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object instanceof PropositionalDisjunction) {
                        if (object2 instanceof PropositionalDisjunction) {
                            return 0;
                        }
                        return -1;
                    }
                    if (object2 instanceof PropositionalDisjunction) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (int i = 0; i < propositionalConstraintArray2.length - 1 && propositionalConstraintArray2[i] instanceof PropositionalDisjunction; ++i) {
                for (n = i + 1; n < propositionalConstraintArray2.length; ++n) {
                    object = ((PropositionalDisjunction)propositionalConstraintArray2[i]).intersect(propositionalConstraintArray2[n]);
                    if (object == null || propositionalConstraintArray != null && ((PropositionalConstraint[])object).length <= propositionalConstraintArray.length) continue;
                    propositionalConstraintArray = object;
                    n2 = i;
                    n3 = n;
                }
            }
            if (propositionalConstraintArray == null) continue;
            PropositionalConstraint propositionalConstraint2 = null;
            if (propositionalConstraintArray.length == 1) {
                propositionalConstraint2 = propositionalConstraintArray[0];
            } else {
                propositionalConstraint2 = new PropositionalDisjunction(propositionalConstraintArray[0], propositionalConstraintArray[1]);
                for (n = 2; n < propositionalConstraintArray.length; ++n) {
                    propositionalConstraint2 = new PropositionalDisjunction(propositionalConstraint2, propositionalConstraintArray[n]);
                }
            }
            if (propositionalConstraintArray2[n3] instanceof PropositionalDisjunction) {
                PropositionalConstraint propositionalConstraint3 = ((PropositionalDisjunction)propositionalConstraintArray2[n2]).subtract(propositionalConstraintArray);
                object = ((PropositionalDisjunction)propositionalConstraintArray2[n3]).subtract(propositionalConstraintArray);
                propositionalConstraint2 = new PropositionalDisjunction(propositionalConstraint2, new PropositionalConjunction(propositionalConstraint3, (PropositionalConstraint)object)).simplify();
            }
            propositionalConjunction.children.remove(propositionalConstraintArray2[n2]);
            propositionalConjunction.children.remove(propositionalConstraintArray2[n3]);
            propositionalConjunction.add(propositionalConstraint2);
        }
        if (propositionalConjunction.children.size() == 1) {
            return (PropositionalConstraint)propositionalConjunction.getChildren()[0];
        }
        return propositionalConjunction;
    }

    public PropositionalConstraint[] intersect(PropositionalConstraint propositionalConstraint) {
        if (!(propositionalConstraint instanceof PropositionalConjunction)) {
            if (this.children.contains(propositionalConstraint)) {
                return new PropositionalConstraint[]{propositionalConstraint};
            }
            return null;
        }
        PropositionalConjunction propositionalConjunction = (PropositionalConjunction)propositionalConstraint;
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!propositionalConjunction.children.contains(e)) continue;
            linkedList.add(e);
        }
        if (linkedList.size() == 0) {
            return null;
        }
        return linkedList.toArray(new PropositionalConstraint[linkedList.size()]);
    }

    public PropositionalConstraint subtract(PropositionalConstraint[] propositionalConstraintArray) {
        PropositionalConjunction propositionalConjunction = (PropositionalConjunction)this.clone();
        for (int i = 0; i < propositionalConstraintArray.length; ++i) {
            propositionalConjunction.children.remove(propositionalConstraintArray[i]);
        }
        if (propositionalConjunction.children.size() == 0) {
            return new PropositionalConstant(true);
        }
        if (propositionalConjunction.children.size() == 1) {
            return (PropositionalConstraint)propositionalConjunction.getChildren()[0];
        }
        return propositionalConjunction;
    }

    public PropositionalConstraint distribute(PropositionalDisjunction propositionalDisjunction) {
        PropositionalConstraint[] propositionalConstraintArray = this.children.toArray(new PropositionalConstraint[this.children.size()]);
        for (int i = 0; i < propositionalConstraintArray.length; ++i) {
            PropositionalDisjunction propositionalDisjunction2 = (PropositionalDisjunction)propositionalDisjunction.clone();
            propositionalDisjunction2.add(propositionalConstraintArray[i]);
            propositionalConstraintArray[i] = propositionalDisjunction2;
        }
        if (propositionalConstraintArray.length == 1) {
            return propositionalConstraintArray[0].simplify();
        }
        PropositionalConjunction propositionalConjunction = new PropositionalConjunction(propositionalConstraintArray[0], propositionalConstraintArray[1]);
        for (int i = 2; i < propositionalConstraintArray.length; ++i) {
            propositionalConjunction.add(propositionalConstraintArray[i]);
        }
        return propositionalConjunction.simplify();
    }

    public boolean containsAll(PropositionalConjunction propositionalConjunction) {
        return this.children.containsAll(propositionalConjunction.children);
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropositionalConjunction)) {
            return false;
        }
        PropositionalConjunction propositionalConjunction = (PropositionalConjunction)object;
        return this.children.equals(propositionalConjunction.children);
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }

    public void write(StringBuffer stringBuffer) {
        stringBuffer.append("(");
        PropositionalConstraint[] propositionalConstraintArray = (PropositionalConstraint[])this.getChildren();
        propositionalConstraintArray[0].write(stringBuffer);
        for (int i = 1; i < propositionalConstraintArray.length; ++i) {
            stringBuffer.append(" /\\ ");
            propositionalConstraintArray[i].write(stringBuffer);
        }
        stringBuffer.append(")");
    }
}

