/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.Constraint;
import LBJ2.infer.FirstOrderConstraint;
import LBJ2.infer.Inference;
import LBJ2.infer.InvocationArgumentReplacer;
import LBJ2.infer.ParameterizedConstraint;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import java.util.AbstractMap;
import java.util.Vector;

public class QuantifiedConstraintInvocation
extends FirstOrderConstraint {
    protected ParameterizedConstraint parameterized;
    protected InvocationArgumentReplacer replacer;
    protected FirstOrderConstraint constraint;

    public QuantifiedConstraintInvocation(ParameterizedConstraint parameterizedConstraint, InvocationArgumentReplacer invocationArgumentReplacer) {
        this.parameterized = parameterizedConstraint;
        this.replacer = invocationArgumentReplacer;
    }

    public boolean evaluate() {
        return this.constraint != null && this.constraint.evaluate();
    }

    public void consolidateVariables(AbstractMap abstractMap) {
        if (this.constraint != null) {
            this.constraint.consolidateVariables(abstractMap);
        }
    }

    public void setQuantificationVariables(Vector vector) {
        if (this.replacer == null) {
            System.err.println("LBJ ERROR: Attempting to set quantification variable with no variable setter implementation provided.");
            System.exit(1);
        }
        this.replacer.setQuantificationVariables(vector);
        this.constraint = this.parameterized.makeConstraint(this.replacer.compute());
    }

    public Constraint[] getChildren() {
        return new FirstOrderConstraint[0];
    }

    public PropositionalConstraint propositionalize() {
        if (this.constraint == null) {
            return new PropositionalConstant(false);
        }
        return this.constraint.propositionalize();
    }

    public int hashCode() {
        return this.parameterized.hashCode() + this.replacer.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof QuantifiedConstraintInvocation)) {
            return false;
        }
        QuantifiedConstraintInvocation quantifiedConstraintInvocation = (QuantifiedConstraintInvocation)object;
        return this.parameterized.equals(quantifiedConstraintInvocation.parameterized) && this.replacer == quantifiedConstraintInvocation.replacer;
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }
}

