/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.Constraint;
import LBJ2.infer.FirstOrderConstraint;
import LBJ2.infer.QuantifierArgumentReplacer;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class Quantifier
extends FirstOrderConstraint {
    protected String quantificationVariable;
    protected Collection collection;
    protected FirstOrderConstraint constraint;
    protected Vector enclosingQuantificationSettings;
    protected QuantifierArgumentReplacer replacer;

    public Quantifier(String string, Collection collection, FirstOrderConstraint firstOrderConstraint) {
        this(string, collection, firstOrderConstraint, null);
    }

    public Quantifier(String string, Collection collection, FirstOrderConstraint firstOrderConstraint, QuantifierArgumentReplacer quantifierArgumentReplacer) {
        this.quantificationVariable = string;
        this.collection = collection;
        this.constraint = firstOrderConstraint;
        this.replacer = quantifierArgumentReplacer;
    }

    public Constraint[] getChildren() {
        return new FirstOrderConstraint[]{this.constraint};
    }

    protected int initialize() {
        if (this.enclosingQuantificationSettings == null) {
            this.enclosingQuantificationSettings = new Vector();
        }
        this.enclosingQuantificationSettings.add(null);
        return this.enclosingQuantificationSettings.size() - 1;
    }

    public void consolidateVariables(AbstractMap abstractMap) {
        int n = this.initialize();
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            this.enclosingQuantificationSettings.set(n, iterator.next());
            this.constraint.setQuantificationVariables(this.enclosingQuantificationSettings);
            this.constraint.consolidateVariables(abstractMap);
        }
        this.enclosingQuantificationSettings.removeElementAt(n);
    }

    public int hashCode() {
        int n = this.constraint.hashCode();
        n = this.replacer != null ? (n += this.replacer.hashCode()) : (n += ((Object)this.collection).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Quantifier)) {
            return false;
        }
        Quantifier quantifier = (Quantifier)object;
        return this.replacer == quantifier.replacer && (this.replacer != null || this.replacer == null && ((Object)this.collection).equals(quantifier.collection)) && this.constraint.equals(quantifier.constraint);
    }
}

