/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.learn.Accuracy;
import LBJ2.learn.Learner;
import LBJ2.learn.Lexicon;
import LBJ2.learn.TestingMetric;
import LBJ2.parse.ArrayFileParser;
import LBJ2.parse.FoldParser;
import LBJ2.parse.FoldSeparator;
import LBJ2.parse.Parser;
import LBJ2.util.ExceptionlessOutputStream;
import LBJ2.util.Sort;
import LBJ2.util.StudentT;
import LBJ2.util.TableFormat;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BatchTrainer {
    protected Learner learner;
    protected Parser parser;
    protected int progressOutput;
    protected String messageIndent;
    protected Class learnerClass;
    protected Field fieldIsTraining;
    protected int examples;
    protected int lexiconSize;

    public static void writeExample(ExceptionlessOutputStream exceptionlessOutputStream, int[] nArray, double[] dArray, int[] nArray2, double[] dArray2) {
        BatchTrainer.writeExample(exceptionlessOutputStream, nArray, dArray, nArray2, dArray2, nArray.length, null);
    }

    public static void writeExample(ExceptionlessOutputStream exceptionlessOutputStream, int[] nArray, double[] dArray, int[] nArray2, double[] dArray2, int n) {
        BatchTrainer.writeExample(exceptionlessOutputStream, nArray, dArray, nArray2, dArray2, n, null);
    }

    public static void writeExample(ExceptionlessOutputStream exceptionlessOutputStream, int[] nArray, double[] dArray, int[] nArray2, double[] dArray2, Lexicon lexicon) {
        BatchTrainer.writeExample(exceptionlessOutputStream, nArray, dArray, nArray2, dArray2, nArray.length, lexicon);
    }

    public static void writeExample(ExceptionlessOutputStream exceptionlessOutputStream, final int[] nArray, double[] dArray, int[] nArray2, double[] dArray2, int n, final Lexicon lexicon) {
        int n2;
        int[] nArray3 = null;
        if (lexicon != null) {
            nArray3 = new int[nArray.length];
            for (n2 = 0; n2 < nArray3.length; ++n2) {
                nArray3[n2] = n2;
            }
            Sort.sort(nArray3, 0, n, new Sort.IntComparator(){

                public int compare(int n, int n2) {
                    return lexicon.lookupKey(nArray[n]).compareTo(lexicon.lookupKey(nArray[n2]));
                }
            });
        }
        exceptionlessOutputStream.writeInt(nArray2.length);
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            exceptionlessOutputStream.writeInt(nArray2[n2]);
            exceptionlessOutputStream.writeDouble(dArray2[n2]);
        }
        exceptionlessOutputStream.writeInt(n);
        exceptionlessOutputStream.writeInt(nArray.length - n);
        if (lexicon == null) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                exceptionlessOutputStream.writeInt(nArray[n2]);
                exceptionlessOutputStream.writeDouble(dArray[n2]);
            }
        } else {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                exceptionlessOutputStream.writeInt(nArray[nArray3[n2]]);
                exceptionlessOutputStream.writeDouble(dArray[nArray3[n2]]);
            }
        }
    }

    public BatchTrainer(Learner learner, String string) {
        this(learner, string, true);
    }

    public BatchTrainer(Learner learner, String string, int n) {
        this(learner, string, true, n);
    }

    public BatchTrainer(Learner learner, String string, int n, String string2) {
        this(learner, string, true, n, string2);
    }

    public BatchTrainer(Learner learner, String string, boolean bl) {
        this(learner, new ArrayFileParser(string, bl));
    }

    public BatchTrainer(Learner learner, String string, boolean bl, int n) {
        this(learner, new ArrayFileParser(string, bl), n);
    }

    public BatchTrainer(Learner learner, String string, boolean bl, int n, String string2) {
        this(learner, new ArrayFileParser(string, bl), n, string2);
    }

    public BatchTrainer(Learner learner, Parser parser) {
        this(learner, parser, 0);
    }

    public BatchTrainer(Learner learner, Parser parser, int n) {
        this(learner, parser, n, "");
    }

    public BatchTrainer(Learner learner, Parser parser, int n, String string) {
        this.learner = learner;
        this.parser = parser;
        this.progressOutput = n;
        this.messageIndent = string;
        this.learnerClass = this.learner.getClass();
        try {
            this.fieldIsTraining = this.learnerClass.getField("isTraining");
        }
        catch (Exception exception) {
            System.err.println("Can't access " + this.learnerClass + "'s 'isTraining' field: " + exception);
            System.exit(1);
        }
    }

    public int getProgressOutput() {
        return this.progressOutput;
    }

    public Parser getParser() {
        return this.parser;
    }

    protected void setIsTraining(boolean bl) {
        try {
            this.fieldIsTraining.setBoolean(null, bl);
        }
        catch (Exception exception) {
            System.err.println("Can't set " + this.learnerClass + "'s 'isTraining' field: " + exception);
            System.exit(1);
        }
    }

    protected boolean getIsTraining() {
        try {
            return this.fieldIsTraining.getBoolean(null);
        }
        catch (Exception exception) {
            System.err.println("Can't get " + this.learnerClass + "'s 'isTraining' field: " + exception);
            System.exit(1);
            return false;
        }
    }

    public Lexicon preExtract(String string) {
        return this.preExtract(string, true);
    }

    public Lexicon preExtract(String string, boolean bl) {
        Learner learner = this.preExtract(string, bl, Lexicon.CountPolicy.none);
        learner.saveLexicon();
        return learner.getLexicon();
    }

    public Learner preExtract(String string, Lexicon.CountPolicy countPolicy) {
        return this.preExtract(string, true, countPolicy);
    }

    public Learner preExtract(String string, boolean bl, Lexicon.CountPolicy countPolicy) {
        Object object;
        boolean bl2;
        File file;
        File file2;
        ByteArrayOutputStream byteArrayOutputStream;
        ExceptionlessOutputStream exceptionlessOutputStream;
        Lexicon lexicon;
        Learner learner;
        block24: {
            learner = this.learner.emptyClone();
            learner.setLabelLexicon(this.learner.getLabelLexicon());
            lexicon = this.learner.getLexicon();
            learner.setLexicon(lexicon);
            learner.countFeatures(countPolicy);
            this.learner.setLexicon(null);
            this.setIsTraining(true);
            this.examples = 0;
            exceptionlessOutputStream = null;
            byteArrayOutputStream = null;
            file2 = null;
            file = null;
            bl2 = false;
            if (string != null) {
                file2 = new File(string);
                if (file2.exists()) {
                    int n = string.lastIndexOf(File.separatorChar);
                    try {
                        file = n == -1 ? File.createTempFile("LBJ", null) : File.createTempFile("LBJ", null, new File(string.substring(0, n)));
                    }
                    catch (Exception exception) {
                        System.err.println("LBJ ERROR: BatchTrainer.preExtract: Can't create temporary file: " + exception);
                        System.exit(1);
                    }
                    file.deleteOnExit();
                    bl2 = true;
                } else {
                    file = file2;
                }
                try {
                    if (bl) {
                        exceptionlessOutputStream = ExceptionlessOutputStream.openCompressedStream(file.toURI().toURL());
                        break block24;
                    }
                    exceptionlessOutputStream = ExceptionlessOutputStream.openBufferedStream(file.toURI().toURL());
                }
                catch (Exception exception) {
                    System.err.println("LBJ ERROR: BatchTrainer.preExtract: Can't convert file name '" + file + "' to URL: " + exception);
                    System.exit(1);
                }
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream(262144);
                if (bl) {
                    ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
                    try {
                        zipOutputStream.putNextEntry(new ZipEntry("LBJFile"));
                    }
                    catch (Exception exception) {
                        System.err.println("ERROR: Can't create in-memory zip data:");
                        exception.printStackTrace();
                        System.exit(1);
                    }
                    exceptionlessOutputStream = new ExceptionlessOutputStream(new BufferedOutputStream(zipOutputStream));
                } else {
                    exceptionlessOutputStream = new ExceptionlessOutputStream(byteArrayOutputStream);
                }
            }
        }
        boolean bl3 = this.parser instanceof ArrayFileParser;
        if (bl3) {
            ((ArrayFileParser)this.parser).setIncludePruned(true);
        }
        Object object2 = this.parser.next();
        while (object2 != null) {
            if (this.progressOutput > 0 && this.examples % this.progressOutput == 0) {
                System.out.println("  " + this.learner.name + ", pre-extract: " + this.messageIndent + this.examples + " examples at " + new Date());
            }
            if (object2 == FoldSeparator.separator) {
                exceptionlessOutputStream.writeInt(-1);
            } else {
                ++this.examples;
                object = bl3 ? (Object[])object2 : learner.getExampleArray(object2);
                int[] nArray = (int[])object[0];
                double[] dArray = (double[])object[1];
                int[] nArray2 = (int[])object[2];
                double[] dArray2 = (double[])object[3];
                if (bl3 && countPolicy != Lexicon.CountPolicy.none) {
                    int n = countPolicy == Lexicon.CountPolicy.perClass ? nArray2[0] : -1;
                    for (int i = 0; i < nArray.length; ++i) {
                        lexicon.lookup(lexicon.lookupKey(nArray[i]), true, n);
                    }
                }
                BatchTrainer.writeExample(exceptionlessOutputStream, nArray, dArray, nArray2, dArray2, lexicon);
            }
            object2 = this.parser.next();
        }
        if (this.progressOutput > 0) {
            System.out.println("  " + this.learner.name + ", pre-extract: " + this.messageIndent + this.examples + " examples at " + new Date());
        }
        this.parser.close();
        exceptionlessOutputStream.close();
        if (bl2) {
            try {
                object2 = new FileInputStream(file).getChannel();
                object = new FileOutputStream(file2).getChannel();
                ((FileChannel)object2).transferTo(0L, file.length(), (WritableByteChannel)object);
                ((AbstractInterruptibleChannel)object2).close();
                ((AbstractInterruptibleChannel)object).close();
            }
            catch (Exception exception) {
                System.err.println("LBJ ERROR: Can't copy example file:");
                exception.printStackTrace();
                System.exit(1);
            }
        }
        this.setIsTraining(false);
        this.lexiconSize = learner.getLexicon().size();
        this.parser = file != null ? new ArrayFileParser(file.getPath(), bl) : new ArrayFileParser(byteArrayOutputStream.toByteArray(), bl);
        this.learner.setLabelLexicon(learner.getLabelLexicon());
        return learner;
    }

    public void fillInSizes() {
        if (this.parser instanceof ArrayFileParser) {
            ArrayFileParser arrayFileParser = (ArrayFileParser)this.parser;
            this.examples = arrayFileParser.getNumExamples();
        } else {
            this.examples = 0;
        }
        this.lexiconSize = this.learner.getPrunedLexiconSize();
    }

    public void pruneDataset(String string, Lexicon.PruningPolicy pruningPolicy, Learner learner) {
        this.pruneDataset(string, true, pruningPolicy, learner);
    }

    public void pruneDataset(String string, boolean bl, Lexicon.PruningPolicy pruningPolicy, Learner learner) {
        Object object;
        boolean bl2;
        File file;
        File file2;
        ByteArrayOutputStream byteArrayOutputStream;
        ExceptionlessOutputStream exceptionlessOutputStream;
        int[] nArray;
        ArrayFileParser arrayFileParser;
        Lexicon lexicon;
        block27: {
            lexicon = learner.getLexicon();
            if (!pruningPolicy.isNone() && lexicon.getCountPolicy() == Lexicon.CountPolicy.none) {
                throw new IllegalArgumentException("LBJ ERROR: BatchTrainer.pruneDataset: Can't prune with policy '" + pruningPolicy + "' if features haven't been counted.");
            }
            if (!(this.parser instanceof ArrayFileParser)) {
                throw new IllegalArgumentException("LBJ ERROR: BatchTrainer.pruneDataset can't be called unless feature pre-extraction has already been performed.");
            }
            arrayFileParser = (ArrayFileParser)this.parser;
            arrayFileParser.setIncludePruned(true);
            nArray = lexicon.prune(pruningPolicy);
            exceptionlessOutputStream = null;
            byteArrayOutputStream = null;
            file2 = null;
            file = null;
            bl2 = false;
            if (string != null) {
                file2 = new File(string);
                if (file2.exists()) {
                    int n = string.lastIndexOf(File.separatorChar);
                    try {
                        file = n == -1 ? File.createTempFile("LBJ", null) : File.createTempFile("LBJ", null, new File(string.substring(0, n)));
                    }
                    catch (Exception exception) {
                        System.err.println("LBJ ERROR: BatchTrainer.preExtract: Can't create temporary file: " + exception);
                        System.exit(1);
                    }
                    file.deleteOnExit();
                    bl2 = true;
                } else {
                    file = file2;
                }
                try {
                    if (bl) {
                        exceptionlessOutputStream = ExceptionlessOutputStream.openCompressedStream(file.toURI().toURL());
                        break block27;
                    }
                    exceptionlessOutputStream = ExceptionlessOutputStream.openBufferedStream(file.toURI().toURL());
                }
                catch (Exception exception) {
                    System.err.println("LBJ ERROR: BatchTrainer.preExtract: Can't convert file name '" + file + "' to URL: " + exception);
                    System.exit(1);
                }
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream(262144);
                if (bl) {
                    ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
                    try {
                        zipOutputStream.putNextEntry(new ZipEntry("LBJFile"));
                    }
                    catch (Exception exception) {
                        System.err.println("ERROR: Can't create in-memory zip data:");
                        exception.printStackTrace();
                        System.exit(1);
                    }
                    exceptionlessOutputStream = new ExceptionlessOutputStream(new BufferedOutputStream(zipOutputStream));
                } else {
                    exceptionlessOutputStream = new ExceptionlessOutputStream(byteArrayOutputStream);
                }
            }
        }
        this.examples = 0;
        Object object2 = arrayFileParser.next();
        while (object2 != null) {
            if (this.progressOutput > 0 && this.examples % this.progressOutput == 0) {
                System.out.println("  " + this.learner.name + ", pruning: " + this.examples + " examples at " + new Date());
            }
            if (object2 == FoldSeparator.separator) {
                exceptionlessOutputStream.writeInt(-1);
            } else {
                ++this.examples;
                object = (Object[])object2;
                int[] nArray2 = (int[])object[0];
                double[] dArray = (double[])object[1];
                int[] nArray3 = (int[])object[2];
                double[] dArray2 = (double[])object[3];
                int n = nArray2.length;
                if (nArray != null) {
                    int n2;
                    for (n2 = 0; n2 < nArray2.length; ++n2) {
                        nArray2[n2] = nArray[nArray2[n2]];
                    }
                    while (n > 0 && lexicon.isPruned(nArray2[n - 1], nArray3[0], pruningPolicy)) {
                        --n;
                    }
                    for (n2 = n - 2; n2 >= 0; --n2) {
                        if (!lexicon.isPruned(nArray2[n2], nArray3[0], pruningPolicy)) continue;
                        int n3 = nArray2[n2];
                        nArray2[n2] = nArray2[--n];
                        nArray2[n] = n3;
                        double d = dArray[n2];
                        dArray[n2] = dArray[n];
                        dArray[n] = d;
                    }
                }
                BatchTrainer.writeExample(exceptionlessOutputStream, nArray2, dArray, nArray3, dArray2, n, lexicon);
            }
            object2 = arrayFileParser.next();
        }
        if (this.progressOutput > 0) {
            System.out.println("  " + this.learner.name + ", pruning: " + this.examples + " examples at " + new Date());
        }
        this.parser.close();
        exceptionlessOutputStream.close();
        if (bl2) {
            try {
                object2 = new FileInputStream(file).getChannel();
                object = new FileOutputStream(file2).getChannel();
                ((FileChannel)object2).transferTo(0L, file.length(), (WritableByteChannel)object);
                ((AbstractInterruptibleChannel)object2).close();
                ((AbstractInterruptibleChannel)object).close();
            }
            catch (Exception exception) {
                System.err.println("LBJ ERROR: Can't copy example file:");
                exception.printStackTrace();
                System.exit(1);
            }
        }
        this.lexiconSize = lexicon.getCutoff();
        learner.saveLexicon();
        this.parser = file != null ? new ArrayFileParser(file.getPath(), bl) : new ArrayFileParser(byteArrayOutputStream.toByteArray(), bl);
    }

    public void train(int n) {
        this.train(1, n);
    }

    public void train(int n, int n2) {
        this.train(n, n2, new DoneWithRound(){

            public void doneWithRound(int n) {
            }
        });
    }

    public void train(int n, DoneWithRound doneWithRound) {
        this.train(1, n, doneWithRound);
    }

    public void train(int n, int n2, DoneWithRound doneWithRound) {
        if (this.lexiconSize > 0) {
            this.learner.initialize(this.parser instanceof FoldParser ? 0 : this.examples, this.lexiconSize);
        } else {
            this.setIsTraining(true);
        }
        for (int i = n; i <= n2; ++i) {
            int n3 = 0;
            Object object = this.parser.next();
            while (object != null) {
                if (object != FoldSeparator.separator) {
                    if (this.progressOutput > 0 && n3 % this.progressOutput == 0) {
                        System.out.print("  " + this.learner.name + ": " + this.messageIndent);
                        if (n2 != 1) {
                            System.out.print("Round " + i + ", ");
                        }
                        System.out.println(n3 + " examples processed at " + new Date());
                    }
                    this.learner.learn(object);
                    ++n3;
                }
                object = this.parser.next();
            }
            if (this.progressOutput > 0) {
                System.out.print("  " + this.learner.name + ": " + this.messageIndent);
                if (n2 != 1) {
                    System.out.print("Round " + i + ", ");
                }
                System.out.println(n3 + " examples processed at " + new Date());
            }
            this.parser.reset();
            this.learner.doneWithRound();
            doneWithRound.doneWithRound(i);
        }
        this.learner.doneLearning();
        if (this.lexiconSize == 0) {
            this.setIsTraining(false);
        }
    }

    public double[][] crossValidation(final int[] nArray, int n, FoldParser.SplitPolicy splitPolicy, double d, final TestingMetric testingMetric, boolean bl) {
        int n2;
        if (n <= 1 && splitPolicy != FoldParser.SplitPolicy.manual) {
            throw new IllegalArgumentException("LBJ ERROR: BatchTrainer.crossValidation: if the data splitting policy is not 'Manual', the number of folds must be greater than 1.");
        }
        if (splitPolicy == FoldParser.SplitPolicy.manual) {
            n = -1;
        }
        Arrays.sort(nArray);
        final int n3 = nArray[nArray.length - 1];
        if (bl || this.progressOutput > 0) {
            System.out.print("  " + this.learner.name + ": " + this.messageIndent + "Cross Validation: ");
            if (n != -1) {
                System.out.print("k = " + n + ", ");
            }
            System.out.print("Split = " + splitPolicy);
            if (n3 != 1) {
                System.out.print(", Rounds = " + n3);
            }
            System.out.println();
        }
        final FoldParser foldParser = this.examples > 0 ? new FoldParser(this.parser, n, splitPolicy, 0, false, this.examples) : new FoldParser(this.parser, n, splitPolicy, 0, false);
        this.parser = foldParser;
        if (splitPolicy == FoldParser.SplitPolicy.manual) {
            n = foldParser.getK();
        }
        final double[][] dArray = new double[nArray.length][n];
        Lexicon lexicon = this.learner.getLabelLexicon();
        int n4 = 0;
        while (n4 < n) {
            if (bl || this.progressOutput > 0) {
                System.out.println("  " + this.learner.name + ": " + this.messageIndent + "Training against subset " + n4 + " at " + new Date());
            }
            n2 = n4;
            this.messageIndent = this.messageIndent + "  ";
            this.train(n3, new DoneWithRound(){
                int r = 0;

                public void doneWithRound(int n) {
                    if (n < n3 && nArray[this.r] == n) {
                        dArray[this.r++][n2] = BatchTrainer.this.crossValidationTesting(foldParser, testingMetric, true, false);
                    }
                }
            });
            dArray[nArray.length - 1][n4] = this.crossValidationTesting(foldParser, testingMetric, false, bl);
            this.messageIndent = this.messageIndent.substring(2);
            this.learner.forget();
            if (lexicon != null && lexicon.size() > 0 && this.learner.getLabelLexicon().size() == 0) {
                this.learner.setLabelLexicon(lexicon);
            }
            foldParser.setPivot(++n4);
        }
        this.parser = foldParser.getParser();
        double[][] dArrayArray = new double[nArray.length][];
        n2 = testingMetric instanceof Accuracy;
        for (int i = 0; i < nArray.length; ++i) {
            dArrayArray[i] = StudentT.confidenceInterval(dArray[i], d);
            if ((i != nArray.length - 1 || !bl) && this.progressOutput <= 0) continue;
            double d2 = (double)Math.round(dArrayArray[i][0] * 100000.0) / 100000.0;
            double d3 = (double)Math.round(dArrayArray[i][1] * 100000.0) / 100000.0;
            System.out.print("  " + this.learner.name + ":   " + this.messageIndent + 100.0 * (1.0 - d) + "% confidence interval after " + nArray[i] + " rounds: " + d2);
            if (n2 != 0) {
                System.out.print("%");
            }
            System.out.print(" +/- " + d3);
            if (n2 != 0) {
                System.out.print("%");
            }
            System.out.println();
        }
        return dArrayArray;
    }

    protected double crossValidationTesting(FoldParser foldParser, TestingMetric testingMetric, boolean bl, boolean bl2) {
        Parser parser = foldParser.getParser();
        foldParser.setFromPivot(true);
        Learner learner = this.learner;
        if (bl) {
            learner = (Learner)this.learner.clone();
            learner.doneLearning();
        }
        double d = 0.0;
        if (parser instanceof ArrayFileParser) {
            ArrayFileParser arrayFileParser = (ArrayFileParser)parser;
            arrayFileParser.setIncludePruned(true);
            d = testingMetric.test(learner, null, foldParser);
            arrayFileParser.setIncludePruned(false);
        } else {
            this.setIsTraining(false);
            d = testingMetric.test(learner, learner.getLabeler(), foldParser);
            this.setIsTraining(true);
        }
        foldParser.reset();
        foldParser.setFromPivot(false);
        if (testingMetric instanceof Accuracy) {
            d *= 100.0;
        }
        if (bl2 || this.progressOutput > 0) {
            double d2 = (double)Math.round(d * 100000.0) / 100000.0;
            System.out.print("  " + this.learner.name + ": " + this.messageIndent + "Subset " + foldParser.getPivot() + " " + testingMetric.getName() + ": " + d2);
            if (testingMetric instanceof Accuracy) {
                System.out.print("%");
            }
            System.out.println();
        }
        return d;
    }

    public Learner.Parameters tune(Learner.Parameters[] parametersArray, int[] nArray, int n, FoldParser.SplitPolicy splitPolicy, double d, TestingMetric testingMetric) {
        int n2 = -1;
        String[] stringArray = new String[parametersArray.length];
        double[][] dArrayArray = new double[parametersArray.length][];
        for (int i = 0; i < parametersArray.length; ++i) {
            stringArray[i] = parametersArray[i].nonDefaultString();
            if (this.progressOutput > 0) {
                System.out.println("  " + this.learner.name + ": " + this.messageIndent + "Trying parameters (" + stringArray[i] + ")");
            }
            this.learner.setParameters(parametersArray[i]);
            this.messageIndent = this.messageIndent + "  ";
            double[][] dArray = this.crossValidation(nArray, n, splitPolicy, d, testingMetric, false);
            this.messageIndent = this.messageIndent.substring(2);
            int n3 = 0;
            if (n2 == -1 || dArray[0][0] > dArrayArray[n2][0]) {
                n2 = i;
            }
            dArrayArray[i] = dArray[0];
            for (int j = 1; j < dArray.length; ++j) {
                if (!(dArray[j][0] > dArrayArray[i][0])) continue;
                n3 = j;
                dArrayArray[i] = dArray[j];
                if (!(dArray[j][0] > dArrayArray[n2][0])) continue;
                n2 = i;
            }
            parametersArray[i].rounds = nArray[n3];
        }
        if (this.progressOutput > 0) {
            int n4;
            double[][] dArray = new double[parametersArray.length][4];
            for (int i = 0; i < parametersArray.length; ++i) {
                dArray[i][0] = i + 1;
                dArray[i][1] = dArrayArray[i][0];
                dArray[i][2] = dArrayArray[i][1];
                dArray[i][3] = parametersArray[i].rounds;
            }
            String[] stringArray2 = new String[]{"Set", testingMetric.getName(), "+/-", "Rounds"};
            int[] nArray2 = new int[]{0, 3, 3, 0};
            String[] stringArray3 = TableFormat.tableFormat(stringArray2, null, dArray, nArray2, new int[]{0});
            System.out.println("  " + this.learner.name + ": " + this.messageIndent + "----");
            System.out.println("  " + this.learner.name + ": " + this.messageIndent + "Parameter sets:");
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                System.out.println("  " + this.learner.name + ": " + this.messageIndent + (n4 + 1) + ": " + stringArray[n4]);
            }
            for (n4 = 0; n4 < stringArray3.length; ++n4) {
                System.out.println("  " + this.learner.name + ": " + this.messageIndent + stringArray3[n4]);
            }
            System.out.println("  " + this.learner.name + ": " + this.messageIndent + "----");
            double d2 = (double)Math.round(dArrayArray[n2][0] * 100000.0) / 100000.0;
            System.out.println("  " + this.learner.name + ": " + this.messageIndent + "Best " + testingMetric.getName() + ": " + d2);
            System.out.print("  " + this.learner.name + ":   " + this.messageIndent + "with ");
            if (stringArray[n2].length() > 0) {
                System.out.println(stringArray[n2]);
                System.out.print("  " + this.learner.name + ":   " + this.messageIndent + "and ");
            }
            System.out.println(parametersArray[n2].rounds + " rounds");
        }
        this.learner.setParameters(parametersArray[n2]);
        return parametersArray[n2];
    }

    public Learner.Parameters tune(Learner.Parameters[] parametersArray, final int[] nArray, final Parser parser, final TestingMetric testingMetric) {
        int n = -1;
        double[] dArray = new double[parametersArray.length];
        String[] stringArray = new String[parametersArray.length];
        Arrays.sort(nArray);
        final int n2 = nArray[nArray.length - 1];
        Lexicon lexicon = this.learner.getLabelLexicon();
        for (int i = 0; i < parametersArray.length; ++i) {
            stringArray[i] = parametersArray[i].nonDefaultString();
            if (this.progressOutput > 0) {
                System.out.println("  " + this.learner.name + ": " + this.messageIndent + "Trying parameters (" + stringArray[i] + ")");
            }
            final double[] dArray2 = new double[nArray.length];
            this.learner.setParameters(parametersArray[i]);
            this.messageIndent = this.messageIndent + "  ";
            this.train(n2, new DoneWithRound(){
                int r = 0;

                public void doneWithRound(int n) {
                    if (n < n2 && nArray[this.r] == n) {
                        dArray2[this.r++] = BatchTrainer.this.testMidTraining(parser, testingMetric, true);
                    }
                }
            });
            dArray2[nArray.length - 1] = this.testMidTraining(parser, testingMetric, false);
            this.messageIndent = this.messageIndent.substring(2);
            int n3 = 0;
            if (n == -1 || dArray2[0] > dArray[n]) {
                n = i;
            }
            dArray[i] = dArray2[0];
            for (int j = 1; j < dArray2.length; ++j) {
                if (!(dArray2[j] > dArray[i])) continue;
                n3 = j;
                dArray[i] = dArray2[j];
                if (!(dArray2[j] > dArray[n])) continue;
                n = i;
            }
            parametersArray[i].rounds = nArray[n3];
            this.learner.forget();
            if (lexicon == null || lexicon.size() <= 0 || this.learner.getLabelLexicon().size() != 0) continue;
            this.learner.setLabelLexicon(lexicon);
        }
        if (this.progressOutput > 0) {
            int n4;
            double[][] dArray3 = new double[parametersArray.length][3];
            for (int i = 0; i < parametersArray.length; ++i) {
                dArray3[i][0] = i + 1;
                dArray3[i][1] = dArray[i];
                dArray3[i][2] = parametersArray[i].rounds;
            }
            String[] stringArray2 = new String[]{"Set", testingMetric.getName(), "Rounds"};
            int[] nArray2 = new int[]{0, 3, 0};
            String[] stringArray3 = TableFormat.tableFormat(stringArray2, null, dArray3, nArray2, new int[]{0});
            System.out.println("  " + this.learner.name + ": " + this.messageIndent + "----");
            System.out.println("  " + this.learner.name + ": " + this.messageIndent + "Parameter sets:");
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                System.out.println("  " + this.learner.name + ": " + this.messageIndent + (n4 + 1) + ": " + stringArray[n4]);
            }
            for (n4 = 0; n4 < stringArray3.length; ++n4) {
                System.out.println("  " + this.learner.name + ": " + this.messageIndent + stringArray3[n4]);
            }
            System.out.println("  " + this.learner.name + ": " + this.messageIndent + "----");
            double d = (double)Math.round(dArray[n] * 100000.0) / 100000.0;
            System.out.println("  " + this.learner.name + ": " + this.messageIndent + "Best " + testingMetric.getName() + ": " + d);
            System.out.print("  " + this.learner.name + ":   " + this.messageIndent + "with ");
            if (stringArray[n].length() > 0) {
                System.out.println(stringArray[n]);
                System.out.print("  " + this.learner.name + ":   " + this.messageIndent + "and ");
            }
            System.out.println(parametersArray[n].rounds + " rounds");
        }
        this.learner.setParameters(parametersArray[n]);
        return parametersArray[n];
    }

    protected double testMidTraining(Parser parser, TestingMetric testingMetric, boolean bl) {
        Learner learner = bl ? (Learner)this.learner.clone() : this.learner;
        learner.doneLearning();
        double d = 0.0;
        if (parser instanceof ArrayFileParser) {
            ArrayFileParser arrayFileParser = (ArrayFileParser)parser;
            arrayFileParser.setIncludePruned(true);
            d = testingMetric.test(learner, null, parser);
            arrayFileParser.setIncludePruned(false);
        } else {
            this.setIsTraining(false);
            d = testingMetric.test(learner, learner.getLabeler(), parser);
            this.setIsTraining(true);
        }
        parser.reset();
        if (testingMetric instanceof Accuracy) {
            d *= 100.0;
        }
        if (this.progressOutput > 0) {
            double d2 = (double)Math.round(d * 100000.0) / 100000.0;
            System.out.print("  " + this.learner.name + ": " + this.messageIndent + testingMetric.getName() + ": " + d2);
            if (testingMetric instanceof Accuracy) {
                System.out.print("%");
            }
            System.out.println();
        }
        return d;
    }

    public static interface DoneWithRound {
        public void doneWithRound(int var1);
    }
}

