/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.learn.Lexicon;
import LBJ2.learn.SparseWeightVector;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.PrintStream;

public class BiasedWeightVector
extends SparseWeightVector {
    protected static final double defaultInitialBias = 0.0;
    protected double initialBias;
    protected double bias;

    public BiasedWeightVector() {
        this(0.0);
    }

    public BiasedWeightVector(double d) {
        this.initialBias = this.bias = d;
    }

    public double dot(int[] nArray, double[] dArray, double d) {
        return super.dot(nArray, dArray, d) + this.bias;
    }

    public void scaledAdd(int[] nArray, double[] dArray, double d, double d2) {
        super.scaledAdd(nArray, dArray, d, d2);
        this.bias += d;
    }

    public void clear() {
        super.clear();
        this.bias = this.initialBias;
    }

    public void write(PrintStream printStream) {
        printStream.println("Begin BiasedWeightVector");
        printStream.println("bias = " + this.bias);
        printStream.println("initialBias = " + this.initialBias);
        this.toStringJustWeights(printStream);
        printStream.println("End BiasedWeightVector");
    }

    public void write(PrintStream printStream, Lexicon lexicon) {
        printStream.println("Begin BiasedWeightVector");
        printStream.println("bias = " + this.bias);
        printStream.println("initialBias = " + this.initialBias);
        this.toStringJustWeights(printStream, 0, lexicon);
        printStream.println("End BiasedWeightVector");
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeDouble(this.initialBias);
        exceptionlessOutputStream.writeDouble(this.bias);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.initialBias = exceptionlessInputStream.readDouble();
        this.bias = exceptionlessInputStream.readDouble();
    }

    public SparseWeightVector emptyClone() {
        return new BiasedWeightVector(this.initialBias);
    }
}

