/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.FeatureVector;
import LBJ2.learn.Learner;
import LBJ2.learn.LinearThresholdUnit;
import LBJ2.learn.SparsePerceptron;
import LBJ2.learn.SparseWeightVector;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.PrintStream;

public class BinaryMIRA
extends SparsePerceptron {
    public static final double TOLERANCE = 1.0E-9;
    public static final double defaultBeta = 2.0;
    public static final double defaultLearningRate = 1.0;
    protected double beta;

    public BinaryMIRA() {
        this("");
    }

    public BinaryMIRA(double d) {
        this("", d);
    }

    public BinaryMIRA(double d, double d2) {
        this("", d, d2);
    }

    public BinaryMIRA(double d, double d2, SparseWeightVector sparseWeightVector) {
        this("", d, d2, sparseWeightVector);
    }

    public BinaryMIRA(Parameters parameters) {
        this("", parameters);
    }

    public BinaryMIRA(String string) {
        this(string, 1.0);
    }

    public BinaryMIRA(String string, double d) {
        this(string, d, 2.0);
    }

    public BinaryMIRA(String string, double d, double d2) {
        this(string, d, d2, (SparseWeightVector)LinearThresholdUnit.defaultWeightVector.clone());
    }

    public BinaryMIRA(String string, double d, double d2, SparseWeightVector sparseWeightVector) {
        super(string);
        Parameters parameters = new Parameters();
        parameters.learningRate = d;
        parameters.weightVector = sparseWeightVector;
        parameters.beta = d2;
        this.setParameters(parameters);
    }

    public BinaryMIRA(String string, Parameters parameters) {
        super(string);
        this.setParameters(parameters);
    }

    public void setParameters(Parameters parameters) {
        super.setParameters(parameters);
        this.beta = parameters.beta;
    }

    public Learner.Parameters getParameters() {
        Parameters parameters = new Parameters((SparsePerceptron.Parameters)super.getParameters());
        parameters.beta = this.beta;
        return parameters;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double d) {
        this.beta = d;
    }

    public boolean shouldPromote(boolean bl, double d, double d2, double d3) {
        return bl;
    }

    public boolean shouldDemote(boolean bl, double d, double d2, double d3) {
        return !bl;
    }

    public void promote(int[] nArray, double[] dArray, double d) {
        if (!BinaryMIRA.nearlyEqualTo(d, 0.0)) {
            super.promote(nArray, dArray, d);
        }
    }

    public void demote(int[] nArray, double[] dArray, double d) {
        if (!BinaryMIRA.nearlyEqualTo(d, 0.0)) {
            super.demote(nArray, dArray, d);
        }
    }

    private static boolean nearlyEqualTo(double d, double d2) {
        return -1.0E-9 < d - d2 && d - d2 < 1.0E-9;
    }

    public double computeLearningRate(int[] nArray, double[] dArray, double d, boolean bl) {
        double d2 = bl ? 1.0 : -1.0;
        double d3 = (this.beta / 2.0 - d2 * d) / (FeatureVector.L2NormSquared(dArray) + 1.0);
        double d4 = 1.0;
        if (d3 < 0.0) {
            d4 = 0.0;
        } else if (d3 < 1.0) {
            d4 = d3;
        }
        return d4 *= this.learningRate;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void write(PrintStream printStream) {
        printStream.println(this.name + ": " + this.learningRate + ", " + this.beta + ", " + this.initialWeight + ", " + this.threshold + ", " + this.positiveThickness + ", " + this.negativeThickness + ", " + this.bias);
        if (this.lexicon.size() == 0) {
            this.weightVector.write(printStream);
        } else {
            this.weightVector.write(printStream, this.lexicon);
        }
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeDouble(this.beta);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.beta = exceptionlessInputStream.readDouble();
    }

    public static class Parameters
    extends SparsePerceptron.Parameters {
        public double beta;

        public Parameters() {
            this.beta = 2.0;
            this.learningRate = 1.0;
        }

        public Parameters(SparsePerceptron.Parameters parameters) {
            super(parameters);
            this.beta = 2.0;
        }

        public Parameters(Parameters parameters) {
            super(parameters);
            this.beta = parameters.beta;
        }

        public void setParameters(Learner learner) {
            ((BinaryMIRA)learner).setParameters(this);
        }

        public String nonDefaultString() {
            String string = super.nonDefaultString();
            if (this.beta != 2.0) {
                string = string + ", beta = " + this.beta;
            }
            if (string.startsWith(", ")) {
                string = string.substring(2);
            }
            return string;
        }
    }
}

