/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.Classifier;
import LBJ2.classify.DiscretePrimitiveStringFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.FeatureVector;
import LBJ2.classify.ScoreSet;
import LBJ2.learn.Learner;
import LBJ2.learn.Lexicon;
import LBJ2.learn.SparseAveragedPerceptron;
import LBJ2.learn.SparseNetworkLearner;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import LBJ2.util.FVector;
import LBJ2.util.OVector;
import LBJ2.util.Sort;
import java.io.PrintStream;

public class MuxLearner
extends Learner {
    public static final Learner defaultBaseLearner;
    public static final String defaultDefaultPrediction;
    protected Learner baseLearner;
    protected OVector network;
    protected String defaultPrediction;
    protected Feature defaultFeature;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MuxLearner() {
    }

    public MuxLearner(Learner learner) {
        this("", learner);
    }

    public MuxLearner(Learner learner, String string) {
        this("", learner, string);
    }

    public MuxLearner(Parameters parameters) {
        this("", parameters);
    }

    public MuxLearner(String string) {
        super(string);
    }

    public MuxLearner(String string, Learner learner) {
        this(string, learner, defaultDefaultPrediction);
    }

    public MuxLearner(String string, Learner learner, String string2) {
        super(string);
        Parameters parameters = new Parameters();
        parameters.baseLearner = learner;
        parameters.defaultPrediction = string2;
        this.setParameters(parameters);
        this.network = new OVector();
    }

    public MuxLearner(String string, Parameters parameters) {
        super(string);
        this.setParameters(parameters);
        this.network = new OVector();
    }

    public void setParameters(Parameters parameters) {
        this.setBase(parameters.baseLearner);
        this.defaultPrediction = parameters.defaultPrediction;
        this.setDefaultFeature();
    }

    protected void setDefaultFeature() {
        this.defaultFeature = new DiscretePrimitiveStringFeature(this.containingPackage, this.name, "default", this.defaultPrediction, this.valueIndexOf(this.defaultPrediction), (short)this.allowableValues().length);
    }

    public Learner.Parameters getParameters() {
        Parameters parameters = new Parameters(super.getParameters());
        parameters.baseLearner = this.baseLearner;
        parameters.defaultPrediction = this.defaultPrediction;
        return parameters;
    }

    public void setBase(Learner learner) {
        this.baseLearner = learner;
        this.baseLearner.containingPackage = this.containingPackage;
        this.baseLearner.name = this.name + "::base";
    }

    public void setLabeler(Classifier classifier) {
        super.setLabeler(classifier);
        this.setBase(this.baseLearner);
    }

    public void setLabelLexicon(Lexicon lexicon) {
        super.setLabelLexicon(lexicon);
        if (this.network != null) {
            int n = this.network.size();
            for (int i = 0; i < n; ++i) {
                Learner learner = (Learner)this.network.get(i);
                if (learner == null) continue;
                learner.setLabelLexicon(lexicon);
            }
        }
    }

    public void learn(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2) {
        int n;
        if (!$assertionsDisabled && nArray.length <= nArray2.length) {
            throw new AssertionError((Object)"MuxLearner ERROR: The example vector must have more features than labels, since it is assumed that there is a correspondence between the labels and the first features in the vector.");
        }
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int[] nArray3 = new int[n2 - n3];
        double[] dArray3 = new double[n2 - n3];
        int[] nArray4 = new int[n3];
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            nArray4[n] = nArray[n];
        }
        while (n < n2) {
            nArray3[n4] = nArray[n];
            dArray3[n4] = dArray[n];
            ++n;
            ++n4;
        }
        for (n = 0; n < n3; ++n) {
            Learner learner = (Learner)this.network.get(nArray4[n]);
            if (learner == null) {
                learner = (Learner)this.baseLearner.clone();
                learner.setLabelLexicon(this.labelLexicon);
                this.network.set(nArray4[n], learner);
            }
            int[] nArray5 = new int[]{nArray2[n]};
            double[] dArray4 = new double[]{dArray2[n]};
            learner.learn(nArray3, dArray3, nArray5, dArray4);
        }
    }

    public void forget() {
        super.forget();
        this.network = new OVector();
    }

    public ScoreSet scores(int[] nArray, double[] dArray) {
        int[] nArray2 = new int[nArray.length - 1];
        double[] dArray2 = new double[nArray.length - 1];
        System.arraycopy(nArray, 1, nArray2, 0, nArray2.length);
        System.arraycopy(dArray, 1, dArray2, 0, dArray2.length);
        int n = nArray[0];
        Learner learner = (Learner)this.network.get(n);
        if (learner == null) {
            return new ScoreSet(new String[]{this.defaultPrediction}, new double[]{1.0});
        }
        return learner.scores(nArray2, dArray2);
    }

    public String discreteValue(int[] nArray, double[] dArray) {
        return this.featureValue(nArray, dArray).getStringValue();
    }

    public double realValue(int[] nArray, double[] dArray) {
        return this.featureValue(nArray, dArray).getStrength();
    }

    public Feature featureValue(int[] nArray, double[] dArray) {
        int[] nArray2 = new int[nArray.length - 1];
        double[] dArray2 = new double[nArray.length - 1];
        System.arraycopy(nArray, 1, nArray2, 0, nArray2.length);
        System.arraycopy(dArray, 1, dArray2, 0, dArray2.length);
        int n = nArray[0];
        Learner learner = (Learner)this.network.get(n);
        if (learner == null) {
            return this.defaultFeature;
        }
        return learner.featureValue(nArray2, dArray2);
    }

    public FeatureVector classify(int[] nArray, double[] dArray) {
        return new FeatureVector(this.featureValue(nArray, dArray));
    }

    public void write(PrintStream printStream) {
        int n;
        int n2 = this.network.size();
        final FVector fVector = new FVector(n2);
        OVector oVector = new OVector(n2);
        for (int i = 0; i < n2; ++i) {
            Learner learner = (Learner)this.network.get(i);
            if (this.network.get(i) == null) continue;
            fVector.add(this.lexicon.lookupKey(i));
            oVector.add(learner);
        }
        n2 = fVector.size();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        Sort.sort(nArray, new Sort.IntComparator(){

            public int compare(int n, int n2) {
                return fVector.get(n).compareTo(fVector.get(n2));
            }
        });
        for (n = 0; n < n2; ++n) {
            printStream.println("select: " + fVector.get(nArray[n]).getStringValue());
            Learner learner = (Learner)oVector.get(nArray[n]);
            learner.setLexicon(this.lexicon);
            learner.write(printStream);
            learner.setLexicon(null);
        }
        printStream.println("End of MuxLearner");
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        int n;
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeString(this.defaultPrediction);
        this.baseLearner.write(exceptionlessOutputStream);
        int n2 = this.network.size();
        exceptionlessOutputStream.writeInt(n2);
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (this.network.get(n) == null) continue;
            ++n3;
        }
        exceptionlessOutputStream.writeInt(n3);
        for (n = 0; n < n2; ++n) {
            Learner learner = (Learner)this.network.get(n);
            if (learner == null) continue;
            exceptionlessOutputStream.writeInt(n);
            learner.write(exceptionlessOutputStream);
        }
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.defaultPrediction = exceptionlessInputStream.readString();
        this.setDefaultFeature();
        this.baseLearner = Learner.readLearner(exceptionlessInputStream);
        int n = exceptionlessInputStream.readInt();
        this.network = new OVector(n);
        int n2 = exceptionlessInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            this.network.set(exceptionlessInputStream.readInt(), Learner.readLearner(exceptionlessInputStream));
        }
    }

    public Object clone() {
        MuxLearner muxLearner = null;
        try {
            muxLearner = (MuxLearner)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning MuxLearner: " + exception);
            exception.printStackTrace();
            System.exit(1);
        }
        muxLearner.baseLearner = (Learner)this.baseLearner.clone();
        int n = this.network.size();
        muxLearner.network = new OVector(n);
        for (int i = 0; i < n; ++i) {
            Learner learner = (Learner)this.network.get(i);
            if (learner == null) continue;
            muxLearner.network.set(i, learner.clone());
        }
        return muxLearner;
    }

    static {
        $assertionsDisabled = !MuxLearner.class.desiredAssertionStatus();
        defaultBaseLearner = new SparseNetworkLearner(new SparseAveragedPerceptron());
        defaultDefaultPrediction = null;
    }

    public static class Parameters
    extends Learner.Parameters {
        public Learner baseLearner;
        public String defaultPrediction;

        public Parameters() {
            this.baseLearner = (Learner)defaultBaseLearner.clone();
            this.defaultPrediction = defaultDefaultPrediction;
        }

        public Parameters(Learner.Parameters parameters) {
            super(parameters);
            this.baseLearner = (Learner)defaultBaseLearner.clone();
            this.defaultPrediction = defaultDefaultPrediction;
        }

        public Parameters(Parameters parameters) {
            super(parameters);
            this.baseLearner = parameters.baseLearner;
            this.defaultPrediction = parameters.defaultPrediction;
        }

        public void setParameters(Learner learner) {
            ((MuxLearner)learner).setParameters(this);
        }

        public String nonDefaultString() {
            String string = super.nonDefaultString();
            String string2 = this.baseLearner.getClass().getName();
            string2 = string2.substring(string2.lastIndexOf(46) + 1);
            if (!this.defaultPrediction.equals(defaultDefaultPrediction)) {
                string = string + "defaultPrediction = " + this.defaultPrediction + ", ";
            }
            string = string + string2 + ": " + this.baseLearner.getParameters().nonDefaultString();
            return string;
        }
    }
}

