/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.FeatureVector;
import LBJ2.learn.Learner;
import LBJ2.learn.LinearThresholdUnit;
import LBJ2.learn.SparseWeightVector;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.PrintStream;

public class SparseConfidenceWeighted
extends LinearThresholdUnit {
    public static final double defaultConfidence = 2.0;
    public static final double defaultInitialVariance = 1.0;
    protected double confidence;
    protected double initialVariance;
    protected SparseWeightVector variances;
    protected double variancesBias;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SparseConfidenceWeighted() {
        this("");
    }

    public SparseConfidenceWeighted(double d) {
        this("", d);
    }

    public SparseConfidenceWeighted(double d, double d2) {
        this("", d, d2);
    }

    public SparseConfidenceWeighted(double d, double d2, SparseWeightVector sparseWeightVector) {
        this("", d, d2, sparseWeightVector);
    }

    public SparseConfidenceWeighted(double d, double d2, SparseWeightVector sparseWeightVector, SparseWeightVector sparseWeightVector2) {
        this("", d, d2, sparseWeightVector, sparseWeightVector2);
    }

    public SparseConfidenceWeighted(Parameters parameters) {
        this("", parameters);
    }

    public SparseConfidenceWeighted(String string) {
        this(string, 2.0);
    }

    public SparseConfidenceWeighted(String string, double d) {
        this(string, d, 1.0);
    }

    public SparseConfidenceWeighted(String string, double d, double d2) {
        this(string, d, d2, (SparseWeightVector)defaultWeightVector.clone());
    }

    public SparseConfidenceWeighted(String string, double d, double d2, SparseWeightVector sparseWeightVector) {
        this(string, d, d2, sparseWeightVector, (SparseWeightVector)defaultWeightVector.clone());
    }

    public SparseConfidenceWeighted(String string, double d, double d2, SparseWeightVector sparseWeightVector, SparseWeightVector sparseWeightVector2) {
        super(string);
        Parameters parameters = new Parameters();
        parameters.confidence = d;
        parameters.initialVariance = d2;
        parameters.weightVector = sparseWeightVector;
        parameters.variances = sparseWeightVector2;
        this.setParameters(parameters);
    }

    public SparseConfidenceWeighted(String string, Parameters parameters) {
        super(string);
        this.setParameters(parameters);
    }

    public void setParameters(Parameters parameters) {
        super.setParameters(parameters);
        this.confidence = parameters.confidence;
        this.initialVariance = parameters.initialVariance;
        this.variances = parameters.variances;
        this.variancesBias = 1.0 / this.initialVariance;
    }

    public Learner.Parameters getParameters() {
        Parameters parameters = new Parameters((LinearThresholdUnit.Parameters)super.getParameters());
        parameters.confidence = this.confidence;
        parameters.initialVariance = this.initialVariance;
        parameters.variances = this.variances.emptyClone();
        return parameters;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double d) {
        this.confidence = d;
    }

    public double getInitialVariance() {
        return this.initialVariance;
    }

    public void setInitialVariance(double d) {
        this.initialVariance = d;
    }

    public void learn(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2) {
        double[] dArray3;
        Object[] objectArray;
        int[] nArray3;
        double d;
        double d2;
        if (!$assertionsDisabled && nArray2.length != 1) {
            throw new AssertionError((Object)"Example must have a single label.");
        }
        if (!$assertionsDisabled && nArray2[0] != 0 && nArray2[0] != 1) {
            throw new AssertionError((Object)"Example has unallowed label value.");
        }
        double d3 = 2 * nArray2[0] - 1;
        double d4 = d3 * (this.weightVector.dot(nArray, dArray) + this.bias);
        double d5 = 2.0 * this.confidence * d4 + 1.0;
        double d6 = (-d5 + Math.sqrt(d2 = d5 * d5 - 8.0 * this.confidence * (d4 - this.confidence * (d = FeatureVector.dot(nArray, dArray, nArray3 = (int[])(objectArray = this.variances.pairwiseMultiply(nArray, dArray, this.initialVariance, true))[0], dArray3 = (double[])objectArray[1]) + 1.0 / this.variancesBias)))) / (4.0 * this.confidence * d);
        if (d6 > 0.0) {
            this.weightVector.scaledAdd(nArray3, dArray3, d6 * d3);
            this.bias += d6 * d3 / this.variancesBias;
            this.variances.scaledAdd(nArray, dArray, 2.0 * d6 * this.confidence);
            this.variancesBias += 2.0 * d6 * this.confidence;
        }
    }

    public void demote(int[] nArray, double[] dArray, double d) {
    }

    public void promote(int[] nArray, double[] dArray, double d) {
    }

    public void forget() {
        super.forget();
        this.variances = this.variances.emptyClone();
        this.variancesBias = 1.0 / this.initialVariance;
    }

    public void write(PrintStream printStream) {
        printStream.println(this.name + ": " + this.confidence + ", " + this.initialVariance);
        printStream.println("Means:");
        if (this.lexicon.size() == 0) {
            this.weightVector.write(printStream);
        } else {
            this.weightVector.write(printStream, this.lexicon);
        }
        printStream.println("\nVariances:");
        if (this.lexicon.size() == 0) {
            this.variances.write(printStream);
        } else {
            this.variances.write(printStream, this.lexicon);
        }
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeDouble(this.confidence);
        exceptionlessOutputStream.writeDouble(this.initialVariance);
        exceptionlessOutputStream.writeDouble(this.variancesBias);
        this.variances.write(exceptionlessOutputStream);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.confidence = exceptionlessInputStream.readDouble();
        this.initialVariance = exceptionlessInputStream.readDouble();
        this.variancesBias = exceptionlessInputStream.readDouble();
        this.variances = SparseWeightVector.readWeightVector(exceptionlessInputStream);
    }

    public Object clone() {
        SparseConfidenceWeighted sparseConfidenceWeighted = null;
        try {
            sparseConfidenceWeighted = (SparseConfidenceWeighted)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning SparseConfidenceWeighted: " + exception);
            System.exit(1);
        }
        if (this.variances != null) {
            sparseConfidenceWeighted.variances = (SparseWeightVector)this.variances.clone();
        }
        return sparseConfidenceWeighted;
    }

    static {
        $assertionsDisabled = !SparseConfidenceWeighted.class.desiredAssertionStatus();
    }

    public static class Parameters
    extends LinearThresholdUnit.Parameters {
        protected double confidence;
        protected double initialVariance;
        protected SparseWeightVector variances;

        public Parameters() {
            this.confidence = 2.0;
            this.initialVariance = 1.0;
            this.variances = (SparseWeightVector)LinearThresholdUnit.defaultWeightVector.clone();
        }

        public Parameters(LinearThresholdUnit.Parameters parameters) {
            super(parameters);
            this.confidence = 2.0;
            this.initialVariance = 1.0;
            this.variances = (SparseWeightVector)LinearThresholdUnit.defaultWeightVector.clone();
        }

        public Parameters(Parameters parameters) {
            super(parameters);
            this.confidence = parameters.confidence;
            this.initialVariance = parameters.initialVariance;
            this.variances = parameters.variances;
        }

        public void setParameters(Learner learner) {
            ((SparseConfidenceWeighted)learner).setParameters(this);
        }

        public String nonDefaultString() {
            String string = super.nonDefaultString();
            if (this.confidence != 2.0) {
                string = string + ", confidence = " + this.confidence;
            }
            if (this.initialVariance != 1.0) {
                string = string + ", initialVariance = " + this.initialVariance;
            }
            if (string.startsWith(", ")) {
                string = string.substring(2);
            }
            return string;
        }
    }
}

