/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.parse;

import LBJ2.classify.FeatureVector;
import LBJ2.learn.Learner;
import LBJ2.parse.FoldSeparator;
import LBJ2.parse.Parser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ArrayFileParser
implements Parser {
    protected DataInputStream in;
    protected String exampleFileName;
    protected byte[] exampleData;
    protected boolean zipped;
    protected boolean includePruned = false;

    public ArrayFileParser(String string) {
        this(string, true);
    }

    public ArrayFileParser(String string, boolean bl) {
        this.exampleFileName = string;
        this.zipped = bl;
        this.reset();
    }

    public ArrayFileParser(byte[] byArray) {
        this(byArray, true);
    }

    public ArrayFileParser(byte[] byArray, boolean bl) {
        this.exampleData = byArray;
        this.zipped = bl;
        this.reset();
    }

    public void setIncludePruned(boolean bl) {
        this.includePruned = bl;
    }

    public int getNumExamples() {
        int n = 0;
        try {
            while (true) {
                int n2;
                if ((n2 = this.in.readInt()) == -1) {
                    continue;
                }
                ++n;
                this.in.skipBytes(12 * n2);
                n2 = this.in.readInt() + this.in.readInt();
                this.in.skipBytes(12 * n2);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            System.err.println("Can't read from '" + this.exampleFileName + "':");
            exception.printStackTrace();
            System.exit(1);
        }
        this.reset();
        return n;
    }

    public Object next() {
        Object[] objectArray = new Object[4];
        try {
            int n;
            int n2 = this.in.readInt();
            if (n2 == -1) {
                return FoldSeparator.separator;
            }
            int[] nArray = new int[n2];
            double[] dArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.in.readInt();
                dArray[n] = this.in.readDouble();
            }
            n = this.in.readInt();
            int n3 = this.in.readInt();
            int n4 = this.includePruned ? n + n3 : n;
            int[] nArray2 = new int[n4];
            double[] dArray2 = new double[n4];
            for (int i = 0; i < n + n3; ++i) {
                int n5 = this.in.readInt();
                double d = this.in.readDouble();
                if (i >= n4) continue;
                nArray2[i] = n5;
                dArray2[i] = d;
            }
            objectArray[0] = nArray2;
            objectArray[1] = dArray2;
            objectArray[2] = nArray;
            objectArray[3] = dArray;
        }
        catch (EOFException eOFException) {
            objectArray = null;
        }
        catch (Exception exception) {
            System.err.println("Can't read from '" + this.exampleFileName + "':");
            exception.printStackTrace();
            System.exit(1);
        }
        return objectArray;
    }

    public void reset() {
        this.close();
        try {
            if (this.exampleFileName != null) {
                if (this.zipped) {
                    ZipFile zipFile = new ZipFile(this.exampleFileName);
                    this.in = new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipFile.getEntry("LBJFile"))));
                } else {
                    this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.exampleFileName)));
                }
            } else if (this.zipped) {
                ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.exampleData));
                zipInputStream.getNextEntry();
                this.in = new DataInputStream(new BufferedInputStream(zipInputStream));
            } else {
                this.in = new DataInputStream(new ByteArrayInputStream(this.exampleData));
            }
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + this.exampleFileName + "' for input:");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void close() {
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            System.err.println("Can't close '" + this.exampleFileName + "':");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[2];
            if (stringArray.length > 3) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            System.err.println("usage: java LBJ2.parse.ArrayFileParser <example file> <lexicon file> <lc file>");
            System.exit(1);
        }
        ArrayFileParser arrayFileParser = new ArrayFileParser(string);
        Learner learner = Learner.readLearner(string3);
        learner.readLexicon(string2);
        Object object = arrayFileParser.next();
        while (object != null) {
            FeatureVector featureVector = new FeatureVector((Object[])object, learner.getLexicon(), learner.getLabelLexicon());
            featureVector.sort();
            System.out.println(featureVector);
            object = arrayFileParser.next();
        }
    }
}

