/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.util;

import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class IVector
implements Cloneable,
Serializable {
    protected static final int defaultCapacity = 8;
    protected int[] vector;
    protected int size;

    public IVector() {
        this(8);
    }

    public IVector(int n) {
        this.vector = new int[Math.max(8, n)];
    }

    public IVector(int[] nArray) {
        if (nArray.length == 0) {
            this.vector = new int[8];
        } else {
            this.vector = nArray;
            this.size = this.vector.length;
        }
    }

    public IVector(IVector iVector) {
        this(iVector.toArray());
    }

    protected void boundsCheck(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempted to access negative index of IVector.");
        }
    }

    public int get(int n) {
        return this.get(n, 0);
    }

    public int get(int n, int n2) {
        this.boundsCheck(n);
        return n < this.size ? this.vector[n] : n2;
    }

    public int set(int n, int n2) {
        return this.set(n, n2, 0);
    }

    public int set(int n, int n2, int n3) {
        this.boundsCheck(n);
        this.expandFor(n, n3);
        int n4 = this.vector[n];
        this.vector[n] = n2;
        return n4;
    }

    public void increment(int n) {
        this.increment(n, 0);
    }

    public void increment(int n, int n2) {
        this.boundsCheck(n);
        this.expandFor(n, n2);
        int n3 = n;
        this.vector[n3] = this.vector[n3] + 1;
    }

    public void decrement(int n) {
        this.decrement(n, 0);
    }

    public void decrement(int n, int n2) {
        this.boundsCheck(n);
        this.expandFor(n, n2);
        int n3 = n;
        this.vector[n3] = this.vector[n3] - 1;
    }

    public void add(int n) {
        this.expandFor(this.size, 0);
        this.vector[this.size - 1] = n;
    }

    public void addAll(IVector iVector) {
        this.expandFor(this.size + iVector.size - 1, 0);
        System.arraycopy(iVector.vector, 0, this.vector, this.size - iVector.size, iVector.size);
    }

    public int remove(int n) {
        this.boundsCheck(n);
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("LBJ: IVector: Can't remove element at index " + n + " as it is larger than the size (" + this.size + ")");
        }
        int n2 = this.vector[n];
        for (int i = n + 1; i < this.size; ++i) {
            this.vector[i - 1] = this.vector[i];
        }
        --this.size;
        return n2;
    }

    public int size() {
        return this.size;
    }

    public int max() {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.size; ++i) {
            if (this.vector[i] <= n) continue;
            n = this.vector[i];
        }
        return n;
    }

    public void sort() {
        Arrays.sort(this.vector, 0, this.size);
    }

    public int binarySearch(int n) {
        int n2 = 0;
        int n3 = this.size;
        while (n3 != n2) {
            int n4 = n2 + n3 >> 1;
            if (this.vector[n4] > n) {
                n3 = n4;
                continue;
            }
            if (this.vector[n4] < n) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        return -n2 - 1;
    }

    protected void expandFor(int n, int n2) {
        int n3;
        if (n < this.size) {
            return;
        }
        int n4 = this.size;
        this.size = n + 1;
        if (n3 >= this.size) {
            return;
        }
        for (n3 = this.vector.length; n3 < this.size; n3 *= 2) {
        }
        int[] nArray = new int[n3];
        System.arraycopy(this.vector, 0, nArray, 0, n4);
        if (n2 != 0) {
            Arrays.fill(nArray, n4, this.size, n2);
        }
        this.vector = nArray;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.vector, 0, nArray, 0, this.size);
        return nArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IVector)) {
            return false;
        }
        IVector iVector = (IVector)object;
        return this.size == iVector.size && Arrays.equals(this.vector, iVector.vector);
    }

    public int hashCode() {
        return this.vector.hashCode();
    }

    public Object clone() {
        IVector iVector = null;
        try {
            iVector = (IVector)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning " + this.getClass().getName() + ":");
            exception.printStackTrace();
            System.exit(1);
        }
        iVector.vector = (int[])this.vector.clone();
        return iVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.vector[i]);
            if (i + 1 >= this.size) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        exceptionlessOutputStream.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            exceptionlessOutputStream.writeInt(this.vector[i]);
        }
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.size = exceptionlessInputStream.readInt();
        if (this.size == 0) {
            this.vector = new int[8];
        } else {
            this.vector = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.vector[i] = exceptionlessInputStream.readInt();
            }
        }
    }
}

