/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone.filter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rita.wordnet.RiFilter;

public final class ContainsAllFilter
extends RiFilter {
    private final Map terms;

    private ContainsAllFilter() {
        ignoreCase = false;
        this.terms = new HashMap(0);
    }

    public ContainsAllFilter(String word, boolean bIgnoreCase) {
        ignoreCase = bIgnoreCase;
        List strings = this.parseIntoPhrases(word);
        int size = strings.size();
        this.terms = new HashMap(size);
        int i = 0;
        while (i < size) {
            String term = (String)strings.get(i);
            if (!this.terms.containsKey(term)) {
                this.terms.put(term, new Integer(1));
            } else {
                int count = (Integer)this.terms.get(term);
                this.terms.put(term, new Integer(++count));
            }
            ++i;
        }
    }

    public boolean accept(String word) {
        if (word == null) {
            return false;
        }
        String target = ignoreCase ? word.toLowerCase() : word;
        boolean found = true;
        Iterator it = this.terms.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            int count = (Integer)this.terms.get(key);
            int index = target.indexOf(key);
            if (index < 0) {
                found = false;
                break;
            }
            int i = 1;
            while (i < count && found) {
                if ((index = target.indexOf(key, index + 1)) < 0) {
                    found = false;
                    break;
                }
                ++i;
            }
            if (!found) break;
        }
        return found;
    }
}

