/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import rita.wordnet.RiFilter;

public final class WildcardFilter
extends RiFilter {
    private List fields = new ArrayList(8);

    private WildcardFilter() {
    }

    public WildcardFilter(String word, boolean bIgnoreCase) {
        ignoreCase = bIgnoreCase;
        this.parsePattern(word);
    }

    public boolean accept(String word) {
        if (word == null && this.fields == null) {
            return true;
        }
        if (word == null || this.fields == null) {
            return false;
        }
        return this.matchPattern(word);
    }

    public boolean matchPattern(String target) {
        if (ignoreCase) {
            if (this.fields == null || this.fields.size() == 0) {
                return true;
            }
            if (target == null || target.length() == 0) {
                return false;
            }
            return this.matchString(target.toUpperCase());
        }
        return this.matchString(target);
    }

    private boolean matchString(String target) {
        String pat;
        boolean match = false;
        match = this.fields == null || this.fields.size() == 0 ? true : (target == null || target.length() == 0 ? false : (this.fields.size() == 1 ? ((pat = (String)this.fields.get(0)) == null ? true : this.equalsWild(target, pat)) : this.findMatch(0, target, 0)));
        return match;
    }

    private boolean findMatch(int nCurrPart, String target, int nCurrIndex) {
        boolean found = false;
        if (nCurrPart >= this.fields.size()) {
            return true;
        }
        String part = (String)this.fields.get(nCurrPart);
        if (nCurrIndex >= target.length()) {
            return part == null;
        }
        if (part == null) {
            if (nCurrPart == 0) {
                return this.findMatch(1, target, 0);
            }
            return true;
        }
        if (nCurrPart == this.fields.size() - 1) {
            return this.endsWithWild(target, part);
        }
        int nLen = part.length();
        int foundIndex = this.indexOfWild(target, part, nCurrIndex);
        while (foundIndex >= 0 && !found) {
            if (foundIndex > nCurrIndex && nCurrPart == 0) {
                return false;
            }
            found = this.findMatch(nCurrPart + 1, target, foundIndex + nLen);
            if (found) continue;
            ++foundIndex;
            foundIndex = this.indexOfWild(target, part, foundIndex);
        }
        return found;
    }

    private boolean equalsWild(String target, String part) {
        boolean bEquals = true;
        if (target == null || part == null) {
            return false;
        }
        if (part.indexOf("?") < 0) {
            return target.equals(part);
        }
        if (target.length() != part.length()) {
            return false;
        }
        int nLen = target.length();
        int nIndex = 0;
        while (nIndex < nLen && bEquals) {
            char targetChar = target.charAt(nIndex);
            char partChar = part.charAt(nIndex);
            if (partChar != '?' && partChar != targetChar) {
                bEquals = false;
            }
            ++nIndex;
        }
        return bEquals;
    }

    private boolean endsWithWild(String target, String part) {
        if (target == null || part == null) {
            return false;
        }
        if (part.indexOf("?") < 0) {
            return target.endsWith(part);
        }
        if (target.length() < part.length()) {
            return false;
        }
        String targetEnd = target.substring(target.length() - part.length());
        return this.equalsWild(targetEnd, part);
    }

    private int indexOfWild(String target, String part, int fromIndex) {
        boolean bFound = false;
        int nFoundIndex = fromIndex;
        if (target == null || part == null || fromIndex < 0) {
            return -1;
        }
        if (part.indexOf("?") < 0) {
            return target.indexOf(part, fromIndex);
        }
        int nTargetLen = target.length();
        int nPartLen = part.length();
        if (nPartLen + fromIndex > nTargetLen) {
            return -1;
        }
        int nIndex = fromIndex;
        while (!bFound && nPartLen + nIndex <= nTargetLen) {
            String targetSub = target.substring(nIndex, nIndex + nPartLen);
            if (this.equalsWild(targetSub, part)) {
                nFoundIndex = nIndex;
                bFound = true;
            }
            ++nIndex;
        }
        if (!bFound) {
            return -1;
        }
        return nFoundIndex;
    }

    protected void parsePattern(String pat) {
        if (pat == null || pat.length() == 0) {
            return;
        }
        if (pat.startsWith("*")) {
            this.fields.add(null);
        }
        StringTokenizer tokenizer = new StringTokenizer(pat, "*");
        while (tokenizer.hasMoreTokens()) {
            if (ignoreCase) {
                this.fields.add(tokenizer.nextToken().toUpperCase());
                continue;
            }
            this.fields.add(tokenizer.nextToken());
        }
        if ((this.fields.size() > 1 || this.fields.size() == 1 && this.fields.get(0) != null) && pat.endsWith("*")) {
            this.fields.add(null);
        }
    }
}

