/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.classify.LogisticClassifier;
import edu.stanford.nlp.dcoref.CorefMentionFinder;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MentionExtractor {
    protected final HeadFinder headFinder = new SemanticHeadFinder();
    protected String currentDocumentID;
    protected final Dictionaries dictionaries;
    protected final Semantics semantics;
    public CorefMentionFinder mentionFinder;
    protected StanfordCoreNLP stanfordProcessor;
    protected LogisticClassifier<String, String> singletonPredictor;
    protected int maxID = -1;
    public static final boolean VERBOSE = false;
    private static final TregexPattern appositionPattern = TregexPattern.compile("NP=m1 < (NP=m2 $.. (/,/ $.. NP=m3))");
    private static final TregexPattern appositionPattern2 = TregexPattern.compile("NP=m1 < (NP=m2 $.. (/,/ $.. (SBAR < (WHNP < WP|WDT=m3))))");
    private static final TregexPattern appositionPattern3 = TregexPattern.compile("/^NP(?:-TMP|-ADV)?$/=m1 < (NP=m2 $- /^,$/ $-- NP=m3 !$ CC|CONJP)");
    private static final TregexPattern appositionPattern4 = TregexPattern.compile("/^NP(?:-TMP|-ADV)?$/=m1 < (PRN=m2 < (NP < /^NNS?|CD$/ $-- /^-LRB-$/ $+ /^-RRB-$/))");
    private static final TregexPattern predicateNominativePattern = TregexPattern.compile("S < (NP=m1 $.. (VP < ((/VB/ < /^(am|are|is|was|were|'m|'re|'s|be)$/) $.. NP=m2)))");
    private static final TregexPattern predicateNominativePattern2 = TregexPattern.compile("S < (NP=m1 $.. (VP < (VP < ((/VB/ < /^(be|been|being)$/) $.. NP=m2))))");
    private static final TregexPattern relativePronounPattern = TregexPattern.compile("NP < (NP=m1 $.. (SBAR < (WHNP < WP|WDT=m2)))");

    public MentionExtractor(Dictionaries dict, Semantics semantics) {
        this.dictionaries = dict;
        this.semantics = semantics;
        this.mentionFinder = new RuleBasedCorefMentionFinder();
    }

    public void setMentionFinder(CorefMentionFinder mentionFinder) {
        this.mentionFinder = mentionFinder;
    }

    public Document nextDoc() throws Exception {
        return null;
    }

    public void resetDocs() {
        this.maxID = -1;
        this.currentDocumentID = null;
    }

    public Document arrange(Annotation anno, List<List<CoreLabel>> words, List<Tree> trees, List<List<Mention>> unorderedMentions) throws Exception {
        return this.arrange(anno, words, trees, unorderedMentions, null, false);
    }

    protected int getHeadIndex(Tree t) {
        Tree ht = t.headTerminal(this.headFinder);
        if (ht == null) {
            return -1;
        }
        CoreLabel l = (CoreLabel)ht.label();
        return (Integer)l.get(CoreAnnotations.IndexAnnotation.class);
    }

    private String treeToKey(Tree t) {
        int idx = this.getHeadIndex(t);
        String key = Integer.toString(idx) + ':' + t.toString();
        return key;
    }

    public Document arrange(Annotation anno, List<List<CoreLabel>> words, List<Tree> trees, List<List<Mention>> unorderedMentions, List<List<Mention>> unorderedGoldMentions, boolean doMergeLabels) throws Exception {
        List<List<Mention>> predictedOrderedMentionsBySentence = this.arrange(anno, words, trees, unorderedMentions, doMergeLabels);
        List<List<Mention>> goldOrderedMentionsBySentence = null;
        if (unorderedGoldMentions != null) {
            goldOrderedMentionsBySentence = this.arrange(anno, words, trees, unorderedGoldMentions, doMergeLabels);
        }
        return new Document(anno, predictedOrderedMentionsBySentence, goldOrderedMentionsBySentence, this.dictionaries);
    }

    public List<List<Mention>> arrange(Annotation anno, List<List<CoreLabel>> words, List<Tree> trees, List<List<Mention>> unorderedMentions, boolean doMergeLabels) throws Exception {
        ArrayList<List<Mention>> orderedMentionsBySentence = new ArrayList<List<Mention>>();
        int sz = words.size();
        for (int sent = 0; sent < sz; ++sent) {
            List<CoreLabel> sentence = words.get(sent);
            Tree tree = trees.get(sent);
            List<Mention> mentions = unorderedMentions.get(sent);
            Map mentionsToTrees = Generics.newHashMap();
            if (doMergeLabels) {
                MentionExtractor.mergeLabels(tree, sentence);
            }
            for (Mention mention : mentions) {
                ArrayList<Mention> mentionsForTree;
                Tree headTree;
                mention.contextParseTree = tree;
                mention.sentenceWords = sentence;
                mention.originalSpan = new ArrayList<CoreLabel>(mention.sentenceWords.subList(mention.startIndex, mention.endIndex));
                if (!((CoreLabel)tree.label()).has(CoreAnnotations.BeginIndexAnnotation.class)) {
                    tree.indexSpans(0);
                }
                if (mention.headWord == null) {
                    headTree = ((RuleBasedCorefMentionFinder)this.mentionFinder).findSyntacticHead(mention, tree, sentence);
                    mention.headWord = (CoreLabel)headTree.label();
                    mention.headIndex = (Integer)mention.headWord.get(CoreAnnotations.IndexAnnotation.class) - 1;
                }
                if (mention.mentionSubTree == null) {
                    headTree = (Tree)tree.getLeaves().get(mention.headIndex);
                    if (headTree == null) {
                        throw new RuntimeException("Missing head tree for a mention!");
                    }
                    Tree t = headTree;
                    while ((t = t.parent(tree)) != null) {
                        if (t.headTerminal(this.headFinder) == headTree && t.value().equals("NP")) {
                            mention.mentionSubTree = t;
                            continue;
                        }
                        if (mention.mentionSubTree == null) continue;
                    }
                    if (mention.mentionSubTree == null) {
                        mention.mentionSubTree = headTree;
                    }
                }
                if ((mentionsForTree = (ArrayList<Mention>)mentionsToTrees.get(this.treeToKey(mention.mentionSubTree))) == null) {
                    mentionsForTree = new ArrayList<Mention>();
                    mentionsToTrees.put(this.treeToKey(mention.mentionSubTree), mentionsForTree);
                }
                mentionsForTree.add(mention);
                mention.process(this.dictionaries, this.semantics, this, this.singletonPredictor);
            }
            ArrayList<Mention> orderedMentions = new ArrayList<Mention>();
            orderedMentionsBySentence.add(orderedMentions);
            for (Tree t : tree.preOrderNodeList()) {
                List lm = (List)mentionsToTrees.get(this.treeToKey(t));
                if (lm == null) continue;
                for (Mention m : lm) {
                    orderedMentions.add(m);
                }
            }
            this.findSyntacticRelations(tree, orderedMentions);
            assert (mentions.size() == orderedMentions.size());
        }
        return orderedMentionsBySentence;
    }

    public static void mergeLabels(Tree tree, List<CoreLabel> sentence) {
        int idx = 0;
        for (Tree t : tree.getLeaves()) {
            CoreLabel cl = sentence.get(idx++);
            String value = t.value();
            cl.set(CoreAnnotations.ValueAnnotation.class, value);
            t.setLabel(cl);
        }
        tree.indexLeaves();
    }

    private static boolean inside(int i, Mention m) {
        return i >= m.startIndex && i < m.endIndex;
    }

    private void findSyntacticRelations(Tree tree, List<Mention> orderedMentions) {
        MentionExtractor.markListMemberRelation(orderedMentions);
        Set<Pair<Integer, Integer>> appos = Generics.newHashSet();
        this.findAppositions(tree, appos);
        MentionExtractor.markMentionRelation(orderedMentions, appos, "APPOSITION");
        Set<Pair<Integer, Integer>> preNomi = Generics.newHashSet();
        this.findPredicateNominatives(tree, preNomi);
        MentionExtractor.markMentionRelation(orderedMentions, preNomi, "PREDICATE_NOMINATIVE");
        Set<Pair<Integer, Integer>> relativePronounPairs = Generics.newHashSet();
        this.findRelativePronouns(tree, relativePronounPairs);
        MentionExtractor.markMentionRelation(orderedMentions, relativePronounPairs, "RELATIVE_PRONOUN");
    }

    private void findTreePattern(Tree tree, String tregex, Set<Pair<Integer, Integer>> foundPairs) {
        try {
            TregexPattern tgrepPattern = TregexPattern.compile(tregex);
            this.findTreePattern(tree, tgrepPattern, foundPairs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void findTreePattern(Tree tree, TregexPattern tgrepPattern, Set<Pair<Integer, Integer>> foundPairs) {
        try {
            TregexMatcher m = tgrepPattern.matcher(tree);
            while (m.find()) {
                Tree t = m.getMatch();
                Tree np1 = m.getNode("m1");
                Tree np2 = m.getNode("m2");
                Tree np3 = null;
                if (tgrepPattern.pattern().contains("m3")) {
                    np3 = m.getNode("m3");
                }
                this.addFoundPair(np1, np2, t, foundPairs);
                if (np3 == null) continue;
                this.addFoundPair(np2, np3, t, foundPairs);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addFoundPair(Tree np1, Tree np2, Tree t, Set<Pair<Integer, Integer>> foundPairs) {
        Tree head1 = np1.headTerminal(this.headFinder);
        Tree head2 = np2.headTerminal(this.headFinder);
        int h1 = (Integer)((CoreMap)((Object)head1.label())).get(CoreAnnotations.IndexAnnotation.class) - 1;
        int h2 = (Integer)((CoreMap)((Object)head2.label())).get(CoreAnnotations.IndexAnnotation.class) - 1;
        Pair<Integer, Integer> p = new Pair<Integer, Integer>(h1, h2);
        foundPairs.add(p);
    }

    private void findAppositions(Tree tree, Set<Pair<Integer, Integer>> appos) {
        this.findTreePattern(tree, appositionPattern, appos);
        this.findTreePattern(tree, appositionPattern2, appos);
        this.findTreePattern(tree, appositionPattern3, appos);
        this.findTreePattern(tree, appositionPattern4, appos);
    }

    private void findPredicateNominatives(Tree tree, Set<Pair<Integer, Integer>> preNomi) {
        this.findTreePattern(tree, predicateNominativePattern, preNomi);
        this.findTreePattern(tree, predicateNominativePattern2, preNomi);
    }

    private void findRelativePronouns(Tree tree, Set<Pair<Integer, Integer>> relativePronounPairs) {
        this.findTreePattern(tree, relativePronounPattern, relativePronounPairs);
    }

    private static void markListMemberRelation(List<Mention> orderedMentions) {
        for (Mention m1 : orderedMentions) {
            for (Mention m2 : orderedMentions) {
                if (m1.isListMemberOf(m2)) {
                    m2.addListMember(m1);
                    m1.addBelongsToList(m2);
                    continue;
                }
                if (!m2.isListMemberOf(m1)) continue;
                m1.addListMember(m2);
                m2.addBelongsToList(m1);
            }
        }
    }

    private static void markMentionRelation(List<Mention> orderedMentions, Set<Pair<Integer, Integer>> foundPairs, String flag) {
        for (Mention m1 : orderedMentions) {
            for (Mention m2 : orderedMentions) {
                if (m1.isListMemberOf(m2) || m2.isListMemberOf(m1) || m1.isMemberOfSameList(m2)) {
                    SieveCoreferenceSystem.logger.finest("Not checking '" + m1 + "' and '" + m2 + "' for " + flag + ": in list relationship");
                    continue;
                }
                for (Pair<Integer, Integer> foundPair : foundPairs) {
                    if ((Integer)foundPair.first != m1.headIndex || (Integer)foundPair.second != m2.headIndex) continue;
                    if (flag.equals("APPOSITION")) {
                        m2.addApposition(m1);
                        continue;
                    }
                    if (flag.equals("PREDICATE_NOMINATIVE")) {
                        m2.addPredicateNominatives(m1);
                        continue;
                    }
                    if (flag.equals("RELATIVE_PRONOUN")) {
                        m2.addRelativePronoun(m1);
                        continue;
                    }
                    throw new RuntimeException("check flag in markMentionRelation (dcoref/MentionExtractor.java)");
                }
            }
        }
    }

    public static Tree findExactMatch(Tree tree, int first, int last) {
        Tree[] kids;
        List leaves = tree.getLeaves();
        int thisFirst = (Integer)((CoreMap)((Object)((Tree)leaves.get(0)).label())).get(CoreAnnotations.IndexAnnotation.class);
        int thisLast = (Integer)((CoreMap)((Object)((Tree)leaves.get(leaves.size() - 1)).label())).get(CoreAnnotations.IndexAnnotation.class);
        if (thisFirst == first && thisLast == last) {
            return tree;
        }
        for (Tree k : kids = tree.children()) {
            Tree t = MentionExtractor.findExactMatch(k, first, last);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    protected static StanfordCoreNLP loadStanfordProcessor(Properties props) {
        boolean replicateCoNLL = Boolean.parseBoolean(props.getProperty("dcoref.replicate.conll", "false"));
        Properties pipelineProps = new Properties(props);
        StringBuilder annoSb = new StringBuilder("");
        if (!replicateCoNLL) {
            annoSb.append("pos, lemma");
        } else {
            annoSb.append("lemma");
        }
        if (!replicateCoNLL) {
            annoSb.append(", ner");
        }
        if (!replicateCoNLL) {
            annoSb.append(", parse");
        }
        String annoStr = annoSb.toString();
        SieveCoreferenceSystem.logger.info("MentionExtractor ignores specified annotators, using annotators=" + annoStr);
        pipelineProps.put("annotators", annoStr);
        return new StanfordCoreNLP(pipelineProps, false);
    }

    public static void initializeUtterance(List<CoreLabel> tokens) {
        for (CoreLabel l : tokens) {
            if (l.get(CoreAnnotations.UtteranceAnnotation.class) != null) continue;
            l.set(CoreAnnotations.UtteranceAnnotation.class, 0);
        }
    }
}

