/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.international.pennchinese.RadicalMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NERFeatureFactory<IN extends CoreLabel>
extends FeatureFactory<IN> {
    private static final long serialVersionUID = -2329726064739185544L;
    private Map<String, String> lexicon;
    private Map<String, Collection<String>> wordToSubstrings = Generics.newHashMap();
    private static final Pattern ordinalPattern = Pattern.compile("(?:(?:first|second|third|fourth|fifth|sixth|seventh|eighth|ninth|tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twenty|twentieth|thirty|thirtieth|forty|fortieth|fifty|fiftieth|sixty|sixtieth|seventy|seventieth|eighty|eightieth|ninety|ninetieth|one|two|three|four|five|six|seven|eight|nine|hundred|hundredth)-?)+|[0-9]+(?:st|nd|rd|th)", 2);
    private static final Pattern numberPattern = Pattern.compile("[0-9]+");
    private static final Pattern ordinalEndPattern = Pattern.compile("(?:st|nd|rd|th)", 2);
    private Map<String, Collection<String>> wordToGazetteEntries = Generics.newHashMap();
    private Map<String, Collection<GazetteInfo>> wordToGazetteInfos = Generics.newHashMap();
    private Set<Class<? extends CoreLabel.GenericAnnotation<?>>> genericAnnotationKeys;
    private Set<String> lastNames;
    private Set<String> maleNames;
    private Set<String> femaleNames;
    private final Pattern titlePattern = Pattern.compile("(?:Mr|Ms|Mrs|Dr|Miss|Sen|Judge|Sir)\\.?");

    @Override
    public void init(SeqClassifierFlags flags) {
        super.init(flags);
        this.initGazette();
        if (flags.useDistSim) {
            this.initLexicon(flags);
        }
    }

    @Override
    public Collection<String> getCliqueFeatures(PaddedList<IN> cInfo, int loc, Clique clique) {
        String suffix;
        Collection<String> c;
        boolean doFE;
        Set<String> features = Generics.newHashSet();
        String domain = (String)((CoreLabel)cInfo.get(0)).get(CoreAnnotations.DomainAnnotation.class);
        boolean bl = doFE = domain != null;
        if (clique == cliqueC) {
            c = this.featuresC(cInfo, loc);
            suffix = "C";
        } else if (clique == cliqueCpC) {
            c = this.featuresCpC(cInfo, loc);
            suffix = "CpC";
            this.addAllInterningAndSuffixing(features, c, suffix);
            if (doFE) {
                this.addAllInterningAndSuffixing(features, c, domain + '-' + suffix);
            }
            c = this.featuresCnC(cInfo, loc - 1);
            suffix = "CnC";
        } else if (clique == cliqueCp2C) {
            c = this.featuresCp2C(cInfo, loc);
            suffix = "Cp2C";
        } else if (clique == cliqueCp3C) {
            c = this.featuresCp3C(cInfo, loc);
            suffix = "Cp3C";
        } else if (clique == cliqueCp4C) {
            c = this.featuresCp4C(cInfo, loc);
            suffix = "Cp4C";
        } else if (clique == cliqueCp5C) {
            c = this.featuresCp5C(cInfo, loc);
            suffix = "Cp5C";
        } else if (clique == cliqueCpCp2C) {
            c = this.featuresCpCp2C(cInfo, loc);
            suffix = "CpCp2C";
            this.addAllInterningAndSuffixing(features, c, suffix);
            if (doFE) {
                this.addAllInterningAndSuffixing(features, c, domain + '-' + suffix);
            }
            c = this.featuresCpCnC(cInfo, loc - 1);
            suffix = "CpCnC";
        } else if (clique == cliqueCpCp2Cp3C) {
            c = this.featuresCpCp2Cp3C(cInfo, loc);
            suffix = "CpCp2Cp3C";
        } else if (clique == cliqueCpCp2Cp3Cp4C) {
            c = this.featuresCpCp2Cp3Cp4C(cInfo, loc);
            suffix = "CpCp2Cp3Cp4C";
        } else {
            throw new IllegalArgumentException("Unknown clique: " + clique);
        }
        this.addAllInterningAndSuffixing(features, c, suffix);
        if (doFE) {
            this.addAllInterningAndSuffixing(features, c, domain + '-' + suffix);
        }
        return features;
    }

    private void initLexicon(SeqClassifierFlags flags) {
        if (flags.distSimLexicon == null) {
            return;
        }
        if (this.lexicon != null) {
            return;
        }
        Timing.startDoing("Loading distsim lexicon from " + flags.distSimLexicon);
        this.lexicon = Generics.newHashMap();
        boolean terryKoo = "terryKoo".equals(flags.distSimFileFormat);
        for (String line : ObjectBank.getLineIterator(flags.distSimLexicon, flags.inputEncoding)) {
            String wordClass;
            String word;
            String[] bits;
            if (terryKoo) {
                bits = line.split("\\t");
                word = bits[1];
                wordClass = bits[0];
                if (flags.distSimMaxBits > 0 && wordClass.length() > flags.distSimMaxBits) {
                    wordClass = wordClass.substring(0, flags.distSimMaxBits);
                }
            } else {
                bits = line.split("\\s+");
                word = bits[0];
                wordClass = bits[1];
            }
            if (!flags.casedDistSim) {
                word = word.toLowerCase();
            }
            if (flags.numberEquivalenceDistSim) {
                word = WordShapeClassifier.wordShape(word, 13);
            }
            this.lexicon.put(word, wordClass);
        }
        Timing.endDoing();
    }

    private void distSimAnnotate(PaddedList<IN> info) {
        for (CoreLabel fl : info) {
            String distSim;
            if (fl.has(CoreAnnotations.DistSimAnnotation.class)) {
                return;
            }
            String word = this.getWord(fl);
            if (!this.flags.casedDistSim) {
                word = word.toLowerCase();
            }
            if (this.flags.numberEquivalenceDistSim) {
                word = WordShapeClassifier.wordShape(word, 13);
            }
            if ((distSim = this.lexicon.get(word)) == null) {
                distSim = this.flags.unknownWordDistSimClass;
            }
            fl.set(CoreAnnotations.DistSimAnnotation.class, distSim);
        }
    }

    public void clearMemory() {
        this.wordToSubstrings = Generics.newHashMap();
        this.lexicon = null;
    }

    private static String dehyphenate(String str) {
        String retStr = str;
        int leng = str.length();
        int hyphen = 2;
        do {
            if ((hyphen = retStr.indexOf(45, hyphen)) >= 0 && hyphen < leng - 2) {
                retStr = retStr.substring(0, hyphen) + retStr.substring(hyphen + 1);
                continue;
            }
            hyphen = -1;
        } while (hyphen >= 0);
        return retStr;
    }

    private static String greekify(String str) {
        String pattern = "(alpha)|(beta)|(gamma)|(delta)|(epsilon)|(zeta)|(kappa)|(lambda)|(rho)|(sigma)|(tau)|(upsilon)|(omega)";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        return m.replaceAll("~");
    }

    private static boolean isNameCase(String str) {
        if (str.length() < 2) {
            return false;
        }
        if (!Character.isUpperCase(str.charAt(0)) && !Character.isTitleCase(str.charAt(0))) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean noUpperCase(String str) {
        if (str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasLetter(String str) {
        if (str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLetter(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isOrdinal(List<? extends CoreLabel> wordInfos, int pos) {
        CoreLabel p;
        CoreLabel c = wordInfos.get(pos);
        String cWord = this.getWord(c);
        Matcher m = ordinalPattern.matcher(cWord);
        if (m.matches()) {
            return true;
        }
        m = numberPattern.matcher(cWord);
        if (m.matches()) {
            CoreLabel n;
            return pos + 1 < wordInfos.size() && (m = ordinalEndPattern.matcher(this.getWord(n = wordInfos.get(pos + 1)))).matches();
        }
        m = ordinalEndPattern.matcher(cWord);
        if (m.matches() && pos > 0 && (m = numberPattern.matcher(this.getWord(p = wordInfos.get(pos - 1)))).matches()) {
            return true;
        }
        if (cWord.equals("-") && pos + 1 < wordInfos.size() && pos > 0) {
            p = wordInfos.get(pos - 1);
            CoreLabel n = wordInfos.get(pos + 1);
            m = ordinalPattern.matcher(this.getWord(p));
            if (m.matches() && (m = ordinalPattern.matcher(this.getWord(n))).matches()) {
                return true;
            }
        }
        return false;
    }

    private void readGazette(BufferedReader in) throws IOException {
        String line;
        Pattern p = Pattern.compile("^(\\S+)\\s+(.+)$");
        while ((line = in.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            String type = this.intern(m.group(1));
            String phrase = m.group(2);
            String[] words = phrase.split(" ");
            for (int i = 0; i < words.length; ++i) {
                String word = this.intern(words[i]);
                if (this.flags.sloppyGazette) {
                    Collection<String> entries = this.wordToGazetteEntries.get(word);
                    if (entries == null) {
                        entries = Generics.newHashSet();
                        this.wordToGazetteEntries.put(word, entries);
                    }
                    String feature = this.intern(type + "-GAZ" + words.length);
                    entries.add(feature);
                    feature = this.intern(type + "-GAZ");
                    entries.add(feature);
                }
                if (!this.flags.cleanGazette) continue;
                Collection<GazetteInfo> infos = this.wordToGazetteInfos.get(word);
                if (infos == null) {
                    infos = Generics.newHashSet();
                    this.wordToGazetteInfos.put(word, infos);
                }
                GazetteInfo info = new GazetteInfo(this.intern(type + "-GAZ" + words.length), i, words);
                infos.add(info);
                info = new GazetteInfo(this.intern(type + "-GAZ"), i, words);
                infos.add(info);
            }
        }
    }

    private void makeGenericKeyCache(CoreLabel c) {
        this.genericAnnotationKeys = Generics.newHashSet();
        for (Class<?> key : c.keySet()) {
            if (!CoreLabel.genericValues.containsKey(key)) continue;
            Class<?> genKey = key;
            this.genericAnnotationKeys.add(genKey);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Collection<String> featuresC(PaddedList<IN> cInfo, int loc) {
        Matcher m;
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel n = (CoreLabel)cInfo.get(loc + 1);
        CoreLabel n2 = (CoreLabel)cInfo.get(loc + 2);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String nWord = this.getWord(n);
        String cShape = c.getString(CoreAnnotations.ShapeAnnotation.class);
        String pShape = p.getString(CoreAnnotations.ShapeAnnotation.class);
        String nShape = n.getString(CoreAnnotations.ShapeAnnotation.class);
        ArrayList<String> featuresC = new ArrayList<String>();
        if (this.flags.useDistSim) {
            this.distSimAnnotate(cInfo);
        }
        if (this.flags.useBagOfWords) {
            for (CoreLabel coreLabel : cInfo) {
                featuresC.add(this.getWord(coreLabel) + "-BAGOFWORDS");
            }
        }
        if (this.flags.useDistSim && this.flags.useMoreTags) {
            featuresC.add((String)p.get(CoreAnnotations.DistSimAnnotation.class) + '-' + cWord + "-PDISTSIM-CWORD");
        }
        if (this.flags.useDistSim) {
            featuresC.add((String)c.get(CoreAnnotations.DistSimAnnotation.class) + "-DISTSIM");
        }
        if (this.flags.useTitle && (m = this.titlePattern.matcher(cWord)).matches()) {
            featuresC.add("IS_TITLE");
        }
        if (this.flags.useInternal && this.flags.useExternal) {
            CoreLabel wi;
            int j;
            String string;
            String lem;
            if (this.flags.useWord) {
                featuresC.add(cWord + "-WORD");
            }
            if (this.flags.use2W) {
                featuresC.add(this.getWord(p2) + "-P2W");
                featuresC.add(this.getWord(n2) + "-N2W");
            }
            if (this.flags.useLC) {
                featuresC.add(cWord.toLowerCase() + "-CL");
                featuresC.add(pWord.toLowerCase() + "-PL");
                featuresC.add(nWord.toLowerCase() + "-NL");
            }
            if (this.flags.useUnknown) {
                featuresC.add((String)c.get(CoreAnnotations.UnknownAnnotation.class) + "-UNKNOWN");
                featuresC.add((String)p.get(CoreAnnotations.UnknownAnnotation.class) + "-PUNKNOWN");
                featuresC.add((String)n.get(CoreAnnotations.UnknownAnnotation.class) + "-NUNKNOWN");
            }
            if (this.flags.useLemmas && !"".equals(lem = c.getString(CoreAnnotations.LemmaAnnotation.class))) {
                featuresC.add(lem + "-LEM");
            }
            if (this.flags.usePrevNextLemmas) {
                String plem = p.getString(CoreAnnotations.LemmaAnnotation.class);
                String string2 = n.getString(CoreAnnotations.LemmaAnnotation.class);
                if (!"".equals(plem)) {
                    featuresC.add(plem + "-PLEM");
                }
                if (!"".equals(string2)) {
                    featuresC.add(string2 + "-NLEM");
                }
            }
            if (this.flags.checkNameList) {
                try {
                    String name;
                    String[] cols;
                    if (this.lastNames == null) {
                        this.lastNames = Generics.newHashSet();
                        for (String string3 : ObjectBank.getLineIterator(this.flags.lastNameList)) {
                            cols = string3.split("\\s+");
                            this.lastNames.add(cols[0]);
                        }
                    }
                    if (this.maleNames == null) {
                        this.maleNames = Generics.newHashSet();
                        for (String string4 : ObjectBank.getLineIterator(this.flags.maleNameList)) {
                            cols = string4.split("\\s+");
                            this.maleNames.add(cols[0]);
                        }
                    }
                    if (this.femaleNames == null) {
                        this.femaleNames = Generics.newHashSet();
                        for (String string5 : ObjectBank.getLineIterator(this.flags.femaleNameList)) {
                            cols = string5.split("\\s+");
                            this.femaleNames.add(cols[0]);
                        }
                    }
                    if (this.lastNames.contains(name = cWord.toUpperCase())) {
                        featuresC.add("LAST_NAME");
                    }
                    if (this.maleNames.contains(name)) {
                        featuresC.add("MALE_NAME");
                    }
                    if (this.femaleNames.contains(name)) {
                        featuresC.add("FEMALE_NAME");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.flags.binnedLengths != null) {
                void var17_43;
                int len = cWord.length();
                Object var17_39 = null;
                for (int i = 0; i <= this.flags.binnedLengths.length; ++i) {
                    if (i == this.flags.binnedLengths.length) {
                        String string6 = "Len-" + this.flags.binnedLengths[this.flags.binnedLengths.length - 1] + "-Inf";
                        continue;
                    }
                    if (len > this.flags.binnedLengths[i]) continue;
                    String string7 = "Len-" + (i == 0 ? 1 : this.flags.binnedLengths[i - 1]) + '-' + this.flags.binnedLengths[i];
                    break;
                }
                featuresC.add((String)var17_43);
            }
            if (this.flags.useABGENE) {
                featuresC.add((String)c.get(CoreAnnotations.AbgeneAnnotation.class) + "-ABGENE");
                featuresC.add((String)p.get(CoreAnnotations.AbgeneAnnotation.class) + "-PABGENE");
                featuresC.add((String)n.get(CoreAnnotations.AbgeneAnnotation.class) + "-NABGENE");
            }
            if (this.flags.useABSTRFreqDict) {
                featuresC.add((String)c.get(CoreAnnotations.AbstrAnnotation.class) + "-ABSTRACT" + (String)c.get(CoreAnnotations.FreqAnnotation.class) + "-FREQ" + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TAG");
                featuresC.add((String)c.get(CoreAnnotations.AbstrAnnotation.class) + "-ABSTRACT" + (String)c.get(CoreAnnotations.DictAnnotation.class) + "-DICT" + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TAG");
                featuresC.add((String)c.get(CoreAnnotations.AbstrAnnotation.class) + "-ABSTRACT" + (String)c.get(CoreAnnotations.DictAnnotation.class) + "-DICT" + (String)c.get(CoreAnnotations.FreqAnnotation.class) + "-FREQ" + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TAG");
            }
            if (this.flags.useABSTR) {
                featuresC.add((String)c.get(CoreAnnotations.AbstrAnnotation.class) + "-ABSTRACT");
                featuresC.add((String)p.get(CoreAnnotations.AbstrAnnotation.class) + "-PABSTRACT");
                featuresC.add((String)n.get(CoreAnnotations.AbstrAnnotation.class) + "-NABSTRACT");
            }
            if (this.flags.useGENIA) {
                featuresC.add((String)c.get(CoreAnnotations.GeniaAnnotation.class) + "-GENIA");
                featuresC.add((String)p.get(CoreAnnotations.GeniaAnnotation.class) + "-PGENIA");
                featuresC.add((String)n.get(CoreAnnotations.GeniaAnnotation.class) + "-NGENIA");
            }
            if (this.flags.useWEBFreqDict) {
                featuresC.add((String)c.get(CoreAnnotations.WebAnnotation.class) + "-WEB" + (String)c.get(CoreAnnotations.FreqAnnotation.class) + "-FREQ" + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TAG");
                featuresC.add((String)c.get(CoreAnnotations.WebAnnotation.class) + "-WEB" + (String)c.get(CoreAnnotations.DictAnnotation.class) + "-DICT" + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TAG");
                featuresC.add((String)c.get(CoreAnnotations.WebAnnotation.class) + "-WEB" + (String)c.get(CoreAnnotations.DictAnnotation.class) + "-DICT" + (String)c.get(CoreAnnotations.FreqAnnotation.class) + "-FREQ" + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TAG");
            }
            if (this.flags.useWEB) {
                featuresC.add((String)c.get(CoreAnnotations.WebAnnotation.class) + "-WEB");
                featuresC.add((String)p.get(CoreAnnotations.WebAnnotation.class) + "-PWEB");
                featuresC.add((String)n.get(CoreAnnotations.WebAnnotation.class) + "-NWEB");
            }
            if (this.flags.useIsURL) {
                featuresC.add((String)c.get(CoreAnnotations.IsURLAnnotation.class) + "-ISURL");
            }
            if (this.flags.useEntityRule) {
                featuresC.add((String)c.get(CoreAnnotations.EntityRuleAnnotation.class) + "-ENTITYRULE");
            }
            if (this.flags.useEntityTypes) {
                featuresC.add((String)c.get(CoreAnnotations.EntityTypeAnnotation.class) + "-ENTITYTYPE");
            }
            if (this.flags.useIsDateRange) {
                featuresC.add((String)c.get(CoreAnnotations.IsDateRangeAnnotation.class) + "-ISDATERANGE");
            }
            if (this.flags.useABSTRFreq) {
                featuresC.add((String)c.get(CoreAnnotations.AbstrAnnotation.class) + "-ABSTRACT" + (String)c.get(CoreAnnotations.FreqAnnotation.class) + "-FREQ");
            }
            if (this.flags.useFREQ) {
                featuresC.add((String)c.get(CoreAnnotations.FreqAnnotation.class) + "-FREQ");
            }
            if (this.flags.useMoreTags) {
                featuresC.add(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + cWord + "-PTAG-CWORD");
            }
            if (this.flags.usePosition) {
                featuresC.add((String)c.get(CoreAnnotations.PositionAnnotation.class) + "-POSITION");
            }
            if (this.flags.useBeginSent) {
                String pos = (String)c.get(CoreAnnotations.PositionAnnotation.class);
                if ("0".equals(pos)) {
                    featuresC.add("BEGIN-SENT");
                    featuresC.add(cShape + "-BEGIN-SENT");
                } else if (Integer.toString(cInfo.size() - 1).equals(pos)) {
                    featuresC.add("END-SENT");
                    featuresC.add(cShape + "-END-SENT");
                } else {
                    featuresC.add("IN-SENT");
                    featuresC.add(cShape + "-IN-SENT");
                }
            }
            if (this.flags.useTags) {
                featuresC.add(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TAG");
            }
            if (this.flags.useOrdinal) {
                if (this.isOrdinal(cInfo, loc)) {
                    featuresC.add("C_ORDINAL");
                    if (this.isOrdinal(cInfo, loc - 1)) {
                        featuresC.add("PC_ORDINAL");
                    }
                }
                if (this.isOrdinal(cInfo, loc - 1)) {
                    featuresC.add("P_ORDINAL");
                }
            }
            if (this.flags.usePrev) {
                featuresC.add(pWord + "-PW");
                if (this.flags.useTags) {
                    featuresC.add(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-PTAG");
                }
                if (this.flags.useDistSim) {
                    featuresC.add((String)p.get(CoreAnnotations.DistSimAnnotation.class) + "-PDISTSIM");
                }
                if (this.flags.useIsURL) {
                    featuresC.add((String)p.get(CoreAnnotations.IsURLAnnotation.class) + "-PISURL");
                }
                if (this.flags.useEntityTypes) {
                    featuresC.add((String)p.get(CoreAnnotations.EntityTypeAnnotation.class) + "-PENTITYTYPE");
                }
            }
            if (this.flags.useNext) {
                featuresC.add(nWord + "-NW");
                if (this.flags.useTags) {
                    featuresC.add(n.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-NTAG");
                }
                if (this.flags.useDistSim) {
                    featuresC.add((String)n.get(CoreAnnotations.DistSimAnnotation.class) + "-NDISTSIM");
                }
                if (this.flags.useIsURL) {
                    featuresC.add((String)n.get(CoreAnnotations.IsURLAnnotation.class) + "-NISURL");
                }
                if (this.flags.useEntityTypes) {
                    featuresC.add((String)n.get(CoreAnnotations.EntityTypeAnnotation.class) + "-NENTITYTYPE");
                }
            }
            if (this.flags.useEitherSideWord) {
                featuresC.add(pWord + "-EW");
                featuresC.add(nWord + "-EW");
            }
            if (this.flags.useWordPairs) {
                featuresC.add(cWord + '-' + pWord + "-W-PW");
                featuresC.add(cWord + '-' + nWord + "-W-NW");
            }
            if (this.flags.useSymTags) {
                if (this.flags.useTags) {
                    featuresC.add(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + n.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-PCNTAGS");
                    featuresC.add(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + n.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-CNTAGS");
                    featuresC.add(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-PCTAGS");
                }
                if (this.flags.useDistSim) {
                    featuresC.add((String)p.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)n.get(CoreAnnotations.DistSimAnnotation.class) + "-PCNDISTSIM");
                    featuresC.add((String)c.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)n.get(CoreAnnotations.DistSimAnnotation.class) + "-CNDISTSIM");
                    featuresC.add((String)p.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + "-PCDISTSIM");
                }
            }
            if (this.flags.useSymWordPairs) {
                featuresC.add(pWord + '-' + nWord + "-SWORDS");
            }
            String pGazAnnotationClass = this.flags.useGazFeatures || this.flags.useMoreGazFeatures ? (String)p.get(CoreAnnotations.GazAnnotation.class) : null;
            String string8 = string = this.flags.useGazFeatures || this.flags.useMoreGazFeatures ? (String)n.get(CoreAnnotations.GazAnnotation.class) : null;
            if (this.flags.useGazFeatures) {
                if (!((String)c.get(CoreAnnotations.GazAnnotation.class)).equals(this.flags.dropGaz)) {
                    featuresC.add((String)c.get(CoreAnnotations.GazAnnotation.class) + "-GAZ");
                }
                if (string != null && !string.equals(this.flags.dropGaz)) {
                    featuresC.add(string + "-NGAZ");
                }
                if (pGazAnnotationClass != null && !pGazAnnotationClass.equals(this.flags.dropGaz)) {
                    featuresC.add(pGazAnnotationClass + "-PGAZ");
                }
            }
            if (this.flags.useMoreGazFeatures && !((String)c.get(CoreAnnotations.GazAnnotation.class)).equals(this.flags.dropGaz)) {
                featuresC.add((String)c.get(CoreAnnotations.GazAnnotation.class) + '-' + cWord + "-CG-CW-GAZ");
                if (string != null && !string.equals(this.flags.dropGaz)) {
                    featuresC.add((String)c.get(CoreAnnotations.GazAnnotation.class) + '-' + string + "-CNGAZ");
                }
                if (pGazAnnotationClass != null && !pGazAnnotationClass.equals(this.flags.dropGaz)) {
                    featuresC.add(pGazAnnotationClass + '-' + (String)c.get(CoreAnnotations.GazAnnotation.class) + "-PCGAZ");
                }
            }
            if (this.flags.useAbbr || this.flags.useMinimalAbbr) {
                featuresC.add((String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-ABBR");
            }
            if ((this.flags.useAbbr1 || this.flags.useMinimalAbbr1) && !((String)c.get(CoreAnnotations.AbbrAnnotation.class)).equals("XX")) {
                featuresC.add((String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-ABBR");
            }
            if (this.flags.useAbbr) {
                featuresC.add((String)p.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-PCABBR");
                featuresC.add((String)c.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)n.get(CoreAnnotations.AbbrAnnotation.class) + "-CNABBR");
                featuresC.add((String)p.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)n.get(CoreAnnotations.AbbrAnnotation.class) + "-PCNABBR");
            }
            if (this.flags.useAbbr1 && !((String)c.get(CoreAnnotations.AbbrAnnotation.class)).equals("XX")) {
                featuresC.add((String)p.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-PCABBR");
                featuresC.add((String)c.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)n.get(CoreAnnotations.AbbrAnnotation.class) + "-CNABBR");
                featuresC.add((String)p.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)n.get(CoreAnnotations.AbbrAnnotation.class) + "-PCNABBR");
            }
            if (this.flags.useChunks) {
                featuresC.add((String)p.get(CoreAnnotations.ChunkAnnotation.class) + '-' + (String)c.get(CoreAnnotations.ChunkAnnotation.class) + "-PCCHUNK");
                featuresC.add((String)c.get(CoreAnnotations.ChunkAnnotation.class) + '-' + (String)n.get(CoreAnnotations.ChunkAnnotation.class) + "-CNCHUNK");
                featuresC.add((String)p.get(CoreAnnotations.ChunkAnnotation.class) + '-' + (String)c.get(CoreAnnotations.ChunkAnnotation.class) + '-' + (String)n.get(CoreAnnotations.ChunkAnnotation.class) + "-PCNCHUNK");
            }
            if (this.flags.useMinimalAbbr) {
                featuresC.add(cWord + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-CWABB");
            }
            if (this.flags.useMinimalAbbr1 && !((String)c.get(CoreAnnotations.AbbrAnnotation.class)).equals("XX")) {
                featuresC.add(cWord + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-CWABB");
            }
            String prevVB = "";
            String nextVB = "";
            if (this.flags.usePrevVB) {
                j = loc - 1;
                while (true) {
                    if ((wi = (CoreLabel)cInfo.get(j)) == cInfo.getPad()) {
                        prevVB = "X";
                        featuresC.add("X-PVB");
                        break;
                    }
                    if (wi.getString(CoreAnnotations.PartOfSpeechAnnotation.class).startsWith("VB")) {
                        featuresC.add(this.getWord(wi) + "-PVB");
                        prevVB = this.getWord(wi);
                        break;
                    }
                    --j;
                }
            }
            if (this.flags.useNextVB) {
                j = loc + 1;
                while (true) {
                    if ((wi = (CoreLabel)cInfo.get(j)) == cInfo.getPad()) {
                        featuresC.add("X-NVB");
                        nextVB = "X";
                        break;
                    }
                    if (wi.getString(CoreAnnotations.PartOfSpeechAnnotation.class).startsWith("VB")) {
                        featuresC.add(this.getWord(wi) + "-NVB");
                        nextVB = this.getWord(wi);
                        break;
                    }
                    ++j;
                }
            }
            if (this.flags.useVB) {
                featuresC.add(prevVB + '-' + nextVB + "-PNVB");
            }
            if (this.flags.useShapeConjunctions) {
                featuresC.add((String)c.get(CoreAnnotations.PositionAnnotation.class) + cShape + "-POS-SH");
                if (this.flags.useTags) {
                    featuresC.add(c.tag() + cShape + "-TAG-SH");
                }
                if (this.flags.useDistSim) {
                    featuresC.add((String)c.get(CoreAnnotations.DistSimAnnotation.class) + cShape + "-DISTSIM-SH");
                }
            }
            if (this.flags.useWordTag) {
                featuresC.add(cWord + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-W-T");
                featuresC.add(cWord + '-' + p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-W-PT");
                featuresC.add(cWord + '-' + n.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-W-NT");
            }
            if (this.flags.useNPHead) {
                featuresC.add(c.get(TreeCoreAnnotations.HeadWordAnnotation.class) + "-HW");
                if (this.flags.useTags) {
                    featuresC.add(c.get(TreeCoreAnnotations.HeadWordAnnotation.class) + "-" + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-HW-T");
                }
                if (this.flags.useDistSim) {
                    featuresC.add(c.get(TreeCoreAnnotations.HeadWordAnnotation.class) + "-" + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + "-HW-DISTSIM");
                }
            }
            if (this.flags.useNPGovernor) {
                featuresC.add((String)c.get(CoreAnnotations.GovernorAnnotation.class) + "-GW");
                if (this.flags.useTags) {
                    featuresC.add((String)c.get(CoreAnnotations.GovernorAnnotation.class) + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-GW-T");
                }
                if (this.flags.useDistSim) {
                    featuresC.add((String)c.get(CoreAnnotations.GovernorAnnotation.class) + '-' + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + "-DISTSIM-T1");
                }
            }
            if (this.flags.useHeadGov) {
                featuresC.add(c.get(TreeCoreAnnotations.HeadWordAnnotation.class) + "-" + (String)c.get(CoreAnnotations.GovernorAnnotation.class) + "-HW_GW");
            }
            if (this.flags.useClassFeature) {
                featuresC.add("###");
            }
            if (this.flags.useFirstWord) {
                String firstWord = this.getWord((CoreLabel)cInfo.get(0));
                featuresC.add(firstWord);
            }
            if (this.flags.useNGrams) {
                Collection<String> subs = null;
                if (this.flags.cacheNGrams) {
                    subs = this.wordToSubstrings.get(cWord);
                }
                if (subs == null) {
                    subs = new ArrayList<String>();
                    String word = '<' + cWord + '>';
                    if (this.flags.lowercaseNGrams) {
                        word = word.toLowerCase();
                    }
                    if (this.flags.dehyphenateNGrams) {
                        word = NERFeatureFactory.dehyphenate(word);
                    }
                    if (this.flags.greekifyNGrams) {
                        word = NERFeatureFactory.greekify(word);
                    }
                    if (this.flags.noMidNGrams) {
                        int max = this.flags.maxNGramLeng >= 0 ? Math.min(this.flags.maxNGramLeng, word.length()) : word.length();
                        for (int j2 = 2; j2 <= max; ++j2) {
                            subs.add(this.intern('#' + word.substring(0, j2) + '#'));
                        }
                        int start = this.flags.maxNGramLeng >= 0 ? Math.max(0, word.length() - this.flags.maxNGramLeng) : 0;
                        int lenM1 = word.length() - 1;
                        for (int i = start; i < lenM1; ++i) {
                            subs.add(this.intern('#' + word.substring(i) + '#'));
                        }
                    } else {
                        for (int i = 0; i < word.length(); ++i) {
                            int max = Math.min(word.length(), i + this.flags.maxNGramLeng);
                            for (int j2 = i + 2; j2 <= max; ++j2) {
                                if (this.flags.maxNGramLeng >= 0 && j2 - i > this.flags.maxNGramLeng) continue;
                                subs.add(this.intern('#' + word.substring(i, j2) + '#'));
                            }
                        }
                    }
                    if (this.flags.cacheNGrams) {
                        this.wordToSubstrings.put(cWord, subs);
                    }
                }
                featuresC.addAll(subs);
                if (this.flags.conjoinShapeNGrams) {
                    for (String str : subs) {
                        String feat = str + '-' + cShape + "-CNGram-CS";
                        featuresC.add(feat);
                    }
                }
            }
            if (this.flags.useGazettes) {
                Collection<GazetteInfo> infos;
                Collection<String> entries;
                if (this.flags.sloppyGazette && (entries = this.wordToGazetteEntries.get(cWord)) != null) {
                    featuresC.addAll(entries);
                }
                if (this.flags.cleanGazette && (infos = this.wordToGazetteInfos.get(cWord)) != null) {
                    for (GazetteInfo gInfo : infos) {
                        boolean ok = true;
                        for (int gLoc = 0; gLoc < gInfo.words.length; ++gLoc) {
                            ok &= gInfo.words[gLoc].equals(this.getWord((CoreLabel)cInfo.get(loc + gLoc - gInfo.loc)));
                        }
                        if (!ok) continue;
                        featuresC.add(gInfo.feature);
                    }
                }
            }
            if (this.flags.wordShape > -1 || this.flags.useShapeStrings) {
                featuresC.add(cShape + "-TYPE");
                if (this.flags.useTypeSeqs) {
                    featuresC.add(pShape + "-PTYPE");
                    featuresC.add(nShape + "-NTYPE");
                    featuresC.add(pWord + "..." + cShape + "-PW_CTYPE");
                    featuresC.add(cShape + "..." + nWord + "-NW_CTYPE");
                    featuresC.add(pShape + "..." + cShape + "-PCTYPE");
                    featuresC.add(cShape + "..." + nShape + "-CNTYPE");
                    featuresC.add(pShape + "..." + cShape + "..." + nShape + "-PCNTYPE");
                }
            }
            if (this.flags.useLastRealWord && pWord.length() <= 3) {
                featuresC.add(this.getWord(p2) + "..." + cShape + "-PPW_CTYPE");
            }
            if (this.flags.useNextRealWord && nWord.length() <= 3) {
                featuresC.add(this.getWord(n2) + "..." + cShape + "-NNW_CTYPE");
            }
            if (this.flags.useOccurrencePatterns) {
                featuresC.addAll(this.occurrencePatterns(cInfo, loc));
            }
            if (this.flags.useDisjunctive) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    CoreLabel dn = (CoreLabel)cInfo.get(loc + i);
                    CoreLabel dp = (CoreLabel)cInfo.get(loc - i);
                    featuresC.add(this.getWord(dn) + "-DISJN");
                    if (this.flags.useDisjunctiveShapeInteraction) {
                        featuresC.add(this.getWord(dn) + '-' + cShape + "-DISJN-CS");
                    }
                    featuresC.add(this.getWord(dp) + "-DISJP");
                    if (!this.flags.useDisjunctiveShapeInteraction) continue;
                    featuresC.add(this.getWord(dp) + '-' + cShape + "-DISJP-CS");
                }
            }
            if (this.flags.useWideDisjunctive) {
                for (int i = 1; i <= this.flags.wideDisjunctionWidth; ++i) {
                    featuresC.add(this.getWord((CoreLabel)cInfo.get(loc + i)) + "-DISJWN");
                    featuresC.add(this.getWord((CoreLabel)cInfo.get(loc - i)) + "-DISJWP");
                }
            }
            if (this.flags.useEitherSideDisjunctive) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    featuresC.add(this.getWord((CoreLabel)cInfo.get(loc + i)) + "-DISJWE");
                    featuresC.add(this.getWord((CoreLabel)cInfo.get(loc - i)) + "-DISJWE");
                }
            }
            if (this.flags.useDisjShape) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    featuresC.add((String)((CoreLabel)cInfo.get(loc + i)).get(CoreAnnotations.ShapeAnnotation.class) + "-NDISJSHAPE");
                    featuresC.add(cShape + '-' + (String)((CoreLabel)cInfo.get(loc + i)).get(CoreAnnotations.ShapeAnnotation.class) + "-CNDISJSHAPE");
                }
            }
            if (this.flags.useExtraTaggySequences) {
                if (this.flags.useTags) {
                    featuresC.add(p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TTS");
                    featuresC.add(p3.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TTTS");
                }
                if (this.flags.useDistSim) {
                    featuresC.add((String)p2.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)p.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + "-DISTSIM_TTS1");
                    featuresC.add((String)p3.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)p2.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)p.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + "-DISTSIM_TTTS1");
                }
            }
            if (this.flags.useMUCFeatures) {
                featuresC.add((String)c.get(CoreAnnotations.SectionAnnotation.class) + "-SECTION");
                featuresC.add((String)c.get(CoreAnnotations.WordPositionAnnotation.class) + "-WORD_POSITION");
                featuresC.add((String)c.get(CoreAnnotations.SentencePositionAnnotation.class) + "-SENT_POSITION");
                featuresC.add((String)c.get(CoreAnnotations.ParaPositionAnnotation.class) + "-PARA_POSITION");
                featuresC.add((String)c.get(CoreAnnotations.WordPositionAnnotation.class) + '-' + (String)c.get(CoreAnnotations.ShapeAnnotation.class) + "-WORD_POSITION_SHAPE");
            }
        } else if (this.flags.useInternal) {
            if (this.flags.useWord) {
                featuresC.add(cWord + "-WORD");
            }
            if (this.flags.useNGrams) {
                Collection<String> subs = this.wordToSubstrings.get(cWord);
                if (subs == null) {
                    void var17_52;
                    subs = new ArrayList<String>();
                    String string = '<' + cWord + '>';
                    if (this.flags.lowercaseNGrams) {
                        String string9 = string.toLowerCase();
                    }
                    if (this.flags.dehyphenateNGrams) {
                        void var17_48;
                        String string10 = NERFeatureFactory.dehyphenate((String)var17_48);
                    }
                    if (this.flags.greekifyNGrams) {
                        void var17_50;
                        String string11 = NERFeatureFactory.greekify((String)var17_50);
                    }
                    for (int i = 0; i < var17_52.length(); ++i) {
                        for (int j = i + 2; j <= var17_52.length(); ++j) {
                            if (this.flags.noMidNGrams && i != 0 && j != var17_52.length() || this.flags.maxNGramLeng >= 0 && j - i > this.flags.maxNGramLeng) continue;
                            subs.add(this.intern('#' + var17_52.substring(i, j) + '#'));
                        }
                    }
                    if (this.flags.cacheNGrams) {
                        this.wordToSubstrings.put(cWord, subs);
                    }
                }
                featuresC.addAll(subs);
                if (this.flags.conjoinShapeNGrams) {
                    String string = (String)c.get(CoreAnnotations.ShapeAnnotation.class);
                    for (String str : subs) {
                        String feat = str + '-' + string + "-CNGram-CS";
                        featuresC.add(feat);
                    }
                }
            }
            if (this.flags.wordShape > -1 || this.flags.useShapeStrings) {
                featuresC.add(cShape + "-TYPE");
            }
            if (this.flags.useOccurrencePatterns) {
                featuresC.addAll(this.occurrencePatterns(cInfo, loc));
            }
        } else if (this.flags.useExternal) {
            if (this.flags.usePrev) {
                featuresC.add(pWord + "-PW");
            }
            if (this.flags.useNext) {
                featuresC.add(nWord + "-NW");
            }
            if (this.flags.useWordPairs) {
                featuresC.add(cWord + '-' + pWord + "-W-PW");
                featuresC.add(cWord + '-' + nWord + "-W-NW");
            }
            if (this.flags.useSymWordPairs) {
                featuresC.add(pWord + '-' + nWord + "-SWORDS");
            }
            if ((this.flags.wordShape > -1 || this.flags.useShapeStrings) && this.flags.useTypeSeqs) {
                featuresC.add(pShape + "-PTYPE");
                featuresC.add(nShape + "-NTYPE");
                featuresC.add(pWord + "..." + cShape + "-PW_CTYPE");
                featuresC.add(cShape + "..." + nWord + "-NW_CTYPE");
                if (this.flags.maxLeft > 0) {
                    featuresC.add(pShape + "..." + cShape + "-PCTYPE");
                }
                featuresC.add(cShape + "..." + nShape + "-CNTYPE");
                featuresC.add(pShape + "..." + cShape + "..." + nShape + "-PCNTYPE");
            }
            if (this.flags.useLastRealWord && pWord.length() <= 3) {
                featuresC.add(this.getWord(p2) + "..." + cShape + "-PPW_CTYPE");
            }
            if (this.flags.useNextRealWord && nWord.length() <= 3) {
                featuresC.add(this.getWord(n2) + "..." + cShape + "-NNW_CTYPE");
            }
            if (this.flags.useDisjunctive) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    CoreLabel coreLabel = (CoreLabel)cInfo.get(loc + i);
                    CoreLabel dp = (CoreLabel)cInfo.get(loc - i);
                    featuresC.add(this.getWord(coreLabel) + "-DISJN");
                    if (this.flags.useDisjunctiveShapeInteraction) {
                        featuresC.add(this.getWord(coreLabel) + '-' + cShape + "-DISJN-CS");
                    }
                    featuresC.add(this.getWord(dp) + "-DISJP");
                    if (!this.flags.useDisjunctiveShapeInteraction) continue;
                    featuresC.add(this.getWord(dp) + '-' + cShape + "-DISJP-CS");
                }
            }
            if (this.flags.useWideDisjunctive) {
                for (int i = 1; i <= this.flags.wideDisjunctionWidth; ++i) {
                    featuresC.add(this.getWord((CoreLabel)cInfo.get(loc + i)) + "-DISJWN");
                    featuresC.add(this.getWord((CoreLabel)cInfo.get(loc - i)) + "-DISJWP");
                }
            }
            if (this.flags.useDisjShape) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    featuresC.add((String)((CoreLabel)cInfo.get(loc + i)).get(CoreAnnotations.ShapeAnnotation.class) + "-NDISJSHAPE");
                    featuresC.add((String)c.get(CoreAnnotations.ShapeAnnotation.class) + '-' + (String)((CoreLabel)cInfo.get(loc + i)).get(CoreAnnotations.ShapeAnnotation.class) + "-CNDISJSHAPE");
                }
            }
        }
        if (this.flags.twoStage) {
            featuresC.add((String)c.get(Bin1Annotation.class) + "-BIN1");
            featuresC.add((String)c.get(Bin2Annotation.class) + "-BIN2");
            featuresC.add((String)c.get(Bin3Annotation.class) + "-BIN3");
            featuresC.add((String)c.get(Bin4Annotation.class) + "-BIN4");
            featuresC.add((String)c.get(Bin5Annotation.class) + "-BIN5");
            featuresC.add((String)c.get(Bin6Annotation.class) + "-BIN6");
        }
        if (this.flags.useIfInteger) {
            try {
                int val = Integer.parseInt(cWord);
                if (val > 0) {
                    featuresC.add("POSITIVE_INTEGER");
                } else if (val < 0) {
                    featuresC.add("NEGATIVE_INTEGER");
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this.flags.useGenericFeatures) {
            if (this.genericAnnotationKeys == null) {
                this.makeGenericKeyCache(c);
            }
            for (Class<? extends CoreLabel.GenericAnnotation<?>> clazz : this.genericAnnotationKeys) {
                if (c.get(clazz) != null && c.get(clazz) instanceof Collection) {
                    for (Object ob : (Collection)c.get(clazz)) {
                        featuresC.add(ob + "-" + CoreLabel.genericValues.get(clazz));
                    }
                    continue;
                }
                featuresC.add(c.get(clazz) + "-" + CoreLabel.genericValues.get(clazz));
            }
        }
        if (this.flags.useTopics) {
            featuresC.add((String)c.get(CoreAnnotations.TopicAnnotation.class) + "-TopicID");
            featuresC.add((String)p.get(CoreAnnotations.TopicAnnotation.class) + "-PTopicID");
            featuresC.add((String)n.get(CoreAnnotations.TopicAnnotation.class) + "-NTopicID");
        }
        if (c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) != null) {
            featuresC.add((String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + "-CStackedNERTag");
            featuresC.add(cWord + "-" + (String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + "-WCStackedNERTag");
            if (this.flags.useNext) {
                featuresC.add((String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + '-' + (String)n.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + "-CNStackedNERTag");
                featuresC.add(cWord + "-" + (String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + '-' + (String)n.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + "-WCNStackedNERTag");
                if (this.flags.usePrev) {
                    featuresC.add((String)p.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + '-' + (String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + '-' + (String)n.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + "-PCNStackedNERTag");
                    featuresC.add((String)p.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + '-' + cWord + " -" + (String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + '-' + (String)n.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + "-PWCNStackedNERTag");
                }
            }
            if (this.flags.usePrev) {
                featuresC.add((String)p.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + '-' + (String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) + "-PCStackedNERTag");
            }
        }
        if (this.flags.useWordnetFeatures) {
            featuresC.add((String)c.get(CoreAnnotations.WordnetSynAnnotation.class) + "-WordnetSyn");
        }
        if (this.flags.useProtoFeatures) {
            featuresC.add((String)c.get(CoreAnnotations.ProtoAnnotation.class) + "-Proto");
        }
        if (this.flags.usePhraseWordTags) {
            featuresC.add((String)c.get(CoreAnnotations.PhraseWordsTagAnnotation.class) + "-PhraseTag");
        }
        if (this.flags.usePhraseWords) {
            for (String string : (List)c.get(CoreAnnotations.PhraseWordsAnnotation.class)) {
                featuresC.add(string + "-PhraseWord");
            }
        }
        if (this.flags.useCommonWordsFeature) {
            featuresC.add((String)c.get(CoreAnnotations.CommonWordsAnnotation.class));
        }
        if (this.flags.useRadical && cWord.length() > 0) {
            if (cWord.length() == 1) {
                featuresC.add(RadicalMap.getRadical(cWord.charAt(0)) + "-SINGLE-CHAR-RADICAL");
            } else {
                featuresC.add(RadicalMap.getRadical(cWord.charAt(0)) + "-START-RADICAL");
                featuresC.add(RadicalMap.getRadical(cWord.charAt(cWord.length() - 1)) + "-END-RADICAL");
            }
            for (int i = 0; i < cWord.length(); ++i) {
                featuresC.add(RadicalMap.getRadical(cWord.charAt(i)) + "-RADICAL");
            }
        }
        if (this.flags.splitWordRegex != null && !this.flags.splitWordRegex.isEmpty()) {
            String[] ws;
            for (String s : ws = c.word().split(this.flags.splitWordRegex)) {
                featuresC.add(s + "-SPLITWORD");
            }
        }
        return featuresC;
    }

    protected Collection<String> featuresCpC(PaddedList<IN> cInfo, int loc) {
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel n = (CoreLabel)cInfo.get(loc + 1);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String cDS = c.getString(CoreAnnotations.DistSimAnnotation.class);
        String pDS = p.getString(CoreAnnotations.DistSimAnnotation.class);
        String cShape = c.getString(CoreAnnotations.ShapeAnnotation.class);
        String pShape = p.getString(CoreAnnotations.ShapeAnnotation.class);
        ArrayList<String> featuresCpC = new ArrayList<String>();
        if (this.flags.noEdgeFeature) {
            return featuresCpC;
        }
        if (this.flags.transitionEdgeOnly) {
            featuresCpC.add("PSEQ");
            return featuresCpC;
        }
        if (this.flags.useNeighborNGrams) {
            int pos;
            int len;
            int maxLen = pWord.length();
            if (this.flags.maxNGramLeng >= 0 && this.flags.maxNGramLeng < maxLen) {
                maxLen = this.flags.maxNGramLeng;
            }
            for (len = 1; len <= maxLen; ++len) {
                featuresCpC.add(pWord.substring(0, len) + "-PREVIOUS-PREFIX");
            }
            for (pos = pWord.length() - maxLen; pos < pWord.length(); ++pos) {
                featuresCpC.add(pWord.substring(pos, pWord.length()) + "-PREVIOUS-SUFFIX");
            }
            maxLen = cWord.length();
            if (this.flags.maxNGramLeng >= 0 && this.flags.maxNGramLeng < maxLen) {
                maxLen = this.flags.maxNGramLeng;
            }
            for (len = 1; len <= maxLen; ++len) {
                featuresCpC.add(cWord.substring(0, len) + "-CURRENT-PREFIX");
            }
            for (pos = cWord.length() - maxLen; pos < cWord.length(); ++pos) {
                featuresCpC.add(cWord.substring(pos, cWord.length()) + "-CURRENT-SUFFIX");
            }
        }
        if (this.flags.useInternal && this.flags.useExternal) {
            if (this.flags.useOrdinal) {
                if (this.isOrdinal(cInfo, loc)) {
                    featuresCpC.add("C_ORDINAL");
                    if (this.isOrdinal(cInfo, loc - 1)) {
                        featuresCpC.add("PC_ORDINAL");
                    }
                }
                if (this.isOrdinal(cInfo, loc - 1)) {
                    featuresCpC.add("P_ORDINAL");
                }
            }
            if (this.flags.useAbbr || this.flags.useMinimalAbbr) {
                featuresCpC.add((String)p.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-PABBRANS");
            }
            if ((this.flags.useAbbr1 || this.flags.useMinimalAbbr1) && !((String)c.get(CoreAnnotations.AbbrAnnotation.class)).equals("XX")) {
                featuresCpC.add((String)p.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-PABBRANS");
            }
            if (this.flags.useChunkySequences) {
                featuresCpC.add((String)p.get(CoreAnnotations.ChunkAnnotation.class) + '-' + (String)c.get(CoreAnnotations.ChunkAnnotation.class) + '-' + (String)n.get(CoreAnnotations.ChunkAnnotation.class) + "-PCNCHUNK");
            }
            if (this.flags.usePrev && this.flags.useSequences && this.flags.usePrevSequences) {
                featuresCpC.add("PSEQ");
                featuresCpC.add(cWord + "-PSEQW");
                featuresCpC.add(pWord + '-' + cWord + "-PSEQW2");
                featuresCpC.add(pWord + "-PSEQpW");
                featuresCpC.add(pDS + "-PSEQpDS");
                featuresCpC.add(cDS + "-PSEQcDS");
                featuresCpC.add(pDS + '-' + cDS + "-PSEQpcDS");
                if (this.flags.wordShape > -1 || this.flags.useShapeStrings) {
                    featuresCpC.add(pShape + "-PSEQpS");
                    featuresCpC.add(cShape + "-PSEQcS");
                    featuresCpC.add(pShape + '-' + cShape + "-PSEQpcS");
                }
            }
            if ((this.flags.wordShape > -1 || this.flags.useShapeStrings) && this.flags.useTypeSeqs && (this.flags.useTypeSeqs2 || this.flags.useTypeSeqs3)) {
                if (this.flags.useTypeSeqs3) {
                    featuresCpC.add(pShape + '-' + cShape + '-' + (String)n.get(CoreAnnotations.ShapeAnnotation.class) + "-PCNSHAPES");
                }
                if (this.flags.useTypeSeqs2) {
                    featuresCpC.add(pShape + '-' + cShape + "-TYPES");
                }
                if (this.flags.useYetMoreCpCShapes) {
                    String p2Shape = ((CoreLabel)cInfo.get(loc - 2)).getString(CoreAnnotations.ShapeAnnotation.class);
                    featuresCpC.add(p2Shape + '-' + pShape + '-' + cShape + "-YMS");
                    featuresCpC.add(pShape + '-' + cShape + "-" + n.getString(CoreAnnotations.ShapeAnnotation.class) + "-YMSPCN");
                }
            }
            if (this.flags.useTypeySequences) {
                featuresCpC.add(cShape + "-TPS2");
                featuresCpC.add((String)n.get(CoreAnnotations.ShapeAnnotation.class) + "-TNS1");
            }
            if (this.flags.useTaggySequences) {
                if (this.flags.useTags) {
                    featuresCpC.add(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TS");
                }
                if (this.flags.useDistSim) {
                    featuresCpC.add((String)p.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + "-DISTSIM_TS1");
                }
            }
            if (this.flags.useParenMatching) {
                if (this.flags.useReverse) {
                    if ((cWord.equals("(") || cWord.equals("[") || cWord.equals("-LRB-")) && (pWord.equals(")") || pWord.equals("]") || pWord.equals("-RRB-"))) {
                        featuresCpC.add("PAREN-MATCH");
                    }
                } else if ((cWord.equals(")") || cWord.equals("]") || cWord.equals("-RRB-")) && (pWord.equals("(") || pWord.equals("[") || pWord.equals("-LRB-"))) {
                    featuresCpC.add("PAREN-MATCH");
                }
            }
            if (this.flags.useEntityTypeSequences) {
                featuresCpC.add((String)p.get(CoreAnnotations.EntityTypeAnnotation.class) + '-' + (String)c.get(CoreAnnotations.EntityTypeAnnotation.class) + "-ETSEQ");
            }
            if (this.flags.useURLSequences) {
                featuresCpC.add((String)p.get(CoreAnnotations.IsURLAnnotation.class) + '-' + (String)c.get(CoreAnnotations.IsURLAnnotation.class) + "-URLSEQ");
            }
        } else if (this.flags.useInternal) {
            if (this.flags.useSequences && this.flags.usePrevSequences) {
                featuresCpC.add("PSEQ");
                featuresCpC.add(cWord + "-PSEQW");
            }
            if (this.flags.useTypeySequences) {
                featuresCpC.add(cShape + "-TPS2");
            }
        } else if (this.flags.useExternal) {
            if ((this.flags.wordShape > -1 || this.flags.useShapeStrings) && this.flags.useTypeSeqs && (this.flags.useTypeSeqs2 || this.flags.useTypeSeqs3)) {
                if (this.flags.useTypeSeqs3) {
                    featuresCpC.add(pShape + '-' + cShape + '-' + (String)n.get(CoreAnnotations.ShapeAnnotation.class) + "-PCNSHAPES");
                }
                if (this.flags.useTypeSeqs2) {
                    featuresCpC.add(pShape + '-' + cShape + "-TYPES");
                }
            }
            if (this.flags.useTypeySequences) {
                featuresCpC.add((String)n.get(CoreAnnotations.ShapeAnnotation.class) + "-TNS1");
                featuresCpC.add(pShape + '-' + (String)c.get(CoreAnnotations.ShapeAnnotation.class) + "-TPS");
            }
        }
        return featuresCpC;
    }

    protected Collection<String> featuresCp2C(PaddedList<IN> cInfo, int loc) {
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String p2Word = this.getWord(p2);
        ArrayList<String> featuresCp2C = new ArrayList<String>();
        if (this.flags.useMoreAbbr) {
            featuresCp2C.add((String)p2.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-P2ABBRANS");
        }
        if (this.flags.useMinimalAbbr) {
            featuresCp2C.add((String)p2.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-P2AP2CABB");
        }
        if (this.flags.useMinimalAbbr1 && !((String)c.get(CoreAnnotations.AbbrAnnotation.class)).equals("XX")) {
            featuresCp2C.add((String)p2.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-P2AP2CABB");
        }
        if (this.flags.useParenMatching) {
            if (this.flags.useReverse) {
                if ((cWord.equals("(") || cWord.equals("[") || cWord.equals("-LRB-")) && (p2Word.equals(")") || p2Word.equals("]") || p2Word.equals("-RRB-")) && !pWord.equals(")") && !pWord.equals("]") && !pWord.equals("-RRB-")) {
                    featuresCp2C.add("PAREN-MATCH");
                }
            } else if ((cWord.equals(")") || cWord.equals("]") || cWord.equals("-RRB-")) && (p2Word.equals("(") || p2Word.equals("[") || p2Word.equals("-LRB-")) && !pWord.equals("(") && !pWord.equals("[") && !pWord.equals("-LRB-")) {
                featuresCp2C.add("PAREN-MATCH");
            }
        }
        return featuresCp2C;
    }

    protected Collection<String> featuresCp3C(PaddedList<IN> cInfo, int loc) {
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String p2Word = this.getWord(p2);
        String p3Word = this.getWord(p3);
        ArrayList<String> featuresCp3C = new ArrayList<String>();
        if (this.flags.useParenMatching) {
            if (this.flags.useReverse) {
                if (!(!cWord.equals("(") && !cWord.equals("[") || this.flags.maxLeft < 3 || !p3Word.equals(")") && !p3Word.equals("]") || p2Word.equals(")") || p2Word.equals("]") || pWord.equals(")") || pWord.equals("]"))) {
                    featuresCp3C.add("PAREN-MATCH");
                }
            } else if (!(!cWord.equals(")") && !cWord.equals("]") || this.flags.maxLeft < 3 || !p3Word.equals("(") && !p3Word.equals("[") || p2Word.equals("(") || p2Word.equals("[") || pWord.equals("(") || pWord.equals("["))) {
                featuresCp3C.add("PAREN-MATCH");
            }
        }
        return featuresCp3C;
    }

    protected Collection<String> featuresCp4C(PaddedList<IN> cInfo, int loc) {
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        CoreLabel p4 = (CoreLabel)cInfo.get(loc - 4);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String p2Word = this.getWord(p2);
        String p3Word = this.getWord(p3);
        String p4Word = this.getWord(p4);
        ArrayList<String> featuresCp4C = new ArrayList<String>();
        if (this.flags.useParenMatching) {
            if (this.flags.useReverse) {
                if (!(!cWord.equals("(") && !cWord.equals("[") || this.flags.maxLeft < 4 || !p4Word.equals(")") && !p4Word.equals("]") || p3Word.equals(")") || p3Word.equals("]") || p2Word.equals(")") || p2Word.equals("]") || pWord.equals(")") || pWord.equals("]"))) {
                    featuresCp4C.add("PAREN-MATCH");
                }
            } else if (!(!cWord.equals(")") && !cWord.equals("]") || this.flags.maxLeft < 4 || !p4Word.equals("(") && !p4Word.equals("[") || p3Word.equals("(") || p3Word.equals("[") || p2Word.equals("(") || p2Word.equals("[") || pWord.equals("(") || pWord.equals("["))) {
                featuresCp4C.add("PAREN-MATCH");
            }
        }
        return featuresCp4C;
    }

    protected Collection<String> featuresCp5C(PaddedList<IN> cInfo, int loc) {
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        CoreLabel p4 = (CoreLabel)cInfo.get(loc - 4);
        CoreLabel p5 = (CoreLabel)cInfo.get(loc - 5);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String p2Word = this.getWord(p2);
        String p3Word = this.getWord(p3);
        String p4Word = this.getWord(p4);
        String p5Word = this.getWord(p5);
        ArrayList<String> featuresCp5C = new ArrayList<String>();
        if (this.flags.useParenMatching) {
            if (this.flags.useReverse) {
                if (!(!cWord.equals("(") && !cWord.equals("[") || this.flags.maxLeft < 5 || !p5Word.equals(")") && !p5Word.equals("]") || p4Word.equals(")") || p4Word.equals("]") || p3Word.equals(")") || p3Word.equals("]") || p2Word.equals(")") || p2Word.equals("]") || pWord.equals(")") || pWord.equals("]"))) {
                    featuresCp5C.add("PAREN-MATCH");
                }
            } else if (!(!cWord.equals(")") && !cWord.equals("]") || this.flags.maxLeft < 5 || !p5Word.equals("(") && !p5Word.equals("[") || p4Word.equals("(") || p4Word.equals("[") || p3Word.equals("(") || p3Word.equals("[") || p2Word.equals("(") || p2Word.equals("[") || pWord.equals("(") || pWord.equals("["))) {
                featuresCp5C.add("PAREN-MATCH");
            }
        }
        return featuresCp5C;
    }

    protected Collection<String> featuresCpCp2C(PaddedList<IN> cInfo, int loc) {
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        String pWord = this.getWord(p);
        ArrayList<String> featuresCpCp2C = new ArrayList<String>();
        if (this.flags.useInternal && this.flags.useExternal) {
            if (this.flags.useAbbr) {
                featuresCpCp2C.add((String)p2.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)p.get(CoreAnnotations.AbbrAnnotation.class) + '-' + (String)c.get(CoreAnnotations.AbbrAnnotation.class) + "-2PABBRANS");
            }
            if (this.flags.useChunks) {
                featuresCpCp2C.add((String)p2.get(CoreAnnotations.ChunkAnnotation.class) + '-' + (String)p.get(CoreAnnotations.ChunkAnnotation.class) + '-' + (String)c.get(CoreAnnotations.ChunkAnnotation.class) + "-2PCHUNKS");
            }
            if (this.flags.useLongSequences) {
                featuresCpCp2C.add("PPSEQ");
            }
            if (this.flags.useBoundarySequences && pWord.equals("*BOUNDARY*")) {
                featuresCpCp2C.add("BNDRY-SPAN-PPSEQ");
            }
            if (this.flags.useTaggySequences) {
                if (this.flags.useTags) {
                    featuresCpCp2C.add(p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TTS");
                    if (this.flags.useTaggySequencesShapeInteraction) {
                        featuresCpCp2C.add(p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + (String)c.get(CoreAnnotations.ShapeAnnotation.class) + "-TTS-CS");
                    }
                }
                if (this.flags.useDistSim) {
                    featuresCpCp2C.add((String)p2.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)p.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + "-DISTSIM_TTS1");
                    if (this.flags.useTaggySequencesShapeInteraction) {
                        featuresCpCp2C.add((String)p2.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)p.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.ShapeAnnotation.class) + "-DISTSIM_TTS1-CS");
                    }
                }
            }
            if ((this.flags.wordShape > -1 || this.flags.useShapeStrings) && this.flags.useTypeSeqs && this.flags.useTypeSeqs2 && this.flags.maxLeft >= 2) {
                String cShape = (String)c.get(CoreAnnotations.ShapeAnnotation.class);
                String pShape = (String)p.get(CoreAnnotations.ShapeAnnotation.class);
                String p2Shape = (String)p2.get(CoreAnnotations.ShapeAnnotation.class);
                featuresCpCp2C.add(p2Shape + '-' + pShape + '-' + cShape + "-TYPETYPES");
            }
        } else if (this.flags.useInternal) {
            if (this.flags.useLongSequences) {
                featuresCpCp2C.add("PPSEQ");
            }
        } else if (this.flags.useExternal) {
            if (this.flags.useLongSequences) {
                featuresCpCp2C.add("PPSEQ");
            }
            if ((this.flags.wordShape > -1 || this.flags.useShapeStrings) && this.flags.useTypeSeqs && this.flags.useTypeSeqs2 && this.flags.maxLeft >= 2) {
                String cShape = (String)c.get(CoreAnnotations.ShapeAnnotation.class);
                String pShape = (String)p.get(CoreAnnotations.ShapeAnnotation.class);
                String p2Shape = (String)p2.get(CoreAnnotations.ShapeAnnotation.class);
                featuresCpCp2C.add(p2Shape + '-' + pShape + '-' + cShape + "-TYPETYPES");
            }
        }
        return featuresCpCp2C;
    }

    protected Collection<String> featuresCpCp2Cp3C(PaddedList<IN> cInfo, int loc) {
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        ArrayList<String> featuresCpCp2Cp3C = new ArrayList<String>();
        if (this.flags.useTaggySequences) {
            if (this.flags.useTags && this.flags.maxLeft >= 3 && !this.flags.dontExtendTaggy) {
                featuresCpCp2Cp3C.add(p3.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + "-TTTS");
                if (this.flags.useTaggySequencesShapeInteraction) {
                    featuresCpCp2Cp3C.add(p3.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + p.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + c.getString(CoreAnnotations.PartOfSpeechAnnotation.class) + '-' + (String)c.get(CoreAnnotations.ShapeAnnotation.class) + "-TTTS-CS");
                }
            }
            if (this.flags.useDistSim && this.flags.maxLeft >= 3 && !this.flags.dontExtendTaggy) {
                featuresCpCp2Cp3C.add((String)p3.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)p2.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)p.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + "-DISTSIM_TTTS1");
                if (this.flags.useTaggySequencesShapeInteraction) {
                    featuresCpCp2Cp3C.add((String)p3.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)p2.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)p.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.DistSimAnnotation.class) + '-' + (String)c.get(CoreAnnotations.ShapeAnnotation.class) + "-DISTSIM_TTTS1-CS");
                }
            }
        }
        if (this.flags.maxLeft >= 3) {
            if (this.flags.useLongSequences) {
                featuresCpCp2Cp3C.add("PPPSEQ");
            }
            if (this.flags.useBoundarySequences && this.getWord(p).equals("*BOUNDARY*")) {
                featuresCpCp2Cp3C.add("BNDRY-SPAN-PPPSEQ");
            }
        }
        return featuresCpCp2Cp3C;
    }

    protected Collection<String> featuresCpCp2Cp3Cp4C(PaddedList<IN> cInfo, int loc) {
        ArrayList<String> featuresCpCp2Cp3Cp4C = new ArrayList<String>();
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        if (this.flags.maxLeft >= 4) {
            if (this.flags.useLongSequences) {
                featuresCpCp2Cp3Cp4C.add("PPPPSEQ");
            }
            if (this.flags.useBoundarySequences && this.getWord(p).equals("*BOUNDARY*")) {
                featuresCpCp2Cp3Cp4C.add("BNDRY-SPAN-PPPPSEQ");
            }
        }
        return featuresCpCp2Cp3Cp4C;
    }

    protected Collection<String> featuresCnC(PaddedList<IN> cInfo, int loc) {
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        ArrayList<String> featuresCnC = new ArrayList<String>();
        if (this.flags.useNext && this.flags.useSequences && this.flags.useNextSequences) {
            featuresCnC.add("NSEQ");
            featuresCnC.add(this.getWord(c) + "-NSEQW");
        }
        return featuresCnC;
    }

    protected Collection<String> featuresCpCnC(PaddedList<IN> cInfo, int loc) {
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        ArrayList<String> featuresCpCnC = new ArrayList<String>();
        if (this.flags.useNext && this.flags.usePrev && this.flags.useSequences && this.flags.usePrevSequences && this.flags.useNextSequences) {
            featuresCpCnC.add("PNSEQ");
            featuresCpCnC.add(this.getWord(c) + "-PNSEQW");
        }
        return featuresCpCnC;
    }

    int reverse(int i) {
        return this.flags.useReverse ? -1 * i : i;
    }

    private Collection<String> occurrencePatterns(PaddedList<IN> cInfo, int loc) {
        String word = this.getWord((CoreLabel)cInfo.get(loc));
        String nWord = this.getWord((CoreLabel)cInfo.get(loc + this.reverse(1)));
        CoreLabel p = (CoreLabel)cInfo.get(loc - this.reverse(1));
        String pWord = this.getWord(p);
        if (!(NERFeatureFactory.isNameCase(word) && NERFeatureFactory.noUpperCase(nWord) && NERFeatureFactory.hasLetter(nWord) && NERFeatureFactory.hasLetter(pWord) && p != cInfo.getPad())) {
            return Collections.singletonList("NO-OCCURRENCE-PATTERN");
        }
        Set<String> l = Generics.newHashSet();
        if (((CoreLabel)cInfo.get(loc - this.reverse(1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class) != null && NERFeatureFactory.isNameCase(pWord) && ((CoreLabel)cInfo.get(loc - this.reverse(1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP")) {
            int jump;
            for (jump = 3; jump < 150; ++jump) {
                if (!this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump))).equals(word)) continue;
                if (this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump - 1))).equals(pWord)) {
                    l.add("XY-NEXT-OCCURRENCE-XY");
                    continue;
                }
                l.add("XY-NEXT-OCCURRENCE-Y");
            }
            for (jump = -3; jump > -150; --jump) {
                if (!this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump))).equals(word)) continue;
                if (this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump - 1))).equals(pWord)) {
                    l.add("XY-PREV-OCCURRENCE-XY");
                    continue;
                }
                l.add("XY-PREV-OCCURRENCE-Y");
            }
        } else {
            int jump;
            for (jump = 3; jump < 150; ++jump) {
                if (!this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump))).equals(word)) continue;
                if (NERFeatureFactory.isNameCase(this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump - 1)))) && ((CoreLabel)cInfo.get(loc + this.reverse(jump - 1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP")) {
                    l.add("X-NEXT-OCCURRENCE-YX");
                    continue;
                }
                if (NERFeatureFactory.isNameCase(this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump + 1)))) && ((CoreLabel)cInfo.get(loc + this.reverse(jump + 1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP")) {
                    l.add("X-NEXT-OCCURRENCE-XY");
                    continue;
                }
                l.add("X-NEXT-OCCURRENCE-X");
            }
            for (jump = -3; jump > -150; --jump) {
                if (this.getWord((CoreLabel)cInfo.get(loc + jump)) == null || !this.getWord((CoreLabel)cInfo.get(loc + jump)).equals(word)) continue;
                if (NERFeatureFactory.isNameCase(this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump + 1)))) && ((CoreLabel)cInfo.get(loc + this.reverse(jump + 1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP")) {
                    l.add("X-PREV-OCCURRENCE-YX");
                    continue;
                }
                if (NERFeatureFactory.isNameCase(this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump - 1)))) && ((CoreLabel)cInfo.get(loc + this.reverse(jump - 1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP")) {
                    l.add("X-PREV-OCCURRENCE-XY");
                    continue;
                }
                l.add("X-PREV-OCCURRENCE-X");
            }
        }
        return l;
    }

    String intern(String s) {
        if (this.flags.intern) {
            return s.intern();
        }
        return s;
    }

    public void initGazette() {
        try {
            if (this.flags.gazettes == null) {
                this.flags.gazettes = new ArrayList<String>();
            }
            List<String> gazettes = this.flags.gazettes;
            for (String gazetteFile : gazettes) {
                BufferedReader r = IOUtils.readerFromString(gazetteFile, this.flags.inputEncoding);
                this.readGazette(r);
                r.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Bin6Annotation
    implements CoreAnnotation<String> {
        private Bin6Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class Bin5Annotation
    implements CoreAnnotation<String> {
        private Bin5Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class Bin4Annotation
    implements CoreAnnotation<String> {
        private Bin4Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class Bin3Annotation
    implements CoreAnnotation<String> {
        private Bin3Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class Bin2Annotation
    implements CoreAnnotation<String> {
        private Bin2Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class Bin1Annotation
    implements CoreAnnotation<String> {
        private Bin1Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class GazetteInfo
    implements Serializable {
        final String feature;
        final int loc;
        final String[] words;
        private static final long serialVersionUID = -5903728481621584810L;

        public GazetteInfo(String feature, int loc, String[] words) {
            this.feature = feature;
            this.loc = loc;
            this.words = words;
        }
    }
}

