/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

class RandomWalk
implements Serializable {
    private static final long serialVersionUID = -5284941866796561664L;
    private final Map<Object, Counter> model = Generics.newHashMap();
    private final Map<Object, Counter> hiddenToSeen = Generics.newHashMap();
    private final Map<Object, Counter> seenToHidden = Generics.newHashMap();
    private static final double LAMBDA = 0.01;

    public double score(Object hidden, Object seen) {
        return this.model.get(hidden).getCount(seen) / this.model.get(hidden).totalCount();
    }

    public double score(Object hidden, Object seen, int steps) {
        double total = 0.0;
        for (int i = 0; i <= steps; ++i) {
            total += Math.pow(0.01, steps) * this.step(hidden, seen, steps);
        }
        return total;
    }

    public double step(Object hidden, Object seen, int steps) {
        if (steps < 1) {
            return this.hiddenToSeen.get(hidden).getCount(seen) / this.hiddenToSeen.get(hidden).totalCount();
        }
        double total = 0.0;
        for (Object seen1 : this.seenToHidden.keySet()) {
            for (Object hidden1 : this.hiddenToSeen.keySet()) {
                double subtotal = this.hiddenToSeen.get(hidden).getCount(seen1) / this.hiddenToSeen.get(hidden).totalCount() * (this.seenToHidden.get(seen1).getCount(hidden1) / this.seenToHidden.get(seen1).totalCount());
                total += (subtotal += this.score(hidden1, seen, steps - 1));
            }
        }
        return total;
    }

    public void train(Collection<Pair<?, ?>> data) {
        for (Pair<?, ?> p : data) {
            Object seen = p.first();
            Object hidden = p.second();
            if (!this.hiddenToSeen.keySet().contains(hidden)) {
                this.hiddenToSeen.put(hidden, new ClassicCounter());
            }
            this.hiddenToSeen.get(hidden).incrementCount(seen);
            if (!this.seenToHidden.keySet().contains(seen)) {
                this.seenToHidden.put(seen, new ClassicCounter());
            }
            this.seenToHidden.get(seen).incrementCount(hidden);
        }
    }

    public RandomWalk(Collection<Pair<?, ?>> data, int steps) {
        this.train(data);
        for (Object seen : this.seenToHidden.keySet()) {
            if (!this.model.containsKey(seen)) {
                this.model.put(seen, new ClassicCounter());
            }
            for (Object hidden : this.hiddenToSeen.keySet()) {
                this.model.get(seen).setCount(hidden, this.score(seen, hidden, steps));
            }
        }
    }
}

