/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.util.Timing;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class TokenizerAnnotator
implements Annotator {
    private final boolean VERBOSE;

    public TokenizerAnnotator(boolean verbose) {
        this.VERBOSE = verbose;
    }

    public abstract Tokenizer<CoreLabel> getTokenizer(Reader var1);

    @Override
    public void annotate(Annotation annotation) {
        Timing timer = null;
        if (this.VERBOSE) {
            timer = new Timing();
            timer.start();
            System.err.print("Tokenizing ... ");
        }
        if (annotation.has(CoreAnnotations.TextAnnotation.class)) {
            String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
            StringReader r = new StringReader(text);
            List<CoreLabel> tokens = this.getTokenizer(r).tokenize();
            annotation.set(CoreAnnotations.TokensAnnotation.class, tokens);
            if (this.VERBOSE) {
                timer.stop("done.");
                System.err.println("output: " + annotation.get(CoreAnnotations.TokensAnnotation.class));
                System.err.println();
            }
        } else {
            throw new RuntimeException("unable to find text in annotation: " + annotation);
        }
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return Collections.emptySet();
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(TOKENIZE_REQUIREMENT);
    }
}

