/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.process.PTBEscapingProcessor;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ReadSentimentDataset {
    static final Function<Tree, String> TRANSFORM_TREE_TO_WORD = new Function<Tree, String>(){

        @Override
        public String apply(Tree tree) {
            return tree.label().value();
        }
    };
    static final Function<String, String> TRANSFORM_PARENS = new Function<String, String>(){

        @Override
        public String apply(String word) {
            if (word.equals("(")) {
                return "-LRB-";
            }
            if (word.equals(")")) {
                return "-RRB-";
            }
            return word;
        }
    };

    public static Tree convertTree(List<Integer> parentPointers, List<String> sentence, Map<List<String>, Integer> phraseIds, Map<Integer, Double> sentimentScores, PTBEscapingProcessor escaper) {
        int i;
        int i2;
        int maxNode = 0;
        for (Integer parent : parentPointers) {
            maxNode = Math.max(maxNode, parent);
        }
        Tree[] subtrees = new Tree[maxNode + 1];
        for (i2 = 0; i2 < sentence.size(); ++i2) {
            CoreLabel word = new CoreLabel();
            word.setValue(sentence.get(i2));
            LabeledScoredTreeNode leaf = new LabeledScoredTreeNode(word);
            subtrees[i2] = new LabeledScoredTreeNode(new CoreLabel());
            subtrees[i2].addChild(leaf);
        }
        for (i2 = sentence.size(); i2 <= maxNode; ++i2) {
            subtrees[i2] = new LabeledScoredTreeNode(new CoreLabel());
        }
        boolean[] connected = new boolean[maxNode + 1];
        Tree root = null;
        for (int index = 0; index < parentPointers.size(); ++index) {
            if (parentPointers.get(index) == -1) {
                if (root != null) {
                    throw new RuntimeException("Found two roots for sentence " + sentence);
                }
                root = subtrees[index];
                continue;
            }
            ReadSentimentDataset.connect(parentPointers, subtrees, connected, index);
        }
        for (i = 0; i <= maxNode; ++i) {
            List leaves = subtrees[i].getLeaves();
            List<String> words = CollectionUtils.transformAsList(leaves, TRANSFORM_TREE_TO_WORD);
            Integer phraseId = phraseIds.get(CollectionUtils.transformAsList(words, TRANSFORM_PARENS));
            if (phraseId == null) {
                phraseId = phraseIds.get(words);
            }
            if (phraseId == null) {
                throw new RuntimeException("Could not find phrase id for phrase " + sentence);
            }
            Double score = sentimentScores.get(phraseId);
            if (score == null) {
                throw new RuntimeException("Could not find sentiment score for phrase id " + phraseId);
            }
            int classLabel = Math.round((float)Math.floor(score * 5.0));
            if (classLabel > 4) {
                classLabel = 4;
            }
            subtrees[i].label().setValue(Integer.toString(classLabel));
        }
        for (i = 0; i < sentence.size(); ++i) {
            Tree leaf = subtrees[i].children()[0];
            leaf.label().setValue(escaper.escapeString(leaf.label().value()));
        }
        return root;
    }

    private static void connect(List<Integer> parentPointers, Tree[] subtrees, boolean[] connected, int index) {
        if (connected[index]) {
            return;
        }
        if (parentPointers.get(index) < 0) {
            return;
        }
        subtrees[parentPointers.get(index)].addChild(subtrees[index]);
        connected[index] = true;
        ReadSentimentDataset.connect(parentPointers, subtrees, connected, parentPointers.get(index));
    }

    private static void writeTrees(String filename, List<Tree> trees, List<Integer> treeIds) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedWriter bout = new BufferedWriter(new OutputStreamWriter(fos));
            for (Integer id : treeIds) {
                bout.write(trees.get(id).toString());
                bout.write("\n");
            }
            bout.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void main(String[] args) {
        Integer id;
        String dictionaryFilename = null;
        String sentimentFilename = null;
        String tokensFilename = null;
        String parseFilename = null;
        String splitFilename = null;
        String trainFilename = null;
        String devFilename = null;
        String testFilename = null;
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-dictionary")) {
                dictionaryFilename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-sentiment")) {
                sentimentFilename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tokens")) {
                tokensFilename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-parse")) {
                parseFilename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-split")) {
                splitFilename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-train")) {
                trainFilename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-dev")) {
                devFilename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-test")) {
                testFilename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            System.err.println("Unknown argument " + args[argIndex]);
            System.exit(2);
        }
        ArrayList<List<String>> sentences = Generics.newArrayList();
        for (String line : IOUtils.readLines(tokensFilename, "utf-8")) {
            String[] sentence = line.split("\\|");
            sentences.add(Arrays.asList(sentence));
        }
        Map<List<String>, Integer> phraseIds = Generics.newHashMap();
        for (String line : IOUtils.readLines(dictionaryFilename)) {
            String[] pieces = line.split("\\|");
            String[] sentence = pieces[0].split(" ");
            id = Integer.valueOf(pieces[1]);
            phraseIds.put(Arrays.asList(sentence), id);
        }
        Map<Integer, Double> sentimentScores = Generics.newHashMap();
        for (String line : IOUtils.readLines(sentimentFilename)) {
            if (line.startsWith("phrase")) continue;
            String[] pieces = line.split("\\|");
            id = Integer.valueOf(pieces[0]);
            Double score = Double.valueOf(pieces[1]);
            sentimentScores.put(id, score);
        }
        int index = 0;
        PTBEscapingProcessor escaper = new PTBEscapingProcessor();
        ArrayList<Tree> trees = Generics.newArrayList();
        for (String line : IOUtils.readLines(parseFilename)) {
            String[] pieces = line.split("\\|");
            List<Integer> parentPointers = CollectionUtils.transformAsList(Arrays.asList(pieces), new Function<String, Integer>(){

                @Override
                public Integer apply(String arg) {
                    return Integer.valueOf(arg) - 1;
                }
            });
            Tree tree = ReadSentimentDataset.convertTree(parentPointers, (List)sentences.get(index), phraseIds, sentimentScores, escaper);
            ++index;
            trees.add(tree);
        }
        Map splits = Generics.newHashMap();
        splits.put(1, Generics.newArrayList());
        splits.put(2, Generics.newArrayList());
        splits.put(3, Generics.newArrayList());
        for (String line : IOUtils.readLines(splitFilename)) {
            if (line.startsWith("sentence_index")) continue;
            String[] pieces = line.split(",");
            Integer treeId = Integer.valueOf(pieces[0]) - 1;
            Integer fileId = Integer.valueOf(pieces[1]);
            ((List)splits.get(fileId)).add(treeId);
        }
        ReadSentimentDataset.writeTrees(trainFilename, trees, (List)splits.get(1));
        ReadSentimentDataset.writeTrees(testFilename, trees, (List)splits.get(2));
        ReadSentimentDataset.writeTrees(devFilename, trees, (List)splits.get(3));
    }
}

