/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.file;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.DictionaryCatalog;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;

public class DictionaryCatalogSet {
    public Map _catalogs = new HashMap();

    public DictionaryCatalogSet() {
    }

    public DictionaryCatalogSet(String path, Class dictionaryFileType) {
        path = path.trim();
        Iterator itr = DictionaryFileType.getAllDictionaryFileTypes().iterator();
        while (itr.hasNext()) {
            DictionaryFileType dft = (DictionaryFileType)itr.next();
            DictionaryCatalog cat = new DictionaryCatalog(path, dft, dictionaryFileType);
            this._catalogs.put(cat.getKey(), cat);
        }
    }

    public void open() throws IOException {
        if (!this.isOpen()) {
            Iterator itr = this.getCatalogIterator();
            while (itr.hasNext()) {
                DictionaryCatalog dc = (DictionaryCatalog)itr.next();
                dc.open();
            }
        }
    }

    public boolean isOpen() {
        Iterator itr = this.getCatalogIterator();
        while (itr.hasNext()) {
            if (((DictionaryCatalog)itr.next()).isOpen()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        Iterator itr = this.getCatalogIterator();
        while (itr.hasNext()) {
            ((DictionaryCatalog)itr.next()).close();
        }
    }

    public DictionaryCatalog get(DictionaryFileType fileType) {
        return (DictionaryCatalog)this._catalogs.get(fileType);
    }

    public int size() {
        return this._catalogs.size();
    }

    public void put(DictionaryCatalog dc) {
        this._catalogs.put(dc.getKey(), dc);
    }

    public Iterator getCatalogIterator() {
        return this._catalogs.values().iterator();
    }

    public DictionaryFile getDictionaryFile(POS pos, DictionaryFileType fileType) {
        return this.get(fileType).get(pos);
    }
}

