/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.util.cache;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.didion.jwnl.util.cache.Cache;

public class LRUCache
extends LinkedHashMap
implements Cache {
    private int _capacity;

    public LRUCache(int capacity) {
        this(capacity, 0.75f, true);
    }

    public LRUCache(int capacity, float loadFactor, boolean ordering) {
        super(capacity, loadFactor, ordering);
        this.setCapacity(capacity);
    }

    public boolean isFull() {
        return this.size() >= this.getCapacity();
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return this.size() > this.getCapacity();
    }

    public int setCapacity(int capacity) {
        this.trimToCapacity(capacity);
        this._capacity = capacity;
        return this._capacity;
    }

    private void trimToCapacity(int capacity) {
        Iterator it = null;
        while (this.size() > capacity) {
            if (it == null) {
                it = this.keySet().iterator();
            }
            if (!it.hasNext()) continue;
            it.next();
            it.remove();
        }
    }

    public int getCapacity() {
        return this._capacity;
    }

    public int getSize() {
        return this.size();
    }
}

