/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.util.Arrays;
import rita.wordnet.RiFilter;

public final class AnagramFilter
extends RiFilter {
    private final String term;

    private AnagramFilter() {
        this.term = null;
        ignoreCase = false;
    }

    public AnagramFilter(String word, boolean bIgnoreCase) {
        ignoreCase = bIgnoreCase;
        this.term = AnagramFilter.buildData(word, ignoreCase);
    }

    public boolean accept(String word) {
        String data = AnagramFilter.buildData(word, ignoreCase);
        return this.term.equals(data);
    }

    private static String buildData(String term, boolean ignoreCase) {
        if (term == null) {
            return "";
        }
        char[] chars = ignoreCase ? term.toLowerCase().toCharArray() : term.toCharArray();
        Arrays.sort(chars);
        int size = chars.length;
        char[] data = new char[size];
        int j = 0;
        int i = 0;
        while (i < size) {
            if (chars[i] != ' ') {
                data[j++] = chars[i];
            }
            ++i;
        }
        String value = new String(data, 0, j);
        return value;
    }
}

