/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import rita.wordnet.RandomAccessIF;

public class RandomAccessByteArray
implements RandomAccessIF {
    protected MemoryCacheImageInputStream mis;
    protected String name = "unknown";
    protected long length = -1L;

    public RandomAccessByteArray(InputStream is) {
        this(null, is);
    }

    public RandomAccessByteArray(String name, InputStream is) {
        if (name != null) {
            this.name = name;
        }
        try {
            this.length = is.available();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mis = new MemoryCacheImageInputStream(is);
    }

    public RandomAccessByteArray(String name, byte[] data) {
        if (name != null) {
            this.name = name;
        }
        this.length = data.length;
        this.mis = new MemoryCacheImageInputStream(new ByteArrayInputStream(data));
    }

    public String toString() {
        return this.name;
    }

    private void determineLength(InputStream is) {
        long start = System.currentTimeMillis();
        System.err.print("length of '" + this.name + "'=");
        try {
            this.length = is.available();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long elapsed = System.currentTimeMillis() - start;
        System.err.println(String.valueOf(this.length) + " time=" + (double)elapsed / 1000.0 + "s");
    }

    public void close() throws IOException {
        this.mis.close();
    }

    public int read() throws IOException {
        return this.mis.read();
    }

    public long length() throws IOException {
        return this.length;
    }

    public void seek(long pos) throws IOException {
        this.mis.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.mis.getStreamPosition();
    }

    public String readLine() throws IOException {
        return this.mis.readLine();
    }
}

