/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

public class WordnetError
extends RuntimeException {
    private static final String STATIC = "(static)";
    private static final String CLASS = "[CLASS]";
    private static final String ERROR = "[ERROR]";
    private static final String SPC = " ";
    public static final String QQ = "";
    public static final String CR = "\n";

    public WordnetError() {
    }

    public WordnetError(String message) {
        super(WordnetError.tagMessage(null, message));
    }

    public WordnetError(Throwable cause) {
        super(cause);
    }

    public WordnetError(String message, Throwable cause) {
        super(WordnetError.tagMessage(null, message), cause);
    }

    public WordnetError(Object thrower, Throwable cause) {
        super(WordnetError.tagMessage(thrower), cause);
    }

    public WordnetError(Object thrower, String message, Throwable cause) {
        super(WordnetError.tagMessage(thrower, message), cause);
    }

    public WordnetError(Object thrower, String message) {
        super(WordnetError.tagMessage(thrower, message));
    }

    private static String tagMessage(Object thrower) {
        String msg = QQ;
        if (thrower != null) {
            msg = String.valueOf(msg) + "\n[CLASS] " + (thrower instanceof Class ? thrower + SPC + STATIC : QQ + thrower.getClass());
        }
        return msg;
    }

    private static String tagMessage(Object thrower, String msg) {
        if (msg.startsWith("[ERROR] ")) {
            msg = msg.substring(ERROR.length() + 1);
        }
        msg = "\n [ERROR] " + msg + WordnetError.tagMessage(thrower);
        return msg;
    }

    public static void main(String[] args) {
        throw new WordnetError("test error", (Throwable)new RuntimeException("root cause"));
    }
}

