/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.didion.jwnl.data.POS;

public class WordnetPos {
    public static final int QTAG = 5;
    public static final int PENN = 1;
    public static final int WORDNET = 2;
    public static final int ALL = 0;
    public static final WordnetPos UNKNOWN = new WordnetPos("???", "UNKNOWN", 0);
    public static final WordnetPos N = new WordnetPos("N", "NOUN_KEY", 2);
    public static final WordnetPos V = new WordnetPos("V", "VERB_KEY", 2);
    public static final WordnetPos R = new WordnetPos("R", "ADVERB_KEY", 2);
    public static final WordnetPos A = new WordnetPos("A", "ADJECTIVE_KEY", 2);
    private static final List WORDNET_TAGS = Collections.unmodifiableList(Arrays.asList(N, V, R, A));
    private String tag;
    private String description;
    private String examples;
    private int type;
    private static final String QQ = "";

    private WordnetPos(String tag, String description, int type) {
        this(tag, description, QQ, type);
    }

    private WordnetPos(String tag, String description, String examples, int type) {
        this.tag = tag;
        this.description = description;
        this.examples = examples;
        this.type = type;
    }

    private static boolean in(String pos, WordnetPos[] choices) {
        int i = 0;
        while (i < choices.length) {
            if (pos.equalsIgnoreCase(choices[i].toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean isVerb(String pos, WordnetPos[] verbs) {
        return WordnetPos.in(pos, verbs);
    }

    static boolean isNoun(String pos, WordnetPos[] nouns) {
        return WordnetPos.in(pos, nouns);
    }

    static boolean isAdverb(String pos, WordnetPos[] advs) {
        return WordnetPos.in(pos, advs);
    }

    static boolean isAdjective(String pos, WordnetPos[] adjs) {
        return WordnetPos.in(pos, adjs);
    }

    public static List wordNetTags() {
        return WORDNET_TAGS;
    }

    static POS getPos(String pos) {
        if (pos.equalsIgnoreCase(WordnetPos.N.tag)) {
            return POS.NOUN;
        }
        if (pos.equalsIgnoreCase(WordnetPos.V.tag)) {
            return POS.VERB;
        }
        if (pos.equalsIgnoreCase(WordnetPos.R.tag)) {
            return POS.ADVERB;
        }
        if (pos.equalsIgnoreCase(WordnetPos.A.tag)) {
            return POS.ADJECTIVE;
        }
        return null;
    }

    public static WordnetPos fromWordnet(POS pos) {
        return WordnetPos.fromWordnet(pos.getLabel());
    }

    public static WordnetPos fromWordnet(String label) {
        Iterator iter = WORDNET_TAGS.iterator();
        while (iter.hasNext()) {
            WordnetPos pos = (WordnetPos)iter.next();
            if (!pos.getTag().equalsIgnoreCase(label)) continue;
            return pos;
        }
        return null;
    }

    public static boolean isWordnet(String pos) {
        List wnps = POS.getAllPOS();
        Iterator iter = wnps.iterator();
        while (iter.hasNext()) {
            POS wnpos = (POS)iter.next();
            if (!wnpos.getKey().equalsIgnoreCase(pos)) continue;
            return true;
        }
        return false;
    }

    public static POS getWordnetPOSForLabel(String label) {
        return POS.getPOSForLabel(label);
    }

    public static POS getWordnetPOSForKey(String key) {
        return POS.getPOSForKey(key);
    }

    public static String getWordnetLabel(POS pos) {
        return pos.getLabel();
    }

    public static String getWordnetKey(POS pos) {
        return pos.getKey();
    }

    public String getDescription() {
        return this.description;
    }

    public String getExamples() {
        return this.examples;
    }

    public String getTag() {
        return this.tag;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return this.tag;
    }

    public boolean equals(Object obj) {
        WordnetPos p = (WordnetPos)obj;
        if (!this.getTag().equals(p.getTag())) {
            return false;
        }
        return this.getType() == p.getType();
    }

    public static void main(String[] args) {
        System.out.println(WordnetPos.getWordnetKey(POS.ADVERB));
    }
}

