/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Classifier;
import LBJ2.classify.Feature;
import LBJ2.classify.RealFeature;
import LBJ2.learn.ChildLexicon;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class RealConjunctiveFeature
extends RealFeature {
    protected Feature left;
    protected Feature right;

    public RealConjunctiveFeature() {
    }

    public RealConjunctiveFeature(Classifier classifier, Feature feature, Feature feature2) {
        this(classifier.containingPackage, classifier.name, feature, feature2);
    }

    public RealConjunctiveFeature(String string, String string2, Feature feature, Feature feature2) {
        super(string, string2);
        this.left = feature;
        this.right = feature2;
    }

    public boolean isConjunctive() {
        return true;
    }

    public Feature getLeft() {
        return this.left;
    }

    public Feature getRight() {
        return this.right;
    }

    public String getStringIdentifier() {
        return "";
    }

    public ByteString getByteStringIdentifier() {
        return ByteString.emptyString;
    }

    public int depth() {
        return Math.max(this.left.depth(), this.right.depth()) + 1;
    }

    public double getStrength() {
        return (this.left.isDiscrete() ? 1.0 : this.left.getStrength()) * (this.right.isDiscrete() ? 1.0 : this.right.getStrength());
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        return new RealConjunctiveFeature(this.containingPackage, this.generatingClassifier, this.getArgumentKey(this.left, lexicon, bl, n), this.getArgumentKey(this.right, lexicon, bl, n));
    }

    protected Feature getArgumentKey(Feature feature, Lexicon lexicon, boolean bl, int n) {
        if (feature.isDiscrete()) {
            if (!bl) {
                return feature;
            }
            if (!feature.isPrimitive()) {
                feature = feature.getFeatureKey(lexicon, true, n);
            }
        } else {
            feature = feature.getFeatureKey(lexicon, bl, n);
            if (!bl) {
                return feature;
            }
        }
        return lexicon.getChildFeature(feature, n);
    }

    public RealFeature multiply(double d) {
        RealConjunctiveFeature realConjunctiveFeature = (RealConjunctiveFeature)this.clone();
        if (!this.left.isDiscrete()) {
            realConjunctiveFeature.left = ((RealFeature)this.left).multiply(d);
        } else {
            realConjunctiveFeature.right = ((RealFeature)this.right).multiply(d);
        }
        return realConjunctiveFeature;
    }

    public Feature withStrength(double d) {
        RealConjunctiveFeature realConjunctiveFeature = (RealConjunctiveFeature)this.clone();
        if (!this.left.isDiscrete()) {
            realConjunctiveFeature.left = this.left.withStrength(d);
            if (!this.right.isDiscrete()) {
                realConjunctiveFeature.right = this.right.withStrength(1.0);
            }
        } else {
            realConjunctiveFeature.right = this.right.withStrength(d);
        }
        return realConjunctiveFeature;
    }

    public Feature encode(String string) {
        RealFeature realFeature = (RealFeature)this.left.encode(string);
        RealFeature realFeature2 = (RealFeature)this.right.encode(string);
        if (realFeature == this.left && realFeature2 == this.right) {
            return this;
        }
        return new RealConjunctiveFeature(this.containingPackage, this.generatingClassifier, realFeature, realFeature2);
    }

    public void removeFromChildLexicon(ChildLexicon childLexicon) {
        childLexicon.decrementParentCounts(this.left);
        childLexicon.decrementParentCounts(this.right);
    }

    public int childLexiconLookup(ChildLexicon childLexicon, int n) {
        return childLexicon.childLexiconLookup(this, n);
    }

    public int hashCode() {
        return 31 * super.hashCode() + 17 * this.left.hashCode() + this.right.hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        RealConjunctiveFeature realConjunctiveFeature = (RealConjunctiveFeature)object;
        return !(this.left != realConjunctiveFeature.left && !this.left.equals(realConjunctiveFeature.left) || this.right != realConjunctiveFeature.right && !this.right.equals(realConjunctiveFeature.right));
    }

    public int compareTo(Object object) {
        int n = this.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        RealConjunctiveFeature realConjunctiveFeature = (RealConjunctiveFeature)object;
        n = this.left.compareTo(realConjunctiveFeature.left);
        if (n != 0) {
            return n;
        }
        return this.right.compareTo(realConjunctiveFeature.right);
    }

    public void write(StringBuffer stringBuffer) {
        this.writeNameString(stringBuffer);
        stringBuffer.append('{');
        this.left.write(stringBuffer);
        stringBuffer.append(", ");
        this.right.write(stringBuffer);
        stringBuffer.append('}');
    }

    public void writeNoPackage(StringBuffer stringBuffer) {
        String string = this.containingPackage;
        this.containingPackage = null;
        this.writeNameString(stringBuffer);
        stringBuffer.append('{');
        this.left.writeNoPackage(stringBuffer);
        stringBuffer.append(", ");
        this.right.writeNoPackage(stringBuffer);
        stringBuffer.append('}');
        this.containingPackage = string;
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        this.left.write(exceptionlessOutputStream);
        this.right.write(exceptionlessOutputStream);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.left = Feature.readFeature(exceptionlessInputStream);
        this.right = Feature.readFeature(exceptionlessInputStream);
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        exceptionlessOutputStream.writeInt(lexicon.lookupChild(this.left));
        exceptionlessOutputStream.writeInt(lexicon.lookupChild(this.right));
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.left = lexicon.lookupKey(exceptionlessInputStream.readInt());
        this.right = lexicon.lookupKey(exceptionlessInputStream.readInt());
    }
}

