/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.classify.ScoreSet;
import LBJ2.infer.Inference;
import LBJ2.learn.Learner;

public class FirstOrderVariable
implements Cloneable {
    private Learner classifier;
    private Object example;
    private ScoreSet scores;
    private String value;

    public FirstOrderVariable(Learner learner, Object object) {
        this.classifier = learner;
        this.example = object;
    }

    public Learner getClassifier() {
        return this.classifier;
    }

    public Object getExample() {
        return this.example;
    }

    public String getValue() {
        if (this.value == null) {
            if (this.scores == null) {
                this.scores = this.classifier.scores(this.example);
            }
            this.value = this.scores.highScoreValue();
        }
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setExample(Object object) {
        this.example = object;
    }

    public double getScore() {
        if (this.scores == null) {
            this.scores = this.classifier.scores(this.example);
        }
        return this.scores.get(this.getValue());
    }

    public ScoreSet getScores() {
        if (this.scores == null) {
            this.scores = this.classifier.scores(this.example);
        }
        return this.scores;
    }

    public String toString() {
        return this.classifier + "(" + Inference.exampleToString(this.example) + ") = " + this.value;
    }

    public int hashCode() {
        return this.classifier.toString().hashCode() + System.identityHashCode(this.example);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirstOrderVariable)) {
            return false;
        }
        FirstOrderVariable firstOrderVariable = (FirstOrderVariable)object;
        return this.classifier.equals(firstOrderVariable.classifier) && this.example == firstOrderVariable.example;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning FirstOrderVariable:");
            exception.printStackTrace();
            System.exit(1);
        }
        return object;
    }
}

