/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.classify.Score;
import LBJ2.infer.ILPSolver;
import LBJ2.util.DVector;
import LBJ2.util.OVector;
import gurobi.GRB;
import gurobi.GRBConstr;
import gurobi.GRBEnv;
import gurobi.GRBException;
import gurobi.GRBLinExpr;
import gurobi.GRBModel;
import gurobi.GRBSOS;
import gurobi.GRBVar;
import java.util.Arrays;

public class GurobiHook
implements ILPSolver {
    protected GRBEnv environment;
    protected GRBModel model;
    protected OVector variables;
    protected OVector SOSes;
    protected boolean needsUpdate;
    protected boolean isSolved;
    protected int verbosity;
    protected DVector objectiveCoefficients;

    protected static void handleException(GRBException gRBException) {
        System.out.println("Gurobi error " + gRBException.getErrorCode() + ": " + gRBException.getMessage());
        gRBException.printStackTrace();
        System.exit(-1);
    }

    public GurobiHook() {
        this(0);
    }

    public GurobiHook(int n) {
        try {
            this.environment = new GRBEnv();
            this.environment.set(GRB.IntParam.OutputFlag, 0);
        }
        catch (GRBException gRBException) {
            GurobiHook.handleException(gRBException);
        }
        this.verbosity = n;
        this.reset();
    }

    public GurobiHook(GRBEnv gRBEnv) {
        this(gRBEnv, 0);
    }

    public GurobiHook(GRBEnv gRBEnv, int n) {
        this.environment = gRBEnv;
        this.verbosity = n;
        this.reset();
    }

    public void reset() {
        try {
            this.model = new GRBModel(this.environment);
        }
        catch (GRBException gRBException) {
            GurobiHook.handleException(gRBException);
        }
        this.variables = new OVector();
        this.SOSes = new OVector();
        this.objectiveCoefficients = new DVector();
        this.isSolved = false;
        this.needsUpdate = false;
    }

    public void setMaximize(boolean bl) {
        try {
            this.model.set(GRB.IntAttr.ModelSense, bl ? -1 : 1);
        }
        catch (GRBException gRBException) {
            GurobiHook.handleException(gRBException);
        }
    }

    public int addBooleanVariable(double d) {
        int n = this.variables.size();
        try {
            this.variables.add(this.model.addVar(0.0, 1.0, d, 'B', "x_" + n));
        }
        catch (GRBException gRBException) {
            GurobiHook.handleException(gRBException);
        }
        this.objectiveCoefficients.add(d);
        this.needsUpdate = true;
        return n;
    }

    public int[] addDiscreteVariable(double[] dArray) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = this.addBooleanVariable(dArray[i]);
        }
        double[] dArray2 = new double[dArray.length];
        Arrays.fill(dArray2, 1.0);
        this.addGreaterThanConstraint(nArray, dArray2, 1.0);
        try {
            this.SOSes.add(this.model.addSOS(this.idsToVariables(nArray), dArray2, 1));
        }
        catch (GRBException gRBException) {
            GurobiHook.handleException(gRBException);
        }
        return nArray;
    }

    public int[] addDiscreteVariable(Score[] scoreArray) {
        double[] dArray = new double[scoreArray.length];
        for (int i = 0; i < scoreArray.length; ++i) {
            dArray[i] = scoreArray[i].score;
        }
        return this.addDiscreteVariable(dArray);
    }

    protected void addConstraint(int[] nArray, double[] dArray, double d, char c) {
        if (this.needsUpdate) {
            try {
                this.model.update();
            }
            catch (GRBException gRBException) {
                GurobiHook.handleException(gRBException);
            }
            this.needsUpdate = false;
        }
        try {
            int n = this.model.get(GRB.IntAttr.NumConstrs);
            this.model.addConstr(this.makeLinearExpression(nArray, dArray), c, d, "c_" + n);
        }
        catch (GRBException gRBException) {
            GurobiHook.handleException(gRBException);
        }
    }

    public void addEqualityConstraint(int[] nArray, double[] dArray, double d) {
        this.addConstraint(nArray, dArray, d, '=');
    }

    public void addGreaterThanConstraint(int[] nArray, double[] dArray, double d) {
        this.addConstraint(nArray, dArray, d, '>');
    }

    public void addLessThanConstraint(int[] nArray, double[] dArray, double d) {
        this.addConstraint(nArray, dArray, d, '<');
    }

    public boolean solve() throws Exception {
        if (this.verbosity > 0) {
            System.out.println("  variables: " + this.model.get(GRB.IntAttr.NumVars));
            System.out.println("  constraints: " + this.model.get(GRB.IntAttr.NumConstrs));
        }
        if (this.verbosity == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            this.write(stringBuffer);
            System.out.print(stringBuffer);
        }
        this.model.optimize();
        int n = this.model.get(GRB.IntAttr.Status);
        this.isSolved = n == 2 || n == 13;
        return this.isSolved;
    }

    public boolean isSolved() {
        return this.isSolved;
    }

    public boolean getBooleanValue(int n) {
        if (!this.isSolved) {
            return false;
        }
        try {
            double d = ((GRBVar)this.variables.get(n)).get(GRB.DoubleAttr.X);
            return d > 0.5;
        }
        catch (GRBException gRBException) {
            GurobiHook.handleException(gRBException);
            return false;
        }
    }

    public double objectiveValue() {
        try {
            if (this.isSolved) {
                return this.model.get(GRB.DoubleAttr.ObjVal);
            }
            int n = this.model.get(GRB.IntAttr.Status);
            if (n == 3 || n == 4 || n == 5) {
                return this.model.get(GRB.IntAttr.ModelSense) == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        }
        catch (GRBException gRBException) {
            GurobiHook.handleException(gRBException);
        }
        return 0.0;
    }

    protected GRBVar[] idsToVariables(int[] nArray) {
        GRBVar[] gRBVarArray = new GRBVar[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            gRBVarArray[i] = (GRBVar)this.variables.get(nArray[i]);
        }
        return gRBVarArray;
    }

    protected GRBLinExpr makeLinearExpression(int[] nArray, double[] dArray) {
        try {
            GRBLinExpr gRBLinExpr = new GRBLinExpr();
            gRBLinExpr.addTerms(dArray, this.idsToVariables(nArray));
            return gRBLinExpr;
        }
        catch (GRBException gRBException) {
            GurobiHook.handleException(gRBException);
            return null;
        }
    }

    public void write(StringBuffer stringBuffer) {
        try {
            int n;
            Object object;
            int n2;
            this.model.update();
            if (this.model.get(GRB.IntAttr.ModelSense) == -1) {
                stringBuffer.append("max");
            } else {
                stringBuffer.append("min");
            }
            for (n2 = 0; n2 < this.objectiveCoefficients.size(); ++n2) {
                double d = this.objectiveCoefficients.get(n2);
                stringBuffer.append(" ");
                if (d >= 0.0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append(d);
                stringBuffer.append(" x_");
                stringBuffer.append(n2);
            }
            stringBuffer.append("\n");
            n2 = this.SOSes.size();
            for (int i = 0; i < n2; ++i) {
                GRBSOS gRBSOS = (GRBSOS)this.SOSes.get(i);
                object = new int[1];
                n = this.model.getSOS(gRBSOS, null, null, object);
                GRBVar[] gRBVarArray = new GRBVar[n];
                this.model.getSOS(gRBSOS, gRBVarArray, new double[n], object);
                stringBuffer.append(" atmost 1 of (x in {");
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append(gRBVarArray[j].get(GRB.StringAttr.VarName));
                    if (j + 1 >= n) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append("}) (x > 0)\n");
            }
            GRBConstr[] gRBConstrArray = this.model.getConstrs();
            for (int i = 0; i < gRBConstrArray.length; ++i) {
                int n3;
                object = this.model.getRow(gRBConstrArray[i]);
                n = object.size();
                stringBuffer.append(" ");
                for (n3 = 0; n3 < n; ++n3) {
                    double d = object.getCoeff(n3);
                    stringBuffer.append(" ");
                    if (d >= 0.0) {
                        stringBuffer.append("+");
                    }
                    stringBuffer.append(d);
                    stringBuffer.append(" ");
                    stringBuffer.append(object.getVar(n3).get(GRB.StringAttr.VarName));
                }
                n3 = gRBConstrArray[i].get(GRB.CharAttr.Sense);
                if (n3 == 60) {
                    stringBuffer.append(" <= ");
                } else if (n3 == 62) {
                    stringBuffer.append(" >= ");
                } else {
                    stringBuffer.append(" = ");
                }
                stringBuffer.append(gRBConstrArray[i].get(GRB.DoubleAttr.RHS));
                stringBuffer.append("\n");
            }
        }
        catch (GRBException gRBException) {
            GurobiHook.handleException(gRBException);
        }
    }
}

