/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.classify.Score;
import LBJ2.classify.ScoreSet;
import LBJ2.infer.Constraint;
import LBJ2.infer.FirstOrderConjunction;
import LBJ2.infer.FirstOrderConstraint;
import LBJ2.infer.FirstOrderVariable;
import LBJ2.infer.ILPSolver;
import LBJ2.infer.Inference;
import LBJ2.infer.InferenceNotOptimalException;
import LBJ2.infer.PropositionalAtLeast;
import LBJ2.infer.PropositionalConjunction;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.PropositionalDisjunction;
import LBJ2.infer.PropositionalDoubleImplication;
import LBJ2.infer.PropositionalImplication;
import LBJ2.infer.PropositionalNegation;
import LBJ2.infer.PropositionalVariable;
import LBJ2.learn.Learner;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

public class ILPInference
extends Inference {
    public static final int VERBOSITY_NONE = 0;
    public static final int VERBOSITY_LOW = 1;
    public static final int VERBOSITY_HIGH = 2;
    protected static int nextID;
    protected int ID;
    protected ILPSolver solver;
    protected boolean tautology;
    protected int returnIndex;
    protected boolean returnNegation;
    protected HashMap indexMap;
    protected boolean topLevel;
    protected int verbosity;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ILPInference() {
        this(null);
    }

    public ILPInference(ILPSolver iLPSolver) {
        this(null, iLPSolver);
    }

    public ILPInference(ILPSolver iLPSolver, int n) {
        this(null, iLPSolver, n);
    }

    public ILPInference(Object object) {
        this(object, null);
    }

    public ILPInference(Object object, ILPSolver iLPSolver) {
        this(object, iLPSolver, 0);
    }

    public ILPInference(Object object, ILPSolver iLPSolver, int n) {
        super(object);
        this.solver = iLPSolver;
        this.verbosity = n;
        this.ID = nextID++;
    }

    public void addConstraint(FirstOrderConstraint firstOrderConstraint) {
        this.solver.reset();
        this.constraint = this.constraint == null ? firstOrderConstraint : new FirstOrderConjunction((FirstOrderConstraint)this.constraint, firstOrderConstraint);
    }

    protected void infer() throws Exception {
        StringBuffer stringBuffer;
        int n;
        Object[] objectArray;
        Object object;
        Object object2;
        if (this.tautology || this.solver.isSolved()) {
            return;
        }
        this.solver.setMaximize(true);
        this.constraint.consolidateVariables(this.variables);
        this.indexMap = new HashMap();
        if (this.verbosity > 0) {
            System.out.println("variables: (" + new Date() + ")");
        }
        Object object3 = this.variables.values().iterator();
        while (object3.hasNext()) {
            FirstOrderVariable firstOrderVariable = (FirstOrderVariable)object3.next();
            object2 = this.getNormalizer(firstOrderVariable.getClassifier()).normalize(firstOrderVariable.getScores());
            object = null;
            if (object2 != null) {
                object = ((ScoreSet)object2).toArray();
            }
            if (object == null || ((Score[])object).length == 0) {
                System.err.println("LBJ ERROR: Classifier " + firstOrderVariable.getClassifier() + " did not return any scores.  ILP inference cannot be " + "performed.");
                System.exit(1);
            }
            objectArray = this.solver.addDiscreteVariable((Score[])object);
            for (n = 0; n < ((Score[])object).length; ++n) {
                this.indexMap.put(new PropositionalVariable(firstOrderVariable.getClassifier(), firstOrderVariable.getExample(), object[n].value), new Integer(objectArray[n]));
                if (this.verbosity < 2) continue;
                stringBuffer = new StringBuffer();
                stringBuffer.append("x_");
                stringBuffer.append(objectArray[n]);
                while (stringBuffer.length() < 8) {
                    stringBuffer.insert(0, ' ');
                }
                stringBuffer.append(" (");
                stringBuffer.append(((Score)object[n]).score);
                stringBuffer.append("): ");
                stringBuffer.append(firstOrderVariable.getClassifier());
                stringBuffer.append("(");
                stringBuffer.append(Inference.exampleToString(firstOrderVariable.getExample()));
                stringBuffer.append(") == ");
                stringBuffer.append(((Score)object[n]).value);
                System.out.println(stringBuffer);
            }
        }
        if (this.verbosity > 0) {
            System.out.println("propositionalization: (" + new Date() + ")");
        }
        object3 = ((FirstOrderConstraint)this.constraint).propositionalize();
        if (this.verbosity > 0) {
            System.out.println("simplification: (" + new Date() + ")");
        }
        if ((object3 = object3 instanceof PropositionalConjunction ? ((PropositionalConjunction)object3).simplify(true) : ((PropositionalConstraint)object3).simplify()) instanceof PropositionalConstant) {
            if (((Constraint)object3).evaluate()) {
                this.tautology = true;
                return;
            }
            System.err.println("ILP ERROR: Unsatisfiable constraints!");
            this.solver.addEqualityConstraint(new int[]{0}, new double[]{1.0}, 2.0);
        }
        if (this.verbosity > 0) {
            System.out.println("translation: (" + new Date() + ")");
        }
        this.topLevel = true;
        ((Constraint)object3).runVisit(this);
        if (this.verbosity > 0) {
            System.out.println("solution: (" + new Date() + ")");
        }
        if (!this.solver.solve()) {
            throw new InferenceNotOptimalException(this.solver, this.head);
        }
        int n2 = 0;
        if (this.verbosity > 0) {
            System.out.println("variables set true in solution: (" + new Date() + ")");
        }
        object2 = this.variables.values().iterator();
        while (object2.hasNext()) {
            object = (FirstOrderVariable)object2.next();
            objectArray = ((FirstOrderVariable)object).getScores().toArray();
            n = 0;
            while (n < objectArray.length) {
                if (this.solver.getBooleanValue(n2)) {
                    ((FirstOrderVariable)object).setValue(objectArray[n].value);
                    if (this.verbosity >= 2) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("x_");
                        stringBuffer.append(n2);
                        while (stringBuffer.length() < 8) {
                            stringBuffer.insert(0, ' ');
                        }
                        stringBuffer.append(": ");
                        stringBuffer.append(object);
                        System.out.println(stringBuffer);
                    }
                }
                ++n;
                ++n2;
            }
        }
    }

    public String valueOf(Learner learner, Object object) throws Exception {
        this.infer();
        return this.getVariable(new FirstOrderVariable(learner, object)).getValue();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ILPInference)) {
            return false;
        }
        return this.head == ((ILPInference)object).head;
    }

    public int hashCode() {
        return this.head.hashCode();
    }

    protected int createVariable(String string) {
        int n = this.solver.addBooleanVariable(0.0);
        if (this.verbosity >= 2) {
            System.out.println(n + ": " + string);
        }
        return n;
    }

    public void visit(PropositionalDoubleImplication propositionalDoubleImplication) {
        if (!$assertionsDisabled && !this.topLevel) {
            throw new AssertionError((Object)"ILP: PropositionalDoubleImplication encountered.");
        }
        this.topLevel = false;
        int[] nArray = new int[2];
        double[] dArray = new double[2];
        double d = 0.0;
        propositionalDoubleImplication.left.runVisit(this);
        nArray[0] = this.returnIndex;
        if (this.returnNegation) {
            dArray[0] = -1.0;
            d -= 1.0;
        } else {
            dArray[0] = 1.0;
        }
        propositionalDoubleImplication.right.runVisit(this);
        nArray[1] = this.returnIndex;
        if (this.returnNegation) {
            dArray[1] = 1.0;
            d += 1.0;
        } else {
            dArray[1] = -1.0;
        }
        this.solver.addEqualityConstraint(nArray, dArray, d);
        this.topLevel = true;
    }

    public void visit(PropositionalImplication propositionalImplication) {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"ILP: PropositionalImplication encountered.");
        }
    }

    public void visit(PropositionalConjunction propositionalConjunction) {
        PropositionalConstraint[] propositionalConstraintArray = (PropositionalConstraint[])propositionalConjunction.getChildren();
        int[] nArray = null;
        double[] dArray = null;
        if (this.topLevel) {
            int n;
            PropositionalConstraint[] propositionalConstraintArray2 = new PropositionalConstraint[propositionalConstraintArray.length];
            int n2 = 0;
            for (n = 0; n < propositionalConstraintArray.length; ++n) {
                if (propositionalConstraintArray[n] instanceof PropositionalVariable || propositionalConstraintArray[n] instanceof PropositionalNegation) {
                    propositionalConstraintArray2[n2++] = propositionalConstraintArray[n];
                    continue;
                }
                propositionalConstraintArray[n].runVisit(this);
            }
            if (n2 > 0) {
                nArray = new int[n2];
                dArray = new double[n2];
                double d = n2;
                for (n = 0; n < n2; ++n) {
                    propositionalConstraintArray2[n].runVisit(this);
                    nArray[n] = this.returnIndex;
                    if (this.returnNegation) {
                        dArray[n] = -1.0;
                        d -= 1.0;
                        continue;
                    }
                    dArray[n] = 1.0;
                }
                this.solver.addEqualityConstraint(nArray, dArray, d);
            }
        } else {
            nArray = new int[propositionalConstraintArray.length + 1];
            dArray = new double[propositionalConstraintArray.length + 1];
            double d = 0.0;
            for (int i = 0; i < propositionalConstraintArray.length; ++i) {
                propositionalConstraintArray[i].runVisit(this);
                nArray[i] = this.returnIndex;
                if (this.returnNegation) {
                    dArray[i] = -1.0;
                    d -= 1.0;
                    continue;
                }
                dArray[i] = 1.0;
            }
            Object[] objectArray = new String[propositionalConstraintArray.length];
            for (int i = 0; i < propositionalConstraintArray.length; ++i) {
                objectArray[i] = (dArray[i] < 0.0 ? "!" : "") + nArray[i];
            }
            Arrays.sort(objectArray);
            Object object = objectArray[0];
            for (int i = 1; i < objectArray.length; ++i) {
                object = (String)object + "&" + (String)objectArray[i];
            }
            Integer n = (Integer)this.indexMap.get(object);
            if (n == null) {
                n = new Integer(this.createVariable((String)object));
                this.indexMap.put(object, n);
                nArray[propositionalConstraintArray.length] = n;
                dArray[propositionalConstraintArray.length] = -propositionalConstraintArray.length;
                this.solver.addGreaterThanConstraint(nArray, dArray, d);
                dArray[propositionalConstraintArray.length] = -1.0;
                this.solver.addLessThanConstraint(nArray, dArray, d + (double)propositionalConstraintArray.length - 1.0);
            }
            this.returnIndex = n;
            this.returnNegation = false;
        }
    }

    public void visit(PropositionalDisjunction propositionalDisjunction) {
        int n;
        int n2;
        PropositionalConstraint[] propositionalConstraintArray = (PropositionalConstraint[])propositionalDisjunction.getChildren();
        int[] nArray = null;
        double[] dArray = null;
        double d = 0.0;
        if (this.topLevel) {
            n2 = -1;
            for (n = 0; n < propositionalConstraintArray.length && n2 == -1; ++n) {
                if (propositionalConstraintArray[n] instanceof PropositionalVariable || propositionalConstraintArray[n] instanceof PropositionalNegation) continue;
                if (propositionalConstraintArray[n] instanceof PropositionalConjunction) {
                    n2 = n;
                    continue;
                }
                if (!(propositionalConstraintArray[n] instanceof PropositionalAtLeast)) continue;
                n2 = n;
            }
            if (n2 > -1) {
                int n3;
                PropositionalConstraint[] propositionalConstraintArray2 = (PropositionalConstraint[])propositionalConstraintArray[n2].getChildren();
                int n4 = propositionalConstraintArray[n2] instanceof PropositionalConjunction ? propositionalConstraintArray2.length : ((PropositionalAtLeast)propositionalConstraintArray[n2]).getM();
                nArray = new int[propositionalConstraintArray2.length + propositionalConstraintArray.length - 1];
                dArray = new double[propositionalConstraintArray2.length + propositionalConstraintArray.length - 1];
                d = n4;
                this.topLevel = false;
                int n5 = 0;
                for (n3 = 0; n3 < propositionalConstraintArray.length; ++n3) {
                    if (n3 == n2) continue;
                    propositionalConstraintArray[n3].runVisit(this);
                    nArray[n5] = this.returnIndex;
                    if (this.returnNegation) {
                        dArray[n5] = -n4;
                        d -= (double)n4;
                    } else {
                        dArray[n5] = n4;
                    }
                    ++n5;
                }
                n3 = 0;
                while (n3 < propositionalConstraintArray2.length) {
                    propositionalConstraintArray2[n3].runVisit(this);
                    nArray[n5] = this.returnIndex;
                    if (this.returnNegation) {
                        dArray[n5] = -1.0;
                        d -= 1.0;
                    } else {
                        dArray[n5] = 1.0;
                    }
                    ++n3;
                    ++n5;
                }
                this.topLevel = true;
                this.solver.addGreaterThanConstraint(nArray, dArray, d);
                return;
            }
        }
        if (this.topLevel) {
            nArray = new int[propositionalConstraintArray.length];
            dArray = new double[propositionalConstraintArray.length];
            d = 1.0;
        } else {
            nArray = new int[propositionalConstraintArray.length + 1];
            dArray = new double[propositionalConstraintArray.length + 1];
        }
        n2 = this.topLevel ? 1 : 0;
        this.topLevel = false;
        for (n = 0; n < propositionalConstraintArray.length; ++n) {
            propositionalConstraintArray[n].runVisit(this);
            nArray[n] = this.returnIndex;
            if (this.returnNegation) {
                dArray[n] = -1.0;
                d -= 1.0;
                continue;
            }
            dArray[n] = 1.0;
        }
        this.topLevel = n2;
        if (this.topLevel) {
            this.solver.addGreaterThanConstraint(nArray, dArray, d);
        } else {
            Object[] objectArray = new String[propositionalConstraintArray.length];
            for (int i = 0; i < propositionalConstraintArray.length; ++i) {
                objectArray[i] = (dArray[i] < 0.0 ? "!" : "") + nArray[i];
            }
            Arrays.sort(objectArray);
            Object object = objectArray[0];
            for (int i = 1; i < objectArray.length; ++i) {
                object = (String)object + "|" + (String)objectArray[i];
            }
            Integer n6 = (Integer)this.indexMap.get(object);
            if (n6 == null) {
                n6 = new Integer(this.createVariable((String)object));
                this.indexMap.put(object, n6);
                nArray[propositionalConstraintArray.length] = n6;
                dArray[propositionalConstraintArray.length] = -1.0;
                this.solver.addGreaterThanConstraint(nArray, dArray, d);
                dArray[propositionalConstraintArray.length] = -propositionalConstraintArray.length;
                this.solver.addLessThanConstraint(nArray, dArray, d);
            }
            this.returnIndex = n6;
            this.returnNegation = false;
        }
    }

    public void visit(PropositionalAtLeast propositionalAtLeast) {
        PropositionalConstraint[] propositionalConstraintArray = (PropositionalConstraint[])propositionalAtLeast.getChildren();
        int[] nArray = null;
        double[] dArray = null;
        double d = 0.0;
        if (this.topLevel) {
            nArray = new int[propositionalConstraintArray.length];
            dArray = new double[propositionalConstraintArray.length];
            d = propositionalAtLeast.getM();
        } else {
            nArray = new int[propositionalConstraintArray.length + 1];
            dArray = new double[propositionalConstraintArray.length + 1];
        }
        boolean bl = this.topLevel;
        this.topLevel = false;
        for (int i = 0; i < propositionalConstraintArray.length; ++i) {
            propositionalConstraintArray[i].runVisit(this);
            nArray[i] = this.returnIndex;
            if (this.returnNegation) {
                dArray[i] = -1.0;
                d -= 1.0;
                continue;
            }
            dArray[i] = 1.0;
        }
        this.topLevel = bl;
        if (this.topLevel) {
            this.solver.addGreaterThanConstraint(nArray, dArray, d);
        } else {
            Object[] objectArray = new String[propositionalConstraintArray.length];
            for (int i = 0; i < propositionalConstraintArray.length; ++i) {
                objectArray[i] = (dArray[i] < 0.0 ? "!" : "") + nArray[i];
            }
            Arrays.sort(objectArray);
            String string = "atl" + propositionalAtLeast.getM() + "of" + (String)objectArray[0];
            for (int i = 1; i < objectArray.length; ++i) {
                string = string + "&" + (String)objectArray[i];
            }
            Integer n = (Integer)this.indexMap.get(string);
            if (n == null) {
                n = new Integer(this.createVariable(string));
                this.indexMap.put(string, n);
                nArray[propositionalConstraintArray.length] = n;
                dArray[propositionalConstraintArray.length] = -propositionalAtLeast.getM();
                this.solver.addGreaterThanConstraint(nArray, dArray, d);
                dArray[propositionalConstraintArray.length] = -propositionalConstraintArray.length;
                this.solver.addLessThanConstraint(nArray, dArray, d + (double)propositionalAtLeast.getM() - 1.0);
            }
            this.returnIndex = n;
            this.returnNegation = false;
        }
    }

    public void visit(PropositionalNegation propositionalNegation) {
        if (!$assertionsDisabled && !(propositionalNegation.constraint instanceof PropositionalVariable)) {
            throw new AssertionError((Object)("ILP: Negation of a " + propositionalNegation.constraint.getClass().getName() + " encountered."));
        }
        propositionalNegation.constraint.runVisit(this);
        this.returnNegation = true;
    }

    public void visit(PropositionalVariable propositionalVariable) {
        this.returnIndex = (Integer)this.indexMap.get(propositionalVariable);
        this.returnNegation = false;
    }

    public void visit(PropositionalConstant propositionalConstant) {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("ILP: Constant encountered. (" + propositionalConstant.evaluate() + ")"));
        }
    }

    static {
        $assertionsDisabled = !ILPInference.class.desiredAssertionStatus();
        nextID = 0;
    }
}

