/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.Constraint;
import LBJ2.infer.Inference;
import LBJ2.infer.PropositionalAtLeast;
import LBJ2.infer.PropositionalConjunction;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.PropositionalDisjunction;
import LBJ2.infer.PropositionalDoubleImplication;
import LBJ2.infer.PropositionalImplication;
import LBJ2.infer.PropositionalNegation;
import LBJ2.infer.PropositionalVariable;
import java.util.AbstractMap;

public class PropositionalConstant
extends PropositionalConstraint {
    public static final PropositionalConstant True = new PropositionalConstant(true);
    public static final PropositionalConstant False = new PropositionalConstant(false);
    protected boolean constant;

    public PropositionalConstant(boolean bl) {
        this.constant = bl;
    }

    public void consolidateVariables(AbstractMap abstractMap) {
    }

    public boolean evaluate() {
        return this.constant;
    }

    public PropositionalConstraint simplify() {
        return this.constant ? True : False;
    }

    public PropositionalConstraint negate() {
        return this.constant ? False : True;
    }

    public PropositionalConstraint CNF() {
        return this.simplify();
    }

    public PropositionalConstraint DNF() {
        return this.simplify();
    }

    public Constraint[] getChildren() {
        return new PropositionalConstraint[0];
    }

    public boolean moreGeneralThan(PropositionalConstraint propositionalConstraint) {
        return propositionalConstraint.moreSpecificThan(this);
    }

    public boolean moreSpecificThan(PropositionalImplication propositionalImplication) {
        return !this.constant;
    }

    public boolean moreSpecificThan(PropositionalDoubleImplication propositionalDoubleImplication) {
        return !this.constant;
    }

    public boolean moreSpecificThan(PropositionalConjunction propositionalConjunction) {
        return !this.constant;
    }

    public boolean moreSpecificThan(PropositionalDisjunction propositionalDisjunction) {
        return !this.constant;
    }

    public boolean moreSpecificThan(PropositionalAtLeast propositionalAtLeast) {
        return !this.constant;
    }

    public boolean moreSpecificThan(PropositionalNegation propositionalNegation) {
        return !this.constant;
    }

    public boolean moreSpecificThan(PropositionalVariable propositionalVariable) {
        return !this.constant;
    }

    public boolean moreSpecificThan(PropositionalConstant propositionalConstant) {
        return propositionalConstant.evaluate() && !this.constant;
    }

    public int hashCode() {
        return new Boolean(this.constant).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropositionalConstant)) {
            return false;
        }
        PropositionalConstant propositionalConstant = (PropositionalConstant)object;
        return this.constant == propositionalConstant.constant;
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }

    public void write(StringBuffer stringBuffer) {
        stringBuffer.append(this.constant);
    }
}

