/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.infer;

import LBJ2.infer.Constraint;
import LBJ2.infer.Inference;
import LBJ2.infer.PropositionalAtLeast;
import LBJ2.infer.PropositionalConjunction;
import LBJ2.infer.PropositionalConstant;
import LBJ2.infer.PropositionalConstraint;
import LBJ2.infer.PropositionalDisjunction;
import LBJ2.infer.PropositionalDoubleImplication;
import LBJ2.infer.PropositionalImplication;
import LBJ2.infer.PropositionalVariable;
import java.util.AbstractMap;

public class PropositionalNegation
extends PropositionalConstraint {
    protected PropositionalConstraint constraint;

    public PropositionalNegation(PropositionalConstraint propositionalConstraint) {
        this.constraint = propositionalConstraint;
    }

    public void consolidateVariables(AbstractMap abstractMap) {
        if (this.constraint instanceof PropositionalVariable) {
            if (abstractMap.containsKey(this.constraint)) {
                this.constraint = (PropositionalVariable)abstractMap.get(this.constraint);
            } else {
                abstractMap.put(this.constraint, this.constraint);
            }
        } else {
            this.constraint.consolidateVariables(abstractMap);
        }
    }

    public boolean evaluate() {
        return !this.constraint.evaluate();
    }

    public PropositionalConstraint simplify() {
        if (this.constraint instanceof PropositionalVariable) {
            return this;
        }
        return this.constraint.negate().simplify();
    }

    public PropositionalConstraint negate() {
        return this.constraint;
    }

    public PropositionalConstraint CNF() {
        PropositionalConstraint propositionalConstraint = this.simplify();
        if (propositionalConstraint instanceof PropositionalNegation) {
            return propositionalConstraint;
        }
        return propositionalConstraint.CNF();
    }

    public PropositionalConstraint DNF() {
        PropositionalConstraint propositionalConstraint = this.simplify();
        if (propositionalConstraint instanceof PropositionalNegation) {
            return propositionalConstraint;
        }
        return propositionalConstraint.DNF();
    }

    public Constraint[] getChildren() {
        return new PropositionalConstraint[]{this.constraint};
    }

    public boolean moreGeneralThan(PropositionalConstraint propositionalConstraint) {
        return propositionalConstraint.moreSpecificThan(this);
    }

    public boolean moreSpecificThan(PropositionalImplication propositionalImplication) {
        PropositionalConstraint[] propositionalConstraintArray = (PropositionalConstraint[])propositionalImplication.getChildren();
        return this.constraint.equals(propositionalConstraintArray[0]) || this.equals(propositionalConstraintArray[1]);
    }

    public boolean moreSpecificThan(PropositionalDoubleImplication propositionalDoubleImplication) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalConjunction propositionalConjunction) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalDisjunction propositionalDisjunction) {
        return propositionalDisjunction.size() > 1 && propositionalDisjunction.contains(this);
    }

    public boolean moreSpecificThan(PropositionalAtLeast propositionalAtLeast) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalNegation propositionalNegation) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalVariable propositionalVariable) {
        return false;
    }

    public boolean moreSpecificThan(PropositionalConstant propositionalConstant) {
        return propositionalConstant.evaluate();
    }

    public int hashCode() {
        return this.constraint.hashCode() + 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropositionalNegation)) {
            return false;
        }
        PropositionalNegation propositionalNegation = (PropositionalNegation)object;
        return this.constraint.equals(propositionalNegation.constraint);
    }

    public void runVisit(Inference inference) {
        inference.visit(this);
    }

    public void write(StringBuffer stringBuffer) {
        stringBuffer.append("!");
        this.constraint.write(stringBuffer);
    }
}

