/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.learn.Lexicon;
import LBJ2.learn.RandomWeightVector;
import LBJ2.learn.SparseWeightVector;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.PrintStream;

public class BiasedRandomWeightVector
extends RandomWeightVector {
    protected double bias;

    public BiasedRandomWeightVector() {
        this(100.0);
    }

    public BiasedRandomWeightVector(double d) {
        super(d);
        this.bias = this.random.nextGaussian() * this.stddev;
    }

    public double dot(int[] nArray, double[] dArray, double d) {
        return super.dot(nArray, dArray, d) + this.bias;
    }

    public void scaledAdd(int[] nArray, double[] dArray, double d, double d2) {
        super.scaledAdd(nArray, dArray, d, d2);
        this.bias += d;
    }

    public void clear() {
        super.clear();
        this.bias = this.random.nextGaussian() * this.stddev;
    }

    public void write(PrintStream printStream) {
        printStream.println("Begin BiasedRandomWeightVector");
        printStream.println("stddev = " + this.stddev);
        printStream.println("bias = " + this.bias);
        this.toStringJustWeights(printStream);
        printStream.println("End BiasedRandomWeightVector");
    }

    public void write(PrintStream printStream, Lexicon lexicon) {
        printStream.println("Begin BiasedRandomWeightVector");
        printStream.println("stddev = " + this.stddev);
        printStream.println("bias = " + this.bias);
        this.toStringJustWeights(printStream, 0, lexicon);
        printStream.println("End BiasedRandomWeightVector");
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeDouble(this.bias);
    }

    public SparseWeightVector emptyClone() {
        return new BiasedRandomWeightVector(this.stddev);
    }
}

