/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.learn.Learner;
import LBJ2.learn.LinearThresholdUnit;
import LBJ2.learn.SparseWeightVector;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.PrintStream;

public class SparseWinnow
extends LinearThresholdUnit {
    public static final double defaultLearningRate = 2.0;
    public static final double defaultThreshold = 16.0;
    public static final double defaultInitialWeight = 1.0;
    protected double beta;

    public SparseWinnow() {
        this("");
    }

    public SparseWinnow(double d) {
        this("", d);
    }

    public SparseWinnow(double d, double d2) {
        this("", d, d2);
    }

    public SparseWinnow(double d, double d2, double d3) {
        this("", d, d2, d3);
    }

    public SparseWinnow(double d, double d2, double d3, double d4) {
        this("", d, d2, d3, d4);
    }

    public SparseWinnow(double d, double d2, double d3, double d4, double d5) {
        this("", d, d2, d3, d4, d5);
    }

    public SparseWinnow(double d, double d2, double d3, double d4, double d5, SparseWeightVector sparseWeightVector) {
        this("", d, d2, d3, d4, d5, sparseWeightVector);
    }

    public SparseWinnow(Parameters parameters) {
        this("", parameters);
    }

    public SparseWinnow(String string) {
        this(string, 2.0);
    }

    public SparseWinnow(String string, double d) {
        this(string, d, 1.0 / d);
    }

    public SparseWinnow(String string, double d, double d2) {
        this(string, d, d2, 16.0);
    }

    public SparseWinnow(String string, double d, double d2, double d3) {
        this(string, d, d2, d3, 0.0);
    }

    public SparseWinnow(String string, double d, double d2, double d3, double d4) {
        this(string, d, d2, d3, d4, d4);
    }

    public SparseWinnow(String string, double d, double d2, double d3, double d4, double d5) {
        this(string, d, d2, d3, d4, d5, (SparseWeightVector)LinearThresholdUnit.defaultWeightVector.clone());
    }

    public SparseWinnow(String string, double d, double d2, double d3, double d4, double d5, SparseWeightVector sparseWeightVector) {
        super(string);
        Parameters parameters = new Parameters();
        parameters.learningRate = d;
        parameters.beta = d2;
        parameters.threshold = d3;
        parameters.positiveThickness = d4;
        parameters.negativeThickness = d5;
        parameters.weightVector = sparseWeightVector;
        this.setParameters(parameters);
    }

    public SparseWinnow(String string, Parameters parameters) {
        super(string);
        this.setParameters(parameters);
    }

    public void setParameters(Parameters parameters) {
        super.setParameters(parameters);
        this.beta = parameters.beta;
    }

    public Learner.Parameters getParameters() {
        Parameters parameters = new Parameters((LinearThresholdUnit.Parameters)super.getParameters());
        parameters.beta = this.beta;
        return parameters;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double d) {
        this.learningRate = d;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double d) {
        this.beta = d;
    }

    public double computeLearningRate(int[] nArray, double[] dArray, double d, boolean bl) {
        if (bl) {
            return this.learningRate;
        }
        return this.beta;
    }

    public void promote(int[] nArray, double[] dArray, double d) {
        this.update(nArray, dArray, d);
    }

    public void demote(int[] nArray, double[] dArray, double d) {
        this.update(nArray, dArray, d);
    }

    public void update(int[] nArray, double[] dArray, double d) {
        this.weightVector.scaledMultiply(nArray, dArray, d, this.initialWeight);
        this.bias *= d;
    }

    public void write(PrintStream printStream) {
        printStream.println(this.name + ": " + this.learningRate + ", " + this.beta + ", " + this.initialWeight + ", " + this.threshold + ", " + this.positiveThickness + ", " + this.negativeThickness + ", " + this.bias);
        if (this.lexicon.size() == 0) {
            this.weightVector.write(printStream);
        } else {
            this.weightVector.write(printStream, this.lexicon);
        }
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeDouble(this.beta);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.beta = exceptionlessInputStream.readDouble();
    }

    public static class Parameters
    extends LinearThresholdUnit.Parameters {
        public double beta;

        public Parameters() {
            this.learningRate = 2.0;
            this.beta = 0.5;
            this.threshold = 16.0;
            this.initialWeight = 1.0;
        }

        public Parameters(LinearThresholdUnit.Parameters parameters) {
            super(parameters);
            this.beta = 1.0 / this.learningRate;
        }

        public Parameters(Parameters parameters) {
            super(parameters);
            this.beta = parameters.beta;
        }

        public void setParameters(Learner learner) {
            ((SparseWinnow)learner).setParameters(this);
        }

        public String nonDefaultString() {
            String string = super.nonDefaultString();
            if (this.beta != 10.0) {
                string = string + ", beta = " + this.beta;
            }
            if (string.startsWith(", ")) {
                string = string.substring(2);
            }
            return string;
        }
    }
}

