/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.learn;

import LBJ2.classify.DiscretePrimitiveStringFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.FeatureVector;
import LBJ2.classify.RealPrimitiveStringFeature;
import LBJ2.classify.ScoreSet;
import LBJ2.learn.Learner;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WekaWrapper
extends Learner {
    public static final String defaultAttributeString = "";
    public static final Classifier defaultBaseClassifier = new NaiveBayes();
    protected String attributeString;
    protected Classifier baseClassifier;
    protected Classifier freshClassifier;
    protected FastVector attributeInfo = new FastVector();
    protected Instances instances;
    protected boolean trained = false;
    protected String[] allowableValues;

    public WekaWrapper() {
        this(defaultAttributeString);
    }

    public WekaWrapper(Classifier classifier) {
        this(defaultAttributeString, classifier);
    }

    public WekaWrapper(Classifier classifier, String string) {
        this(defaultAttributeString, classifier, string);
    }

    public WekaWrapper(Parameters parameters) {
        this(defaultAttributeString, parameters);
    }

    public WekaWrapper(String string) {
        this(string, new Parameters());
    }

    public WekaWrapper(String string, Classifier classifier) {
        this(string, classifier, defaultAttributeString);
    }

    public WekaWrapper(String string, String string2) {
        this(string, defaultBaseClassifier, string2);
    }

    public WekaWrapper(String string, Parameters parameters) {
        super(string);
        this.setParameters(parameters);
        this.freshClassifier = this.baseClassifier;
    }

    public WekaWrapper(String string, Classifier classifier, String string2) {
        super(string);
        Parameters parameters = new Parameters();
        parameters.baseClassifier = classifier;
        parameters.attributeString = string2;
        this.setParameters(parameters);
        this.freshClassifier = classifier;
    }

    public void setParameters(Parameters parameters) {
        this.baseClassifier = parameters.baseClassifier;
        this.attributeString = parameters.attributeString;
        this.initializeAttributes();
    }

    public Learner.Parameters getParameters() {
        Parameters parameters = new Parameters(super.getParameters());
        parameters.baseClassifier = this.baseClassifier;
        parameters.attributeString = this.attributeString;
        return parameters;
    }

    public String getOutputType() {
        return "mixed%";
    }

    public void initializeAttributes() {
        String[] stringArray = this.attributeString.split(":");
        for (int i = 0; i < stringArray.length; ++i) {
            Attribute attribute;
            String[] stringArray2;
            String[] stringArray3 = stringArray[i].split("_");
            if (stringArray3[0].equals("str")) {
                stringArray2 = stringArray3[1];
                attribute = new Attribute((String)stringArray2, (FastVector)null);
                this.attributeInfo.addElement((Object)attribute);
                continue;
            }
            if (stringArray3[0].equals("nom")) {
                stringArray2 = stringArray3[2].split(",");
                attribute = new FastVector(stringArray2.length);
                for (int j = 0; j < stringArray2.length; ++j) {
                    attribute.addElement((Object)stringArray2[j]);
                }
                Attribute attribute2 = new Attribute(stringArray3[1], (FastVector)attribute);
                this.attributeInfo.addElement((Object)attribute2);
                continue;
            }
            if (stringArray3[0].equals("num")) {
                this.attributeInfo.addElement((Object)new Attribute(stringArray3[1]));
                continue;
            }
            System.err.println("WekaWrapper: Error - Malformed attribute information string: " + this.attributeString);
            new Exception().printStackTrace();
            System.exit(1);
        }
        this.instances = new Instances(this.name, this.attributeInfo, 0);
        this.instances.setClassIndex(0);
    }

    public void setLabeler(LBJ2.classify.Classifier classifier) {
        super.setLabeler(classifier);
        this.allowableValues = classifier == null ? null : classifier.allowableValues();
    }

    public String[] allowableValues() {
        if (this.allowableValues == null) {
            return new String[0];
        }
        return this.allowableValues;
    }

    public void learn(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2) {
        this.instances.add(this.makeInstance(nArray, dArray, nArray2, dArray2));
    }

    public FeatureVector classify(int[] nArray, double[] dArray) {
        Attribute attribute;
        if (!this.trained) {
            System.err.println("WekaWrapper: Error - Cannot make a classification with an untrained classifier.");
            new Exception().printStackTrace();
            System.exit(1);
        }
        if ((attribute = (Attribute)this.attributeInfo.elementAt(0)).isNominal() || attribute.isString()) {
            double[] dArray2 = this.getDistribution(nArray, dArray);
            int n = 0;
            for (int i = 1; i < dArray2.length; ++i) {
                if (!(dArray2[i] > dArray2[n])) continue;
                n = i;
            }
            Feature feature = this.labelLexicon.lookupKey(n);
            if (feature == null) {
                return new FeatureVector();
            }
            String string = feature.getStringValue();
            return new FeatureVector(new DiscretePrimitiveStringFeature(this.containingPackage, this.name, defaultAttributeString, string, this.valueIndexOf(string), (short)this.allowableValues().length));
        }
        if (attribute.isNumeric()) {
            return new FeatureVector(new RealPrimitiveStringFeature(this.containingPackage, this.name, defaultAttributeString, this.getDistribution(nArray, dArray)[0]));
        }
        System.err.println("WekaWrapper: Error - illegal class type.");
        new Exception().printStackTrace();
        System.exit(1);
        return new FeatureVector();
    }

    protected double[] getDistribution(int[] nArray, double[] dArray) {
        if (!this.trained) {
            System.err.println("WekaWrapper: Error - Cannot make a classification with an untrained classifier.");
            new Exception().printStackTrace();
            System.exit(1);
        }
        Instance instance = this.makeInstance(nArray, dArray, new int[0], new double[0]);
        double[] dArray2 = null;
        try {
            dArray2 = this.baseClassifier.distributionForInstance(instance);
        }
        catch (Exception exception) {
            System.err.println("WekaWrapper: Error while computing distribution.");
            exception.printStackTrace();
            System.exit(1);
        }
        if (dArray2.length == 0) {
            System.err.println("WekaWrapper: Error - The base classifier returned an empty probability distribution when attempting to classify an example.");
            new Exception().printStackTrace();
            System.exit(1);
        }
        return dArray2;
    }

    public void forget() {
        super.forget();
        try {
            this.baseClassifier = Classifier.makeCopy((Classifier)this.freshClassifier);
        }
        catch (Exception exception) {
            System.err.println("LBJ ERROR: WekaWrapper.forget: Can't copy classifier:");
            exception.printStackTrace();
            System.exit(1);
        }
        this.instances = new Instances(this.name, this.attributeInfo, 0);
        this.instances.setClassIndex(0);
        this.trained = false;
    }

    private Instance makeInstance(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2) {
        if (this.attributeInfo.size() == 0) {
            System.err.println("WekaWrapper: Error - makeInstance was called while attributeInfo was empty.");
            new Exception().printStackTrace();
            System.exit(1);
        }
        Instance instance = new Instance(this.attributeInfo.size());
        instance.setDataset(this.instances);
        int n = 0;
        int n2 = 1;
        while (n < nArray.length) {
            Feature feature = this.lexicon.lookupKey(nArray[n]);
            Attribute attribute = (Attribute)this.attributeInfo.elementAt(n2);
            if (!attribute.name().equals(feature.getStringIdentifier())) {
                System.err.println("WekaWrapper: Error - makeInstance encountered a misaligned attribute-feature pair.");
                System.err.println("  " + attribute.name() + " and " + feature.getStringIdentifier() + " should have been identical.");
                new Exception().printStackTrace();
                System.exit(1);
            }
            if (!feature.isDiscrete()) {
                instance.setValue(n2, dArray[n]);
            } else {
                String string = feature.totalValues() == 2 ? attribute.value((int)dArray[n]) : feature.getStringValue();
                instance.setValue(n2, string);
            }
            ++n;
            ++n2;
        }
        if (nArray2.length == 0) {
            instance.setClassMissing();
        } else if (nArray2.length > 1) {
            System.err.println("WekaWrapper: Error - Weka Instances may only take a single class value, ");
            new Exception().printStackTrace();
            System.exit(1);
        } else {
            Feature feature = this.labelLexicon.lookupKey(nArray2[0]);
            if (!feature.getStringIdentifier().equals(((Attribute)this.attributeInfo.elementAt(0)).name())) {
                System.err.println("WekaWrapper: Error - makeInstance found the wrong label name.");
                new Exception().printStackTrace();
                System.exit(1);
            }
            if (!feature.isDiscrete()) {
                instance.setValue(0, dArray2[0]);
            } else {
                instance.setValue(0, feature.getStringValue());
            }
        }
        return instance;
    }

    public ScoreSet scores(int[] nArray, double[] dArray) {
        double[] dArray2 = this.getDistribution(nArray, dArray);
        Attribute attribute = (Attribute)this.attributeInfo.elementAt(0);
        ScoreSet scoreSet = new ScoreSet();
        if (attribute.isNominal() || attribute.isString()) {
            Enumeration enumeration = attribute.enumerateValues();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                if (n >= dArray2.length) {
                    System.err.println("WekaWrapper: Error - scores found more possible values than probabilities.");
                    new Exception().printStackTrace();
                    System.exit(1);
                }
                double d = dArray2[n];
                String string = (String)enumeration.nextElement();
                scoreSet.put(string, d);
                ++n;
            }
        } else if (attribute.isNumeric()) {
            System.err.println("WekaWrapper: Error - The 'scores' function should not be called when the class attribute is numeric.");
            new Exception().printStackTrace();
            System.exit(1);
        } else {
            System.err.println("WekaWrapper: Error - ScoreSet: Class Types must be either Nominal, String, or Numeric.");
            new Exception().printStackTrace();
            System.exit(1);
        }
        return scoreSet;
    }

    public void doneLearning() {
        if (this.trained) {
            System.err.println("WekaWrapper: Error - Cannot call 'doneLearning()' again without first calling 'forget()'");
            new Exception().printStackTrace();
            System.exit(1);
        }
        try {
            this.baseClassifier.buildClassifier(this.instances);
        }
        catch (Exception exception) {
            System.err.println("WekaWrapper: Error - There was a problem building the classifier");
            if (this.baseClassifier == null) {
                System.out.println("WekaWrapper: baseClassifier was null.");
            }
            exception.printStackTrace();
            System.exit(1);
        }
        this.trained = true;
        this.instances = new Instances(this.name, this.attributeInfo, 0);
        this.instances.setClassIndex(0);
    }

    public void write(PrintStream printStream) {
        printStream.print(this.name + ": ");
        String[] stringArray = this.baseClassifier.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            printStream.println(stringArray[i]);
        }
        printStream.println(this.baseClassifier);
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeBoolean(this.trained);
        if (this.allowableValues == null) {
            exceptionlessOutputStream.writeInt(0);
        } else {
            exceptionlessOutputStream.writeInt(this.allowableValues.length);
            for (int i = 0; i < this.allowableValues.length; ++i) {
                exceptionlessOutputStream.writeString(this.allowableValues[i]);
            }
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(exceptionlessOutputStream);
        }
        catch (Exception exception) {
            System.err.println("Can't create object stream for '" + this.name + "': " + exception);
            System.exit(1);
        }
        try {
            objectOutputStream.writeObject(this.baseClassifier);
            objectOutputStream.writeObject(this.freshClassifier);
            objectOutputStream.writeObject(this.attributeInfo);
            objectOutputStream.writeObject(this.instances);
        }
        catch (Exception exception) {
            System.err.println("Can't write to object stream for '" + this.name + "': " + exception);
            System.exit(1);
        }
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.trained = exceptionlessInputStream.readBoolean();
        this.allowableValues = new String[exceptionlessInputStream.readInt()];
        for (int i = 0; i < this.allowableValues.length; ++i) {
            this.allowableValues[i] = exceptionlessInputStream.readString();
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(exceptionlessInputStream);
        }
        catch (Exception exception) {
            System.err.println("Can't create object stream for '" + this.name + "': " + exception);
            System.exit(1);
        }
        try {
            this.baseClassifier = (Classifier)objectInputStream.readObject();
            this.freshClassifier = (Classifier)objectInputStream.readObject();
            this.attributeInfo = (FastVector)objectInputStream.readObject();
            this.instances = (Instances)objectInputStream.readObject();
        }
        catch (Exception exception) {
            System.err.println("Can't read from object stream for '" + this.name + "': " + exception);
            System.exit(1);
        }
    }

    public static class Parameters
    extends Learner.Parameters {
        public Classifier baseClassifier;
        public String attributeString;

        public Parameters() {
            this.baseClassifier = defaultBaseClassifier;
            this.attributeString = WekaWrapper.defaultAttributeString;
        }

        public Parameters(Learner.Parameters parameters) {
            super(parameters);
            this.baseClassifier = defaultBaseClassifier;
            this.attributeString = WekaWrapper.defaultAttributeString;
        }

        public Parameters(Parameters parameters) {
            super(parameters);
            this.baseClassifier = parameters.baseClassifier;
            this.attributeString = parameters.attributeString;
        }

        public void setParameters(Learner learner) {
            ((WekaWrapper)learner).setParameters(this);
        }

        public String nonDefaultString() {
            String string = super.nonDefaultString();
            if (!this.attributeString.equals(WekaWrapper.defaultAttributeString)) {
                string = string + ", attributeString = \"" + this.attributeString + "\"";
            }
            if (string.startsWith(", ")) {
                string = string.substring(2);
            }
            return string;
        }
    }
}

