/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.nlp;

import LBJ2.nlp.POS;
import LBJ2.parse.LinkedChild;

public class Word
extends LinkedChild {
    public String form;
    public boolean capitalized;
    public String partOfSpeech;
    public String lemma;
    public String wordSense;

    public Word(String string) {
        this(string, null, null);
    }

    public Word(String string, String string2) {
        this(string, string2, null);
    }

    public Word(String string, Word word) {
        this(string, null, word);
    }

    public Word(String string, String string2, Word word) {
        this(string, string2, word, -1, -1);
    }

    public Word(String string, int n, int n2) {
        this(string, null, null, n, n2);
    }

    public Word(String string, String string2, int n, int n2) {
        this(string, string2, null, n, n2);
    }

    public Word(String string, Word word, int n, int n2) {
        this(string, null, word, n, n2);
    }

    public Word(String string, String string2, Word word, int n, int n2) {
        this(string, string2, null, null, word, n, n2);
    }

    public Word(String string, String string2, String string3, String string4, Word word, int n, int n2) {
        super(word, n, n2);
        this.form = string;
        this.capitalized = string != null && string.length() > 0 && Character.isUpperCase(string.charAt(0));
        this.partOfSpeech = string2;
        if (this.partOfSpeech != null) {
            POS.fromToken(this.partOfSpeech);
        }
        this.lemma = string3;
        this.wordSense = string4;
    }

    public String toString() {
        if (this.partOfSpeech == null) {
            return this.form;
        }
        String string = this.form;
        if (string.length() == 1) {
            if ("([{".indexOf(string.charAt(0)) != -1) {
                string = "-LRB-";
            }
            if (")]}".indexOf(string.charAt(0)) != -1) {
                string = "-RRB-";
            }
        }
        return "(" + this.partOfSpeech + " " + string + ")";
    }
}

