/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.parse;

import LBJ2.parse.FoldSeparator;
import LBJ2.parse.Parser;
import java.util.Arrays;
import java.util.Random;

public class FoldParser
implements Parser {
    protected Parser parser;
    protected int K;
    protected SplitPolicy splitPolicy;
    protected int pivot;
    protected boolean fromPivot;
    protected int examples;
    protected int exampleIndex;
    protected int fold;
    protected int lowerBound;
    protected int upperBound;
    protected int[] shuffled;
    protected int shuffleIndex;

    public FoldParser(Parser parser, int n, SplitPolicy splitPolicy, int n2, boolean bl) {
        this(parser, n, splitPolicy, n2, bl, -1);
    }

    public FoldParser(Parser parser, SplitPolicy splitPolicy, int n, boolean bl) {
        this(parser, -1, splitPolicy, n, bl, -1);
    }

    public FoldParser(Parser parser, int n, SplitPolicy splitPolicy, int n2, boolean bl, int n3) {
        Object object;
        this.K = n;
        this.splitPolicy = splitPolicy;
        this.fromPivot = bl;
        this.examples = n3;
        if (this.examples == -1 && (this.splitPolicy == SplitPolicy.sequential || this.splitPolicy == SplitPolicy.random)) {
            ++this.examples;
            object = parser.next();
            while (object != null) {
                if (object != FoldSeparator.separator) {
                    ++this.examples;
                }
                object = parser.next();
            }
            parser.reset();
        }
        if (this.splitPolicy == SplitPolicy.random) {
            int n4;
            this.shuffled = new int[this.examples];
            for (int i = 0; i < this.examples; ++i) {
                this.shuffled[i] = i;
            }
            object = new Random();
            for (n4 = 0; n4 < this.examples; ++n4) {
                int n5 = n4 + ((Random)object).nextInt(this.examples - n4);
                int n6 = this.shuffled[n4];
                this.shuffled[n4] = this.shuffled[n5];
                this.shuffled[n5] = n6;
            }
            for (n4 = 0; n4 < n; ++n4) {
                this.setPivot(n4);
                Arrays.sort(this.shuffled, this.lowerBound, this.upperBound);
            }
        }
        if (this.splitPolicy == SplitPolicy.manual) {
            this.K = 1;
            object = parser.next();
            while (object != null) {
                if (object == FoldSeparator.separator) {
                    ++this.K;
                }
                object = parser.next();
            }
            parser.reset();
        }
        this.setPivot(n2);
        this.parser = parser;
    }

    public int getK() {
        return this.K;
    }

    public void setFromPivot(boolean bl) {
        this.fromPivot = bl;
    }

    public void setPivot(int n) {
        this.pivot = n;
        if (n < this.K) {
            this.reset();
        }
    }

    public int getPivot() {
        return this.pivot;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void reset() {
        if (this.parser != null) {
            this.parser.reset();
        }
        if (this.splitPolicy == SplitPolicy.sequential || this.splitPolicy == SplitPolicy.random) {
            this.lowerBound = this.pivot * (this.examples / this.K) + Math.min(this.pivot, this.examples % this.K);
            this.upperBound = (this.pivot + 1) * (this.examples / this.K) + Math.min(this.pivot + 1, this.examples % this.K);
        }
        if (this.splitPolicy == SplitPolicy.random) {
            this.shuffleIndex = this.lowerBound;
        }
        if (this.splitPolicy == SplitPolicy.manual) {
            this.fold = 0;
        }
        this.exampleIndex = 0;
    }

    protected boolean filter(Object object) {
        if (object == FoldSeparator.separator) {
            return false;
        }
        if (this.splitPolicy == SplitPolicy.sequential) {
            return this.fromPivot == (this.exampleIndex >= this.lowerBound && this.exampleIndex < this.upperBound);
        }
        if (this.splitPolicy == SplitPolicy.random) {
            return this.fromPivot == (this.shuffleIndex < this.upperBound && this.shuffled[this.shuffleIndex] == this.exampleIndex);
        }
        if (this.splitPolicy == SplitPolicy.kth) {
            return this.fromPivot == (this.exampleIndex % this.K == this.pivot);
        }
        return this.fromPivot == (this.fold == this.pivot);
    }

    protected void increment(Object object) {
        if (object == FoldSeparator.separator) {
            if (this.splitPolicy == SplitPolicy.manual) {
                ++this.fold;
            }
        } else {
            if (this.splitPolicy == SplitPolicy.random && this.shuffleIndex < this.upperBound && this.shuffled[this.shuffleIndex] == this.exampleIndex) {
                ++this.shuffleIndex;
            }
            ++this.exampleIndex;
        }
    }

    public Object next() {
        Object object = this.parser.next();
        while (object != null && !this.filter(object)) {
            this.increment(object);
            object = this.parser.next();
        }
        if (object != null) {
            this.increment(object);
        }
        return object;
    }

    public void close() {
        this.parser.close();
    }

    public static class SplitPolicy {
        public static final SplitPolicy random = new SplitPolicy(0);
        public static final SplitPolicy sequential = new SplitPolicy(1);
        public static final SplitPolicy kth = new SplitPolicy(2);
        public static final SplitPolicy manual = new SplitPolicy(3);
        private static final String[] names = new String[]{"random", "sequential", "kth", "manual"};
        private int index;

        private SplitPolicy(int n) {
            this.index = n;
        }

        public String toString() {
            return names[this.index];
        }
    }
}

