/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.util;

import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.util.Arrays;

public class ByteString
implements Cloneable,
Comparable {
    public static final String defaultEncoding = "UTF-8";
    public static final ByteString emptyString = new ByteString("", "UTF-8");
    protected String encoding;
    protected byte[] value;
    protected int hashCode;

    protected void handleEncodingException(Exception exception) {
        System.err.println("ERROR: Encoding \"" + this.encoding + "\" is not supported.");
        exception.printStackTrace();
        System.exit(1);
    }

    public static ByteString readByteString(ExceptionlessInputStream exceptionlessInputStream) {
        ByteString byteString = new ByteString(false);
        byteString.read(exceptionlessInputStream);
        return byteString;
    }

    public static ByteString lexReadByteString(ExceptionlessInputStream exceptionlessInputStream, ByteString byteString) {
        ByteString byteString2 = new ByteString(false);
        byteString2.lexRead(exceptionlessInputStream, byteString);
        return byteString2;
    }

    protected ByteString(boolean bl) {
    }

    public ByteString() {
        this("");
    }

    public ByteString(String string) {
        this(string, null);
    }

    public ByteString(String string, String string2) {
        this.encoding = string2 == null ? defaultEncoding : string2.intern();
        this.setValue(string);
    }

    public ByteString(ByteString byteString, String string) {
        this.encoding = string.intern();
        if (byteString.encoding == this.encoding) {
            this.value = byteString.value;
            this.hashCode = byteString.hashCode;
        } else {
            this.setValue(byteString.toString());
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setValue(String string) {
        try {
            this.value = string.getBytes(this.encoding);
        }
        catch (Exception exception) {
            this.handleEncodingException(exception);
        }
        this.hashCode = string.hashCode();
    }

    public int length() {
        return this.value.length;
    }

    public byte getByte(int n) {
        return this.value[n];
    }

    public ByteString append(String string) {
        this.hashCode = (this.toString() + string).hashCode();
        byte[] byArray = null;
        try {
            byArray = string.getBytes(this.encoding);
        }
        catch (Exception exception) {
            this.handleEncodingException(exception);
        }
        byte[] byArray2 = new byte[this.value.length + byArray.length];
        System.arraycopy(this.value, 0, byArray2, 0, this.value.length);
        System.arraycopy(byArray, 0, byArray2, this.value.length, byArray.length);
        this.value = byArray2;
        return this;
    }

    public ByteString append(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        this.hashCode = stringBuffer.toString().hashCode();
        byte[][] byArrayArray = new byte[stringArray.length][];
        int n = 0;
        try {
            for (int i = 0; i < byArrayArray.length; ++i) {
                byArrayArray[i] = stringArray[i].getBytes(this.encoding);
                n += byArrayArray[i].length;
            }
        }
        catch (Exception exception) {
            this.handleEncodingException(exception);
        }
        byte[] byArray = new byte[n];
        n = this.value.length;
        System.arraycopy(this.value, 0, byArray, 0, n);
        for (int i = 0; i < byArrayArray.length; ++i) {
            System.arraycopy(byArrayArray[i], 0, byArray, n, byArrayArray[i].length);
            n += byArrayArray[i].length;
        }
        this.value = byArray;
        return this;
    }

    public ByteString append(ByteString byteString) {
        String string = byteString.toString();
        this.hashCode = (this.toString() + string).hashCode();
        if (this.encoding != byteString.encoding) {
            return this.append(string);
        }
        byte[] byArray = new byte[this.value.length + byteString.value.length];
        System.arraycopy(this.value, 0, byArray, 0, this.value.length);
        System.arraycopy(byteString.value, 0, byArray, this.value.length, byteString.value.length);
        this.value = byArray;
        return this;
    }

    public ByteString append(ByteString[] byteStringArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        for (int i = 0; i < byteStringArray.length; ++i) {
            String string = byteStringArray[i].toString();
            stringBuffer.append(string);
            if (this.encoding != byteStringArray[i].encoding) {
                byteStringArray[i] = new ByteString(string, this.encoding);
            }
            n += byteStringArray[i].value.length;
        }
        this.hashCode = stringBuffer.toString().hashCode();
        byte[] byArray = new byte[n];
        n = this.value.length;
        System.arraycopy(this.value, 0, byArray, 0, n);
        for (int i = 0; i < byteStringArray.length; ++i) {
            System.arraycopy(byteStringArray[i].value, 0, byArray, n, byteStringArray[i].value.length);
            n += byteStringArray[i].value.length;
        }
        this.value = byArray;
        return this;
    }

    public int compareTo(Object object) {
        if (!(object instanceof ByteString)) {
            return -1;
        }
        ByteString byteString = (ByteString)object;
        if (this.encoding != byteString.encoding) {
            return this.toString().compareTo(byteString.toString());
        }
        int n = this.value.length;
        int n2 = byteString.value.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            byte by = this.value[i];
            byte by2 = byteString.value[i];
            if (by == by2) continue;
            return by - by2;
        }
        return n - n2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return this.toString().equals(object);
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        ByteString byteString = (ByteString)object;
        if (this.encoding != byteString.encoding) {
            return this.toString().equals(byteString.toString());
        }
        if (this.value.length != byteString.value.length) {
            return false;
        }
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] == byteString.value[i]) continue;
            return false;
        }
        return true;
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        exceptionlessOutputStream.writeString(this.encoding);
        exceptionlessOutputStream.writeInt(this.hashCode);
        exceptionlessOutputStream.writeBytes(this.value);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.encoding = exceptionlessInputStream.readString().intern();
        this.hashCode = exceptionlessInputStream.readInt();
        this.value = exceptionlessInputStream.readBytes();
    }

    public void lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, ByteString byteString) {
        if (byteString != null && this.encoding == byteString.encoding && Arrays.equals(this.value, byteString.value)) {
            exceptionlessOutputStream.writeBytes(null);
        } else {
            exceptionlessOutputStream.writeBytes(this.value);
            exceptionlessOutputStream.writeInt(this.hashCode);
            exceptionlessOutputStream.writeString((String)(byteString != null && this.encoding == byteString.encoding ? null : this.encoding));
        }
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, ByteString byteString) {
        this.value = exceptionlessInputStream.readBytes();
        if (this.value == null) {
            this.value = byteString.value;
            this.hashCode = byteString.hashCode;
            this.encoding = byteString.encoding;
        } else {
            this.hashCode = exceptionlessInputStream.readInt();
            this.encoding = exceptionlessInputStream.readString();
            this.encoding = this.encoding == null ? byteString.encoding : this.encoding.intern();
        }
    }

    public String toString() {
        try {
            return new String(this.value, this.encoding);
        }
        catch (Exception exception) {
            this.handleEncodingException(exception);
            return null;
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            System.err.println("Can't clone byte string '" + this + "':");
            exception.printStackTrace();
        }
        return object;
    }
}

