/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.util;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ExceptionlessOutputStream
extends FilterOutputStream {
    private byte[] buffer = null;
    private DataOutputStream dos = (DataOutputStream)this.out;

    public static ExceptionlessOutputStream openBufferedStream(String string) {
        ExceptionlessOutputStream exceptionlessOutputStream = null;
        try {
            exceptionlessOutputStream = new ExceptionlessOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + string + "' for output:");
            exception.printStackTrace();
            System.exit(1);
        }
        return exceptionlessOutputStream;
    }

    public static ExceptionlessOutputStream openCompressedStream(String string) {
        ExceptionlessOutputStream exceptionlessOutputStream = null;
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            zipOutputStream.putNextEntry(new ZipEntry("LBJFile"));
            exceptionlessOutputStream = new ExceptionlessOutputStream(new BufferedOutputStream(zipOutputStream));
        }
        catch (Exception exception) {
            System.err.println("Can't open '" + string + "' for output:");
            exception.printStackTrace();
            System.exit(1);
        }
        return exceptionlessOutputStream;
    }

    public static ExceptionlessOutputStream openBufferedStream(URL uRL) {
        if (!uRL.getProtocol().equals("file")) {
            System.err.println("Can't open URL with protocol '" + uRL.getProtocol() + "' for output.");
            new Exception().printStackTrace();
            System.exit(1);
        }
        return ExceptionlessOutputStream.openBufferedStream(uRL.getFile());
    }

    public static ExceptionlessOutputStream openCompressedStream(URL uRL) {
        if (!uRL.getProtocol().equals("file")) {
            System.err.println("Can't open URL with protocol '" + uRL.getProtocol() + "' for output.");
            new Exception().printStackTrace();
            System.exit(1);
        }
        return ExceptionlessOutputStream.openCompressedStream(uRL.getFile());
    }

    public ExceptionlessOutputStream(OutputStream outputStream) {
        super(new DataOutputStream(outputStream));
    }

    private void handleException(Exception exception) {
        System.err.println("Can't write to output stream:");
        exception.printStackTrace();
        this.close();
        System.exit(1);
    }

    public void close() {
        try {
            this.dos.close();
        }
        catch (Exception exception) {
            System.err.println("Can't close output stream:");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void writeBoolean(boolean bl) {
        try {
            this.dos.writeBoolean(bl);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void writeByte(int n) {
        try {
            this.dos.writeByte(n);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void writeBytes(byte[] byArray) {
        try {
            if (byArray == null) {
                this.dos.writeInt(-1);
                return;
            }
            int n = byArray.length;
            this.dos.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.dos.writeByte(byArray[i]);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void writeShort(int n) {
        try {
            this.dos.writeShort(n);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void writeChar(int n) {
        try {
            this.dos.writeChar(n);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void writeInt(int n) {
        try {
            this.dos.writeInt(n);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void writeLong(long l) {
        try {
            this.dos.writeLong(l);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void writeFloat(float f) {
        try {
            this.dos.writeFloat(f);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void writeDouble(double d) {
        try {
            this.dos.writeDouble(d);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void writeString(String string) {
        if (string == null) {
            this.writeShort(-1);
        } else {
            this.writeUTF(string);
        }
    }

    public int writeUTF(String string) {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > Short.MAX_VALUE) {
            System.err.println("Error in ExceptionlessOutputStream: String too long");
            new Exception().printStackTrace();
            this.close();
            System.exit(1);
        }
        if (this.buffer == null || this.buffer.length < n3) {
            this.buffer = new byte[n3 * 2];
        }
        this.writeShort((short)n3);
        n = 0;
        for (n = 0; n < n2 && (c = string.charAt(n)) >= '\u0001' && c <= '\u007f'; ++n) {
            this.buffer[n4++] = (byte)c;
        }
        while (n < n2) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer[n4++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buffer[n4++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[n4++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                this.buffer[n4++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buffer[n4++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n;
        }
        try {
            this.dos.write(this.buffer, 0, n3);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return n3 + 2;
    }
}

