/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.util;

import LBJ2.classify.Feature;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class FVector
implements Cloneable,
Serializable {
    protected static final int defaultCapacity = 8;
    protected Feature[] vector;
    protected int size;

    public FVector() {
        this(8);
    }

    public FVector(int n) {
        this.vector = new Feature[Math.max(8, n)];
    }

    public FVector(Feature[] featureArray) {
        if (featureArray.length == 0) {
            this.vector = new Feature[8];
        } else {
            this.vector = featureArray;
            this.size = this.vector.length;
        }
    }

    public FVector(FVector fVector) {
        int n = fVector.size();
        if (n == 0) {
            this.vector = new Feature[8];
        } else {
            this.vector = new Feature[n];
            this.size = n;
            System.arraycopy(fVector.vector, 0, this.vector, 0, n);
        }
    }

    protected void boundsCheck(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempted to access negative index of FVector.");
        }
    }

    public Feature get(int n) {
        return this.get(n, null);
    }

    public Feature get(int n, Feature feature) {
        this.boundsCheck(n);
        return n < this.size ? this.vector[n] : feature;
    }

    public Feature set(int n, Feature feature) {
        return this.set(n, feature, null);
    }

    public Feature set(int n, Feature feature, Feature feature2) {
        this.boundsCheck(n);
        this.expandFor(n, feature2);
        Feature feature3 = this.vector[n];
        this.vector[n] = feature;
        return feature3;
    }

    public void add(Feature feature) {
        this.expandFor(this.size, null);
        this.vector[this.size - 1] = feature;
    }

    public void addAll(FVector fVector) {
        this.expandFor(this.size + fVector.size - 1, null);
        System.arraycopy(fVector.vector, 0, this.vector, this.size - fVector.size, fVector.size);
    }

    public Feature remove(int n) {
        this.boundsCheck(n);
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("LBJ: FVector: Can't remove element at index " + n + " as it is larger than the size (" + this.size + ")");
        }
        Feature feature = this.vector[n];
        for (int i = n + 1; i < this.size; ++i) {
            this.vector[i - 1] = this.vector[i];
        }
        this.vector[--this.size] = null;
        return feature;
    }

    public int size() {
        return this.size;
    }

    public void sort() {
        Arrays.sort(this.vector, 0, this.size);
    }

    public void consolidate() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.size && this.vector[n2] != null; ++n2) {
        }
        for (n = n2; n < this.size && this.vector[n] == null; ++n) {
        }
        while (n < this.size) {
            this.vector[n2++] = this.vector[n++];
            while (n < this.size && this.vector[n] == null) {
                ++n;
            }
        }
        if (n2 < this.vector.length) {
            this.size = n2;
            Feature[] featureArray = new Feature[this.size];
            System.arraycopy(this.vector, 0, featureArray, 0, this.size);
            this.vector = featureArray;
        }
    }

    protected void expandFor(int n, Feature feature) {
        int n2;
        if (n < this.size) {
            return;
        }
        int n3 = this.size;
        this.size = n + 1;
        if (n2 >= this.size) {
            return;
        }
        for (n2 = this.vector.length; n2 < this.size; n2 *= 2) {
        }
        Object[] objectArray = new Feature[n2];
        System.arraycopy(this.vector, 0, objectArray, 0, n3);
        if (feature != null) {
            Arrays.fill(objectArray, n3, this.size, feature);
        }
        this.vector = objectArray;
    }

    public Feature[] toArray() {
        Feature[] featureArray = new Feature[this.size];
        System.arraycopy(this.vector, 0, featureArray, 0, this.size);
        return featureArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FVector)) {
            return false;
        }
        FVector fVector = (FVector)object;
        return this.size == fVector.size && Arrays.equals(this.vector, fVector.vector);
    }

    public int hashCode() {
        return this.vector.hashCode();
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        exceptionlessOutputStream.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.vector[i].write(exceptionlessOutputStream);
        }
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        this.size = exceptionlessInputStream.readInt();
        if (this.size == 0) {
            this.vector = new Feature[8];
        } else {
            this.vector = new Feature[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.vector[i] = Feature.readFeature(exceptionlessInputStream);
            }
        }
    }

    public Object clone() {
        FVector fVector = null;
        try {
            fVector = (FVector)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning " + this.getClass().getName() + ":");
            exception.printStackTrace();
            System.exit(1);
        }
        fVector.vector = (Feature[])this.vector.clone();
        return fVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.vector[i]);
            if (i + 1 >= this.size) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

