/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class OVector
implements Cloneable,
Serializable {
    protected static final int defaultCapacity = 8;
    protected Object[] vector;
    protected int size;

    public OVector() {
        this(8);
    }

    public OVector(int n) {
        this.vector = new Object[Math.max(8, n)];
    }

    public OVector(Object[] objectArray) {
        if (objectArray.length == 0) {
            this.vector = new Object[8];
        } else {
            this.vector = objectArray;
            this.size = this.vector.length;
        }
    }

    public OVector(OVector oVector) {
        int n = oVector.size();
        if (n == 0) {
            this.vector = new Object[8];
        } else {
            this.vector = new Object[n];
            this.size = n;
            System.arraycopy(oVector.vector, 0, this.vector, 0, n);
        }
    }

    protected void boundsCheck(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempted to access negative index of OVector.");
        }
    }

    public Object get(int n) {
        return this.get(n, null);
    }

    public Object get(int n, Object object) {
        this.boundsCheck(n);
        return n < this.size ? this.vector[n] : object;
    }

    public Object set(int n, Object object) {
        return this.set(n, object, null);
    }

    public Object set(int n, Object object, Object object2) {
        this.boundsCheck(n);
        this.expandFor(n, object2);
        Object object3 = this.vector[n];
        this.vector[n] = object;
        return object3;
    }

    public void add(Object object) {
        this.expandFor(this.size, null);
        this.vector[this.size - 1] = object;
    }

    public void addAll(OVector oVector) {
        this.expandFor(this.size + oVector.size - 1, null);
        System.arraycopy(oVector.vector, 0, this.vector, this.size - oVector.size, oVector.size);
    }

    public Object remove(int n) {
        this.boundsCheck(n);
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("LBJ: OVector: Can't remove element at index " + n + " as it is larger than the size (" + this.size + ")");
        }
        Object object = this.vector[n];
        for (int i = n + 1; i < this.size; ++i) {
            this.vector[i - 1] = this.vector[i];
        }
        this.vector[--this.size] = null;
        return object;
    }

    public int size() {
        return this.size;
    }

    public void sort(Comparator comparator) {
        Arrays.sort(this.vector, 0, this.size, comparator);
    }

    protected void expandFor(int n, Object object) {
        int n2;
        if (n < this.size) {
            return;
        }
        int n3 = this.size;
        this.size = n + 1;
        if (n2 >= this.size) {
            return;
        }
        for (n2 = this.vector.length; n2 < this.size; n2 *= 2) {
        }
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.vector, 0, objectArray, 0, n3);
        if (object != null) {
            Arrays.fill(objectArray, n3, this.size, object);
        }
        this.vector = objectArray;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.vector, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OVector)) {
            return false;
        }
        OVector oVector = (OVector)object;
        return this.size == oVector.size && Arrays.equals(this.vector, oVector.vector);
    }

    public int hashCode() {
        return this.vector.hashCode();
    }

    public Object clone() {
        OVector oVector = null;
        try {
            oVector = (OVector)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning " + this.getClass().getName() + ":");
            exception.printStackTrace();
            System.exit(1);
        }
        oVector.vector = (Object[])this.vector.clone();
        return oVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.vector[i]);
            if (i + 1 >= this.size) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

