/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.util;

public class StudentT {
    public static final double FPMIN = 1.0E-300;
    private static int lgfN = 6;
    private static double[] lgfCoeff = new double[]{1.000000000190015, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static double lgfGamma = 5.0;

    public static double sign(double d) {
        if (d < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static double factorial(double d) {
        if (d < 0.0 || d - Math.floor(d) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double d2 = 1.0;
        for (double d3 = 2.0; d3 <= d; d3 += 1.0) {
            d2 *= d3;
        }
        return d2;
    }

    public static double logFactorial(double d) {
        if (d < 0.0 || d - Math.floor(d) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double d2 = 0.0;
        for (double d3 = 2.0; d3 <= d; d3 += 1.0) {
            d2 += Math.log(d3);
        }
        return d2;
    }

    public static double gamma(double d) {
        double d2 = d;
        double d3 = d + lgfGamma + 0.5;
        double d4 = lgfCoeff[0];
        double d5 = 0.0;
        if (d >= 0.0) {
            if (d >= 1.0 && d - (double)((int)d) == 0.0) {
                d5 = StudentT.factorial(d) / d;
            } else {
                d3 = Math.pow(d3, d + 0.5) * Math.exp(-d3);
                for (int i = 1; i <= lgfN; ++i) {
                    d4 += lgfCoeff[i] / (d2 += 1.0);
                }
                d5 = d3 * Math.sqrt(Math.PI * 2) * d4 / d;
            }
        } else {
            d5 = -Math.PI / (d * StudentT.gamma(-d) * Math.sin(Math.PI * d));
        }
        return d5;
    }

    public static double logGamma(double d) {
        double d2 = d;
        double d3 = 0.0;
        double d4 = d + lgfGamma + 0.5;
        double d5 = lgfCoeff[0];
        if (d >= 0.0) {
            if (d >= 1.0 && d - (double)((int)d) == 0.0) {
                d3 = StudentT.logFactorial(d) - Math.log(d);
            } else {
                d4 -= (d + 0.5) * Math.log(d4);
                for (int i = 1; i <= lgfN; ++i) {
                    d5 += lgfCoeff[i] / (d2 += 1.0);
                }
                d3 = Math.log(Math.sqrt(Math.PI * 2) * d5 / d) - d4;
            }
        } else {
            d3 = Math.PI / (StudentT.gamma(1.0 - d) * Math.sin(Math.PI * d));
            if (d3 != Double.POSITIVE_INFINITY && d3 != Double.NEGATIVE_INFINITY) {
                if (d3 < 0.0) {
                    throw new IllegalArgumentException("\nThe gamma function is negative");
                }
                d3 = Math.log(d3);
            }
        }
        return d3;
    }

    public static double contFract(double d, double d2, double d3) {
        int n = 500;
        double d4 = 3.0E-7;
        double d5 = d + d2;
        double d6 = d + 1.0;
        double d7 = d - 1.0;
        double d8 = 1.0;
        double d9 = 1.0 - d5 * d3 / d6;
        if (Math.abs(d9) < 1.0E-300) {
            d9 = 1.0E-300;
        }
        double d10 = d9 = 1.0 / d9;
        double d11 = 0.0;
        double d12 = 0.0;
        int n2 = 1;
        int n3 = 0;
        boolean bl = true;
        while (bl) {
            n3 = 2 * n2;
            d11 = (double)n2 * (d2 - (double)n2) * d3 / ((d7 + (double)n3) * (d + (double)n3));
            if (Math.abs(d9 = 1.0 + d11 * d9) < 1.0E-300) {
                d9 = 1.0E-300;
            }
            if (Math.abs(d8 = 1.0 + d11 / d8) < 1.0E-300) {
                d8 = 1.0E-300;
            }
            d9 = 1.0 / d9;
            d10 *= d9 * d8;
            d11 = -(d + (double)n2) * (d5 + (double)n2) * d3 / ((d + (double)n3) * (d6 + (double)n3));
            if (Math.abs(d9 = 1.0 + d11 * d9) < 1.0E-300) {
                d9 = 1.0E-300;
            }
            if (Math.abs(d8 = 1.0 + d11 / d8) < 1.0E-300) {
                d8 = 1.0E-300;
            }
            d9 = 1.0 / d9;
            d12 = d9 * d8;
            d10 *= d12;
            ++n2;
            if (Math.abs(d12 - 1.0) < d4) {
                bl = false;
            }
            if (n2 <= n) continue;
            bl = false;
            System.out.println("Maximum number of iterations (" + n + ") exceeded in Stat.contFract in Stat.incomplete Beta");
        }
        return d10;
    }

    public static double regularisedBetaFunction(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("Argument x, " + d3 + ", must be lie between 0 and 1 (inclusive)");
        }
        double d4 = 0.0;
        if (d3 == 0.0) {
            d4 = 0.0;
        } else if (d3 == 1.0) {
            d4 = 1.0;
        } else {
            d4 = Math.exp(StudentT.logGamma(d + d2) - StudentT.logGamma(d) - StudentT.logGamma(d2) + d * Math.log(d3) + d2 * Math.log(1.0 - d3));
            d4 = d3 < (d + 1.0) / (d + d2 + 2.0) ? d4 * StudentT.contFract(d, d2, d3) / d : 1.0 - d4 * StudentT.contFract(d2, d, 1.0 - d3) / d2;
        }
        return d4;
    }

    public static double studentTcdf(double d, int n) {
        double d2 = n;
        double d3 = d2 / (d2 + d * d);
        return 0.5 * (1.0 + (StudentT.regularisedBetaFunction(d2 / 2.0, 0.5, 1.0) - StudentT.regularisedBetaFunction(d2 / 2.0, 0.5, d3)) * StudentT.sign(d));
    }

    public static double tTable(int n, double d) {
        double d2 = 1.0 - d / 2.0;
        double d3 = 700.0;
        double d4 = -700.0;
        boolean bl = false;
        while (!bl) {
            double d5 = (d3 + d4) / 2.0;
            if (StudentT.studentTcdf(d5, n) < d2) {
                bl = d4 == d5;
                d4 = d5;
                continue;
            }
            bl = d3 == d5;
            d3 = d5;
        }
        return (d3 + d4) / 2.0;
    }

    public static double[] confidenceInterval(double[] dArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i];
        }
        d2 /= (double)dArray.length;
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d4 = dArray[i] - d2;
            d3 += d4 * d4;
        }
        d3 /= (double)(dArray.length - 1);
        d3 = Math.sqrt(d3);
        double d5 = d3 / Math.sqrt(dArray.length);
        double d6 = StudentT.tTable(dArray.length - 1, d);
        return new double[]{d2, d6 * d5};
    }
}

