/*
 * Decompiled with CFR 0.152.
 */
package SoftwareVersionExtractor;

import LBJ2.nlp.SentenceSplitter;
import LBJ2.nlp.WordSplitter;
import LBJ2.nlp.seg.PlainToTokenParser;
import LBJ2.nlp.seg.Token;
import SoftwareVersionExtractor.GazetteObject;
import SoftwareVersionExtractor.NGramToken;
import SoftwareVersionExtractor.ResultObject;
import edu.illinois.cs.cogcomp.lbj.chunk.Chunker;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tagger {
    ArrayList<ArrayList<NGramToken>> TotalNGrams = new ArrayList();
    ArrayList<Integer> scores = new ArrayList();
    final String gazettePath = "sw_os_db.csv";
    ArrayList<GazetteObject> gazetteer = new ArrayList();
    static ArrayList<String> NPsets = new ArrayList();
    static TreeSet<Integer> VPindexes = new TreeSet();
    static String passage = "";

    public static List<String> ngrams(int n, String str) {
        ArrayList<String> ngrams = new ArrayList<String>();
        String[] words = str.split(" ");
        int i = 0;
        while (i < words.length - n + 1) {
            ngrams.add(Tagger.concat(words, i, i + n));
            ++i;
        }
        return ngrams;
    }

    public static String concat(String[] words, int start, int end) {
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i < end) {
            sb.append(String.valueOf(i > start ? " " : "") + words[i]);
            ++i;
        }
        return sb.toString();
    }

    public void createGazette() {
        String input = "";
        try {
            if (!"sw_os_db.csv".isEmpty()) {
                FileInputStream fis = new FileInputStream("sw_os_db.csv");
                DataInputStream dis = new DataInputStream(fis);
                BufferedReader br = new BufferedReader(new InputStreamReader(dis));
                while ((input = br.readLine()) != null) {
                    String[] tokens = input.split(",");
                    GazetteObject go = new GazetteObject(tokens[0], tokens[1]);
                    this.gazetteer.add(go);
                }
                br.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public GazetteObject isEntryInGazette(String text) {
        int i = 0;
        while (i < this.gazetteer.size()) {
            GazetteObject go = this.gazetteer.get(i);
            if (go.value.contains(text)) {
                return go;
            }
            ++i;
        }
        return null;
    }

    public static void tagger_NY(String filename) {
        Chunker tagger = new Chunker();
        PlainToTokenParser parser = new PlainToTokenParser(new WordSplitter(new SentenceSplitter(filename)));
        Token w = (Token)parser.next();
        String fullSet = "";
        while (w != null) {
            String tag = tagger.discreteValue(w);
            String set = w.toString();
            String[] setSplit = set.split(" ");
            String word = setSplit[2].substring(0, setSplit[2].length() - 1);
            if (tag.contains("B") && !fullSet.isEmpty()) {
                if (tag.contains("NP")) {
                    if (NPsets.size() == 0) {
                        NPsets.add(fullSet);
                        fullSet = "";
                    } else {
                        int thatSize = NPsets.get(NPsets.size() - 1).trim().split(" ").length;
                        if (thatSize != 1) {
                            NPsets.add(fullSet);
                            fullSet = "";
                        } else {
                            String what = NPsets.get(NPsets.size() - 1);
                            what = String.valueOf(what) + fullSet;
                            NPsets.set(NPsets.size() - 1, what);
                            fullSet = "";
                        }
                    }
                } else if (tag.contains("VP")) {
                    VPindexes.add(passage.indexOf(word));
                }
            }
            fullSet = String.valueOf(fullSet) + " " + word;
            w = (Token)parser.next();
        }
        NPsets.add(fullSet);
    }

    private static void readFromFileAB(String input_filename) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(input_filename));
        while ((line = br.readLine()) != null) {
            passage = String.valueOf(passage) + line;
        }
        br.close();
    }

    public void writeResultToFile(Map<String, ResultObject> list) throws IOException {
        String softwares = "";
        String versions = "";
        int endInd = 0;
        int startInd = Integer.MAX_VALUE;
        int nextVPInd = -1;
        for (String name : list.keySet()) {
            String[] out2;
            int sem;
            int tempStartInd;
            String key = name.toString();
            ResultObject ro = list.get(key);
            if (ro.type.contains("Version")) {
                for (String checkNP : NPsets) {
                    if (!checkNP.contains(ro.value)) continue;
                    tempStartInd = passage.indexOf(checkNP);
                    if (tempStartInd < startInd) {
                        startInd = tempStartInd;
                        nextVPInd = VPindexes.higher(startInd);
                    }
                    if ((sem = passage.indexOf((out2 = checkNP.split(" "))[out2.length - 1]) + out2[out2.length - 1].length()) > nextVPInd) {
                        endInd = nextVPInd;
                        break;
                    }
                    if (sem <= endInd) continue;
                    endInd = sem;
                }
                if (versions.isEmpty()) {
                    versions = String.valueOf(versions) + ro.value;
                    continue;
                }
                versions = String.valueOf(versions) + " and " + ro.value;
                continue;
            }
            for (String checkNP : NPsets) {
                if (!checkNP.contains(ro.value)) continue;
                tempStartInd = passage.indexOf(checkNP);
                if (tempStartInd < startInd) {
                    startInd = tempStartInd;
                    nextVPInd = VPindexes.higher(startInd);
                }
                if ((sem = passage.indexOf((out2 = checkNP.split(" "))[out2.length - 1]) + out2[out2.length - 1].length()) > nextVPInd) {
                    endInd = sem;
                    break;
                }
                if (sem <= endInd) continue;
                endInd = sem;
            }
            softwares = softwares.isEmpty() ? String.valueOf(softwares) + ro.value : String.valueOf(softwares) + " and " + ro.value;
        }
        System.out.println("\n");
        System.out.println("\nSoftwares: " + softwares);
        System.out.println("\nversions: " + versions);
    }

    public ArrayList<String> readVulnerabilityDescription(String filename) {
        ArrayList<String> desc = new ArrayList<String>();
        String input = "";
        try {
            if (!filename.isEmpty()) {
                FileInputStream fis = new FileInputStream(filename);
                DataInputStream dis = new DataInputStream(fis);
                BufferedReader br = new BufferedReader(new InputStreamReader(dis));
                while ((input = br.readLine()) != null) {
                    desc.add(input);
                }
                br.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return desc;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Tagger.readFromFileAB("text");
        Tagger.tagger_NY("text");
        Tagger.software();
    }

    public static void software() throws IOException, ClassNotFoundException {
        String infile = "text";
        Tagger tag = new Tagger();
        ArrayList<ResultObject> results = new ArrayList<ResultObject>();
        ArrayList<String> desc = tag.readVulnerabilityDescription(infile);
        boolean success = false;
        MaxentTagger tagger = new MaxentTagger("bidirectional-distsim-wsj-0-18.tagger");
        int a = 0;
        while (a < desc.size()) {
            String search;
            ArrayList<NGramToken> ngramTok;
            String sample = desc.get(a);
            String tagged = tagger.tagString(sample);
            tag.createGazette();
            int n = 3;
            while (n <= 3) {
                for (String ngram : Tagger.ngrams(n, tagged)) {
                    String[] tokens = ngram.split(" ");
                    ArrayList<NGramToken> NGramTokenList = new ArrayList<NGramToken>();
                    int i = 0;
                    while (i < tokens.length) {
                        String[] tok = tokens[i].split("/");
                        NGramToken ntok = new NGramToken(tok[0], tok[1]);
                        NGramTokenList.add(ntok);
                        ++i;
                    }
                    tag.TotalNGrams.add(NGramTokenList);
                }
                ++n;
            }
            int i = 0;
            while (i < tag.TotalNGrams.size()) {
                ResultObject ro;
                String search2;
                String str;
                GazetteObject go;
                String str2;
                GazetteObject go2;
                ArrayList<NGramToken> ngramTok2 = tag.TotalNGrams.get(i);
                String search3 = String.valueOf(ngramTok2.get((int)0).value) + " " + ngramTok2.get((int)1).value + " " + ngramTok2.get((int)2).value;
                if (ngramTok2.get((int)0).posTag.equalsIgnoreCase("NNP") && ngramTok2.get((int)1).posTag.equalsIgnoreCase("NNP") && ngramTok2.get((int)2).posTag.equalsIgnoreCase("NNP") && (go2 = tag.isEntryInGazette(str2 = search3.replaceAll("\\p{Punct}|\\d", ""))) != null) {
                    ResultObject ro2 = new ResultObject(go2.type, str2);
                    results.add(ro2);
                    success = true;
                }
                if (ngramTok2.get((int)0).posTag.equalsIgnoreCase("NNP") && ngramTok2.get((int)1).posTag.equalsIgnoreCase("NNP") && !ngramTok2.get((int)2).posTag.equalsIgnoreCase("NNP") && (go = tag.isEntryInGazette(str = (search2 = String.valueOf(ngramTok2.get((int)0).value) + " " + ngramTok2.get((int)1).value).replaceAll("\\p{Punct}|\\d", ""))) != null) {
                    ro = new ResultObject(go.type, str);
                    results.add(ro);
                    success = true;
                }
                if (ngramTok2.get((int)0).posTag.equalsIgnoreCase("NNP")) {
                    if (ngramTok2.get((int)1).posTag.equalsIgnoreCase("IN") && (go = tag.isEntryInGazette(str = (search2 = ngramTok2.get((int)0).value).replaceAll("\\p{Punct}|\\d", ""))) != null) {
                        ro = new ResultObject(go.type, str);
                        results.add(ro);
                        success = true;
                    }
                } else if (ngramTok2.get((int)1).posTag.equalsIgnoreCase("NNP")) {
                    if (ngramTok2.get((int)0).posTag.equalsIgnoreCase("IN") && ngramTok2.get((int)2).posTag.equalsIgnoreCase("IN") && (go = tag.isEntryInGazette(str = (search2 = ngramTok2.get((int)1).value).replaceAll("\\p{Punct}|\\d", ""))) != null) {
                        ro = new ResultObject(go.type, str);
                        results.add(ro);
                        success = true;
                    }
                } else if (ngramTok2.get((int)1).posTag.equalsIgnoreCase("NNP")) {
                    if (ngramTok2.get((int)0).posTag.equalsIgnoreCase("IN") && ngramTok2.get((int)2).posTag.equalsIgnoreCase("CD") && (go = tag.isEntryInGazette(str = (search2 = ngramTok2.get((int)1).value).replaceAll("\\p{Punct}|\\d", ""))) != null) {
                        ro = new ResultObject(go.type, str);
                        results.add(ro);
                        success = true;
                    }
                } else if (ngramTok2.get((int)0).posTag.equalsIgnoreCase("NNP")) {
                    if (ngramTok2.get((int)1).posTag.equalsIgnoreCase("CD") && (go = tag.isEntryInGazette(str = (search2 = ngramTok2.get((int)0).value).replaceAll("\\p{Punct}|\\d", ""))) != null) {
                        ro = new ResultObject(go.type, str);
                        results.add(ro);
                        success = true;
                    }
                } else if (ngramTok2.get((int)1).posTag.equalsIgnoreCase("NNP") && ngramTok2.get((int)2).posTag.equalsIgnoreCase("CD") && (go = tag.isEntryInGazette(str = (search2 = ngramTok2.get((int)1).value).replaceAll("\\p{Punct}|\\d", ""))) != null) {
                    ro = new ResultObject(go.type, str);
                    results.add(ro);
                    success = true;
                }
                ++i;
            }
            ArrayList<String> list = new ArrayList<String>();
            if (!success) {
                int i2 = 0;
                while (i2 < tag.TotalNGrams.size()) {
                    Pattern p;
                    Matcher m;
                    ngramTok = tag.TotalNGrams.get(i2);
                    search = String.valueOf(ngramTok.get((int)0).value) + " " + ngramTok.get((int)1).value + " " + ngramTok.get((int)2).value;
                    if (ngramTok.get((int)0).posTag.equalsIgnoreCase("NNP") && ngramTok.get((int)1).posTag.equalsIgnoreCase("NNP") && ngramTok.get((int)2).posTag.equalsIgnoreCase("NNP") && (m = (p = Pattern.compile("(\\p{Lu}[\\p{L} ]+)(\\d+[\\.]?\\d+)*|[\\S&&[^.]]+")).matcher(search)).find()) {
                        list.add(m.group());
                    }
                    if (ngramTok.get((int)0).posTag.equalsIgnoreCase("NNP")) {
                        if (ngramTok.get((int)1).posTag.equalsIgnoreCase("CD") && (m = (p = Pattern.compile("(\\p{Lu}[\\p{L} ]+)(\\d+[\\.]?\\d+)*|[\\S&&[^.]]+")).matcher(ngramTok.get((int)0).value)).find()) {
                            list.add(m.group());
                        }
                    } else if (ngramTok.get((int)1).posTag.equalsIgnoreCase("NNP") && ngramTok.get((int)2).posTag.equalsIgnoreCase("CD") && (m = (p = Pattern.compile("(\\p{Lu}[\\p{L} ]+)(\\d+[\\.]?\\d+)*|[\\S&&[^.]]+")).matcher(ngramTok.get((int)1).value)).find()) {
                        list.add(m.group());
                    }
                    ++i2;
                }
                if (list.size() > 0) {
                    ResultObject ro = new ResultObject("Software", (String)list.get(0));
                    results.add(ro);
                }
            }
            int i3 = 0;
            while (i3 < tag.TotalNGrams.size()) {
                ngramTok = tag.TotalNGrams.get(i3);
                search = String.valueOf(ngramTok.get((int)0).value) + " " + ngramTok.get((int)1).value + " " + ngramTok.get((int)2).value;
                if (!search.contains("RRB") && !search.contains("LRB")) {
                    search.replaceAll("\\p{Punct}", "");
                    int j = 0;
                    while (j < ngramTok.size()) {
                        if (ngramTok.get((int)j).posTag.equalsIgnoreCase("CD")) {
                            ResultObject ro = new ResultObject("Version", ngramTok.get((int)j).value);
                            results.add(ro);
                        }
                        ++j;
                    }
                }
                ++i3;
            }
            ++a;
        }
        LinkedHashMap<String, ResultObject> map = new LinkedHashMap<String, ResultObject>();
        int i = 0;
        while (i < results.size()) {
            ResultObject ro = (ResultObject)results.get(i);
            map.put(ro.value, ro);
            ++i;
        }
        tag.writeResultToFile(map);
    }
}

