/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.cs.cogcomp.lbj.pos;

import LBJ2.classify.LabelVectorReturner;
import LBJ2.classify.TestDiscrete;
import LBJ2.nlp.seg.POSBracketToToken;
import LBJ2.nlp.seg.Token;
import LBJ2.parse.FeatureVectorParser;
import edu.illinois.cs.cogcomp.lbj.pos.POSLabel;
import edu.illinois.cs.cogcomp.lbj.pos.POSTagger;
import edu.illinois.cs.cogcomp.lbj.pos.POSTaggerKnown;
import edu.illinois.cs.cogcomp.lbj.pos.POSTaggerUnknown;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;

public class LearningCurveMIRA {
    static final POSLabel labeler = new POSLabel();
    static final LabelVectorReturner lvr = new LabelVectorReturner(){

        @Override
        public String getOutputType() {
            return "discrete";
        }

        @Override
        public String[] allowableValues() {
            return labeler.allowableValues();
        }

        @Override
        public String discreteValue(Object object) {
            return this.classify(object).firstFeature().getStringValue();
        }
    };

    public static void main(String[] stringArray) {
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
            if (n < 1 || stringArray.length > 1) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            System.err.println("usage: java edu.illinois.cs.cogcomp.lbj.pos.LearningCurveMIRA <rounds>");
            System.exit(1);
        }
        POSTagger pOSTagger = new POSTagger();
        POSTaggerKnown pOSTaggerKnown = new POSTaggerKnown();
        POSTaggerUnknown pOSTaggerUnknown = new POSTaggerUnknown();
        pOSTaggerKnown.setLabeler(lvr);
        pOSTaggerUnknown.setLabeler(lvr);
        FeatureVectorParser featureVectorParser = new FeatureVectorParser("lbj/LBJ2/nlp/pos/POSTaggerKnown.ex", "lbj/LBJ2/nlp/pos/POSTaggerKnown.lex");
        FeatureVectorParser featureVectorParser2 = new FeatureVectorParser("lbj/LBJ2/nlp/pos/POSTaggerUnknown.ex", "lbj/LBJ2/nlp/pos/POSTaggerUnknown.lex");
        POSBracketToToken pOSBracketToToken = new POSBracketToToken("/shared/grandpa/corpora/POS/22-24.br");
        double d = 0.0;
        int n2 = 0;
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream("curves/curve_MIRA"));
        }
        catch (Exception exception) {
            System.err.println("Can't open curves/curve_MIRA for output: " + exception);
            System.exit(1);
        }
        pOSTaggerKnown.forget();
        pOSTaggerUnknown.forget();
        for (int i = 0; i < n; ++i) {
            POSTaggerKnown.isTraining = true;
            Object object = featureVectorParser.next();
            while (object != null) {
                pOSTaggerKnown.learn(object);
                object = featureVectorParser.next();
            }
            POSTaggerKnown.isTraining = false;
            POSTaggerUnknown.isTraining = true;
            object = featureVectorParser2.next();
            while (object != null) {
                pOSTaggerUnknown.learn(object);
                object = featureVectorParser2.next();
            }
            POSTaggerUnknown.isTraining = false;
            object = new TestDiscrete();
            TestDiscrete testDiscrete = new TestDiscrete();
            Token token = (Token)pOSBracketToToken.next();
            while (token != null) {
                String string = "" + pOSTaggerKnown.discreteValue(token);
                token.partOfSpeech = null;
                String string2 = "" + pOSTagger.discreteValue(token);
                String string3 = "" + labeler.discreteValue(token);
                ((TestDiscrete)object).reportPrediction(string2, string3);
                testDiscrete.reportPrediction(string, string3);
                token = (Token)pOSBracketToToken.next();
            }
            double d2 = testDiscrete.getOverallStats()[2];
            double d3 = ((TestDiscrete)object).getOverallStats()[2];
            printStream.println(i + 1 + "  " + d2 + "  " + d3);
            if (d3 > d) {
                d = d3;
                n2 = i + 1;
                pOSTaggerKnown.save();
                pOSTaggerUnknown.save();
            }
            if ((i + 1) % 5 == 0) {
                System.out.println(i + 1 + " rounds.  Best so far: (" + n2 + ") " + d + " at " + new Date());
            }
            featureVectorParser.reset();
            featureVectorParser2.reset();
            pOSBracketToToken.reset();
        }
        printStream.close();
        System.out.println("\nBest overall:");
        System.out.println("  Rounds: " + n2);
        System.out.println("  Performance: " + d);
    }
}

