/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.util.Timing;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractorDistsim
extends Extractor {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Map<String, String>> lexiconMap = new HashMap<String, Map<String, String>>();
    private final Map<String, String> lexicon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> initLexicon(String path) {
        Map<String, Map<String, String>> map = lexiconMap;
        synchronized (map) {
            Map<String, String> lex = lexiconMap.get(path);
            if (lex != null) {
                return lex;
            }
            Timing.startDoing("Loading distsim lexicon from " + path);
            HashMap<String, String> lexic = new HashMap<String, String>();
            for (String word : ObjectBank.getLineIterator(new File(path))) {
                String[] bits = word.split("\\s+");
                lexic.put(bits[0].toLowerCase(), bits[1]);
            }
            lexiconMap.put(path, lexic);
            Timing.endDoing();
            return lexic;
        }
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String word = super.extract(h, pH);
        String distSim = this.lexicon.get(word.toLowerCase());
        if (distSim == null) {
            distSim = "null";
        }
        return distSim;
    }

    ExtractorDistsim(String distSimPath, int position) {
        super(position, false);
        this.lexicon = ExtractorDistsim.initLexicon(distSimPath);
    }

    @Override
    public boolean isLocal() {
        return this.position == 0;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public static class ExtractorDistsimConjunction
    extends Extractor {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> lexicon;
        private final int left;
        private final int right;
        private String name;

        String extract(History h, PairsHolder pH) {
            StringBuilder sb = new StringBuilder();
            for (int j = this.left; j <= this.right; ++j) {
                String word = pH.getWord(h, j);
                String distSim = this.lexicon.get(word.toLowerCase());
                if (distSim == null) {
                    distSim = "null";
                }
                sb.append(distSim);
                if (j >= this.right) continue;
                sb.append('|');
            }
            return sb.toString();
        }

        ExtractorDistsimConjunction(String distSimPath, int left, int right) {
            this.lexicon = ExtractorDistsim.initLexicon(distSimPath);
            this.left = left;
            this.right = right;
            this.name = "ExtractorDistsimConjunction(" + left + ',' + right + ')';
        }

        public String toString() {
            return this.name;
        }

        public boolean isLocal() {
            return false;
        }

        public boolean isDynamic() {
            return false;
        }
    }
}

