/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorVerbalVBNZero;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ExtractorFrames {
    static final Extractor cWord = new Extractor(0, false);
    static final Extractor prevWord = new Extractor(-1, false);
    private static final Extractor prevTag = new Extractor(-1, true);
    private static final Extractor prevNextTag = new ExtractorTwoTags(-1, 1);
    private static final Extractor prevTagWord = new ExtractorWordTag(0, -1);
    private static final Extractor prevWord2 = new Extractor(-2, false);
    private static final Extractor prevTwoTag = new Extractor(-2, true);
    private static final Extractor nextWord = new Extractor(1, false);
    private static final Extractor nextWord2 = new Extractor(2, false);
    private static final Extractor nextTag = new Extractor(1, true);
    private static final Extractor cWordNextWord = new ExtractorTwoWords(0, 1);
    private static final Extractor cWordPrevWord = new ExtractorTwoWords(-1, 0);
    private static final Extractor[] eFrames_bidirectional = new Extractor[]{cWord, prevWord, nextWord, prevTag, nextTag, new ExtractorContinuousTagConjunction(-2), new ExtractorContinuousTagConjunction(2), prevNextTag, prevTagWord, new ExtractorWordTag(0, 1), cWordPrevWord, cWordNextWord};
    private static final Extractor[] eFrames_sighan2005 = new Extractor[]{cWord, prevWord, prevWord2, nextWord, nextWord2, prevTag, prevTwoTag, new ExtractorContinuousTagConjunction(-2)};
    private static final Extractor[] eFrames_german = new Extractor[]{cWord, prevWord, nextWord, nextTag, prevTag, new ExtractorContinuousTagConjunction(-2), prevTagWord, cWordPrevWord};

    private ExtractorFrames() {
    }

    protected static Extractor[] getExtractorFrames(String arch) {
        arch = arch.replaceAll("left3words", "words(-1,1),order(2)");
        arch = arch.replaceAll("left5words", "words(-2,2),order(2)");
        arch = arch.replaceAll("generic", "words(-1,1),order(2),biwords(-1,0),wordTag(0,-1)");
        ArrayList<Extractor> extrs = new ArrayList<Extractor>();
        List<String> args = StringUtils.valueSplit(arch, "[a-zA-Z0-9]*(?:\\([^)]*\\))?", "\\s*,\\s*");
        for (String arg : args) {
            int right;
            int left;
            int i;
            int rWindow;
            int lWindow;
            if (arg.equals("bidirectional")) {
                extrs.addAll(Arrays.asList(eFrames_bidirectional));
                continue;
            }
            if (arg.equals("bidirectional5words")) {
                extrs.addAll(Arrays.asList(eFrames_bidirectional));
                extrs.add(new Extractor(-2, false));
                extrs.add(new Extractor(2, false));
                continue;
            }
            if (arg.equals("sighan2005")) {
                extrs.addAll(Arrays.asList(eFrames_sighan2005));
                continue;
            }
            if (arg.equalsIgnoreCase("german")) {
                extrs.addAll(Arrays.asList(eFrames_german));
                continue;
            }
            if (arg.startsWith("words(")) {
                lWindow = Extractor.getParenthesizedNum(arg, 1);
                rWindow = Extractor.getParenthesizedNum(arg, 2);
                for (i = lWindow; i <= rWindow; ++i) {
                    extrs.add(new Extractor(i, false));
                }
                continue;
            }
            if (arg.startsWith("tags(")) {
                lWindow = Extractor.getParenthesizedNum(arg, 1);
                rWindow = Extractor.getParenthesizedNum(arg, 2);
                for (i = lWindow; i <= rWindow; ++i) {
                    extrs.add(new Extractor(i, true));
                }
                continue;
            }
            if (arg.startsWith("biwords(")) {
                lWindow = Extractor.getParenthesizedNum(arg, 1);
                rWindow = Extractor.getParenthesizedNum(arg, 2);
                for (i = lWindow; i < rWindow; ++i) {
                    extrs.add(new ExtractorTwoWords(i));
                }
                continue;
            }
            if (arg.startsWith("biword(")) {
                left = Extractor.getParenthesizedNum(arg, 1);
                right = Extractor.getParenthesizedNum(arg, 2);
                extrs.add(new ExtractorTwoWords(left, right));
                continue;
            }
            if (arg.startsWith("twoTags(")) {
                left = Extractor.getParenthesizedNum(arg, 1);
                right = Extractor.getParenthesizedNum(arg, 2);
                extrs.add(new ExtractorTwoTags(left, right));
                continue;
            }
            if (arg.startsWith("lowercasewords(")) {
                lWindow = Extractor.getParenthesizedNum(arg, 1);
                rWindow = Extractor.getParenthesizedNum(arg, 2);
                for (i = lWindow; i <= rWindow; ++i) {
                    extrs.add(new ExtractorWordLowerCase(i));
                }
                continue;
            }
            if (arg.startsWith("order(")) {
                int leftOrder = Extractor.getParenthesizedNum(arg, 1);
                int rightOrder = Extractor.getParenthesizedNum(arg, 2);
                if (leftOrder > 0) {
                    leftOrder = -leftOrder;
                }
                if (rightOrder < 0) {
                    throw new IllegalArgumentException("Right order must be non-negative, not " + rightOrder);
                }
                for (int idx = leftOrder; idx <= rightOrder; ++idx) {
                    if (idx == 0) continue;
                    if (idx == -1 || idx == 1) {
                        extrs.add(new Extractor(idx, true));
                        continue;
                    }
                    extrs.add(new ExtractorContinuousTagConjunction(idx));
                }
                continue;
            }
            if (arg.startsWith("wordTag(")) {
                int posW = Extractor.getParenthesizedNum(arg, 1);
                int posT = Extractor.getParenthesizedNum(arg, 2);
                extrs.add(new ExtractorWordTag(posW, posT));
                continue;
            }
            if (arg.startsWith("vbn(")) {
                int order = Extractor.getParenthesizedNum(arg, 1);
                extrs.add(new ExtractorVerbalVBNZero(order));
                continue;
            }
            if (arg.startsWith("wordTwoTags(")) {
                int word = Extractor.getParenthesizedNum(arg, 1);
                int tag1 = Extractor.getParenthesizedNum(arg, 2);
                int tag2 = Extractor.getParenthesizedNum(arg, 3);
                extrs.add(new ExtractorWordTwoTags(word, tag1, tag2));
                continue;
            }
            if (arg.startsWith("threeTags(")) {
                int pos1 = Extractor.getParenthesizedNum(arg, 1);
                int pos2 = Extractor.getParenthesizedNum(arg, 2);
                int pos3 = Extractor.getParenthesizedNum(arg, 3);
                extrs.add(new ExtractorThreeTags(pos1, pos2, pos3));
                continue;
            }
            if (arg.equalsIgnoreCase("naacl2003unknowns") || arg.equalsIgnoreCase("lnaacl2003unknowns") || arg.equalsIgnoreCase("naacl2003conjunctions") || arg.startsWith("wordshapes(") || arg.startsWith("lwordshapes(") || arg.equalsIgnoreCase("motleyUnknown") || arg.startsWith("suffix(") || arg.startsWith("prefix(") || arg.startsWith("prefixsuffix") || arg.startsWith("capitalizationsuffix(") || arg.startsWith("distsim(") || arg.startsWith("distsimconjunction(") || arg.equalsIgnoreCase("lctagfeatures") || arg.startsWith("unicodeshapes(") || arg.startsWith("chinesedictionaryfeatures(") || arg.startsWith("unicodeshapeconjunction(")) continue;
            System.err.println("Unrecognized ExtractorFrames identifier (ignored): " + arg);
        }
        return extrs.toArray(new Extractor[extrs.size()]);
    }

    static class ExtractorWordTwoTags
    extends Extractor {
        private static final long serialVersionUID = -4942654091455804176L;
        private int position1;
        private int position2;
        private int word;

        public ExtractorWordTwoTags(int word, int position1, int position2) {
            if (position1 < position2) {
                this.position1 = position1;
                this.position2 = position1;
            } else {
                this.position1 = position2;
                this.position2 = position1;
            }
            this.word = word;
        }

        public int leftContext() {
            if (this.position1 < 0) {
                return -this.position1;
            }
            return 0;
        }

        public int rightContext() {
            if (this.position2 > 0) {
                return this.position2;
            }
            return 0;
        }

        String extract(History h, PairsHolder pH) {
            return pH.getTag(h, this.position1) + '!' + pH.getWord(h, this.word) + '!' + pH.getTag(h, this.position2);
        }

        public boolean isLocal() {
            return false;
        }

        public boolean isDynamic() {
            return true;
        }

        public String toString() {
            return this.getClass().getName() + "(t" + this.position1 + ",t" + this.position2 + ",w" + this.word + ")";
        }
    }

    static class ExtractorThreeTags
    extends Extractor {
        private static final long serialVersionUID = 8563584394721620568L;
        private int position1;
        private int position2;
        private int position3;

        public ExtractorThreeTags(int position1, int position2, int position3) {
            int x;
            if (position1 > position2) {
                x = position2;
                position2 = position1;
                position1 = x;
            }
            if (position2 > position3) {
                x = position3;
                position3 = position2;
                position2 = x;
            }
            if (position1 > position2) {
                x = position2;
                position2 = position1;
                position1 = x;
            }
            this.position1 = position1;
            this.position2 = position2;
            this.position3 = position3;
        }

        public int rightContext() {
            if (this.position3 > 0) {
                return this.position3;
            }
            return 0;
        }

        public int leftContext() {
            if (this.position1 < 0) {
                return -this.position1;
            }
            return 0;
        }

        String extract(History h, PairsHolder pH) {
            return pH.getTag(h, this.position1) + '!' + pH.getTag(h, this.position2) + '!' + pH.getTag(h, this.position3);
        }

        public boolean isLocal() {
            return false;
        }

        public boolean isDynamic() {
            return true;
        }

        public String toString() {
            return this.getClass().getName() + "(t" + this.position1 + ",t" + this.position2 + ",t" + this.position3 + ")";
        }
    }

    static class ExtractorContinuousTagConjunction
    extends Extractor {
        private static final long serialVersionUID = 3L;

        public ExtractorContinuousTagConjunction(int maxPosition) {
            super(maxPosition, true);
        }

        String extract(History h, PairsHolder pH) {
            StringBuilder sb = new StringBuilder();
            if (this.position < 0) {
                for (int idx = this.position; idx < 0; ++idx) {
                    if (idx != this.position) {
                        sb.append('!');
                    }
                    sb.append(pH.getTag(h, idx));
                }
            } else {
                for (int idx = this.position; idx > 0; --idx) {
                    if (idx != this.position) {
                        sb.append('!');
                    }
                    sb.append(pH.getTag(h, idx));
                }
            }
            return sb.toString();
        }
    }

    static class ExtractorTwoWordsTag
    extends Extractor {
        private static final long serialVersionUID = 277004119652781188L;
        private final int leftWord;
        private final int rightWord;
        private final int tag;
        private final int rightContext;
        private final int leftContext;

        public ExtractorTwoWordsTag(int leftWord, int rightWord, int tag) {
            this.leftWord = Math.min(leftWord, rightWord);
            this.rightWord = Math.max(leftWord, rightWord);
            this.tag = tag;
            this.rightContext = Math.max(tag, 0);
            this.leftContext = -Math.min(tag, 0);
        }

        @Override
        public int rightContext() {
            return this.rightContext;
        }

        @Override
        public int leftContext() {
            return this.leftContext;
        }

        @Override
        String extract(History h, PairsHolder pH) {
            return pH.getWord(h, this.leftWord) + '!' + pH.getTag(h, this.tag) + '!' + pH.getWord(h, this.rightWord);
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "(w" + this.leftWord + ",t" + this.tag + ",w" + this.rightWord + ')';
        }
    }

    static class ExtractorTwoTags
    extends Extractor {
        private static final long serialVersionUID = -7342144764725605134L;
        private final int leftPosition;
        private final int rightPosition;
        private final int leftContext;
        private final int rightContext;

        public ExtractorTwoTags(int leftPosition) {
            this(leftPosition, leftPosition + 1);
        }

        public ExtractorTwoTags(int position1, int position2) {
            this.leftPosition = Math.min(position1, position2);
            this.rightPosition = Math.max(position1, position2);
            this.leftContext = -Math.min(this.leftPosition, 0);
            this.rightContext = Math.max(this.rightPosition, 0);
        }

        public int rightContext() {
            return this.rightContext;
        }

        public int leftContext() {
            return this.leftContext;
        }

        String extract(History h, PairsHolder pH) {
            return pH.getTag(h, this.leftPosition) + '!' + pH.getTag(h, this.rightPosition);
        }

        public boolean isLocal() {
            return false;
        }

        public boolean isDynamic() {
            return true;
        }

        public String toString() {
            return this.getClass().getName() + "(t" + this.leftPosition + ",t" + this.rightPosition + ")";
        }
    }

    static class ExtractorTwoWords
    extends Extractor {
        private static final long serialVersionUID = -1034112287022504917L;
        private final int leftPosition;
        private final int rightPosition;

        public ExtractorTwoWords(int leftPosition) {
            this(leftPosition, leftPosition + 1);
        }

        public ExtractorTwoWords(int position1, int position2) {
            super(0, false);
            if (position1 > position2) {
                this.leftPosition = position1;
                this.rightPosition = position2;
            } else {
                this.leftPosition = position2;
                this.rightPosition = position1;
            }
        }

        String extract(History h, PairsHolder pH) {
            return pH.getWord(h, this.leftPosition) + '!' + pH.getWord(h, this.rightPosition);
        }

        public boolean isLocal() {
            return false;
        }

        public String toString() {
            return this.getClass().getName() + "(w" + this.leftPosition + ",w" + this.rightPosition + ")";
        }
    }

    static class ExtractorCWordCapCase
    extends Extractor {
        private static final long serialVersionUID = -2393096135964969744L;

        ExtractorCWordCapCase() {
        }

        @Override
        String extract(History h, PairsHolder pH) {
            String cw = pH.getWord(h, 0);
            String lk = cw.toLowerCase(Locale.ENGLISH);
            if (lk.equals(cw)) {
                return "0";
            }
            return cw;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public boolean isDynamic() {
            return false;
        }
    }

    static class ExtractorWordLowerCase
    extends Extractor {
        private static final long serialVersionUID = -7847524200422095441L;

        public ExtractorWordLowerCase(int position) {
            super(position, false);
        }

        String extract(History h, PairsHolder pH) {
            return pH.getWord(h, this.position).toLowerCase(Locale.ENGLISH);
        }
    }

    static class ExtractorWordTag
    extends Extractor {
        private static final long serialVersionUID = 3L;
        private final int wordPosition;

        public ExtractorWordTag(int posW, int posT) {
            super(posT, true);
            this.wordPosition = posW;
        }

        String extract(History h, PairsHolder pH) {
            return pH.getTag(h, this.position) + '!' + pH.getWord(h, this.wordPosition);
        }

        public String toString() {
            return this.getClass().getName() + "(w" + this.wordPosition + ",t" + this.position + ")";
        }
    }
}

