/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.OutDataStreamFile;
import java.io.DataInputStream;

public class FeatureKey {
    int num;
    String val;
    String tag;
    private int hashCode = 0;

    public FeatureKey() {
    }

    protected FeatureKey(int num, String val, String tag) {
        this.num = num;
        this.val = val;
        this.tag = tag;
    }

    protected void set(int num, String val, String tag) {
        this.num = num;
        this.val = val;
        this.tag = tag;
        this.hashCode = 0;
    }

    public String toString() {
        return Integer.toString(this.num) + ' ' + this.val + ' ' + this.tag;
    }

    protected void save(OutDataStreamFile f) {
        try {
            f.writeInt(this.num);
            f.writeUTF(this.val);
            f.writeUTF(this.tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void read(DataInputStream inf) {
        try {
            this.num = inf.readInt();
            this.val = inf.readUTF();
            this.tag = inf.readUTF();
            this.hashCode = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hNum = Integer.rotateLeft(this.num, 16);
            int hVal = Integer.rotateLeft(this.val.hashCode(), 5);
            this.hashCode = hNum ^ hVal ^ this.tag.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        assert (o instanceof FeatureKey);
        FeatureKey f1 = (FeatureKey)o;
        return this.num == f1.num && this.tag.equals(f1.tag) && this.val.equals(f1.val);
    }
}

