/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.EncodingPrintWriter;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;

public class MaxentTaggerServer {
    private boolean DEBUG = false;
    private final String charset;
    private final ServerSocket listener;
    private final MaxentTagger.TaggerWrapper tagger;
    private static final String USAGE = "Usage: MaxentTaggerServer [-model file|-client] -port portNumber [other MaxentTagger options]";

    public MaxentTaggerServer(int port, MaxentTagger.TaggerWrapper tagger, String charset) throws IOException {
        this.tagger = tagger;
        this.listener = new ServerSocket(port);
        this.charset = charset;
    }

    public void run() {
        if (this.DEBUG) {
            System.err.println("Starting server loop");
        }
        Socket client = null;
        while (true) {
            try {
                while (true) {
                    client = this.listener.accept();
                    if (this.DEBUG) {
                        System.err.print("Accepted request from ");
                        System.err.println(client.getInetAddress().getHostName());
                    }
                    new Session(client);
                }
            }
            catch (Exception e1) {
                System.err.println("MaxentTaggerServer: couldn't accept");
                e1.printStackTrace(System.err);
                try {
                    client.close();
                    continue;
                }
                catch (Exception e2) {
                    System.err.println("MaxentTaggerServer: couldn't close client");
                    e2.printStackTrace(System.err);
                    continue;
                }
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println(USAGE);
            return;
        }
        Properties props = StringUtils.argsToProperties(args);
        String client = props.getProperty("client");
        String portStr = props.getProperty("port");
        if (portStr == null || portStr.equals("")) {
            System.err.println(USAGE);
            return;
        }
        int port = 0;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            System.err.println("Non-numerical port");
            System.err.println(USAGE);
            System.exit(1);
        }
        if (client != null && !client.equals("")) {
            String host = props.getProperty("host");
            String encoding = props.getProperty("encoding");
            if (encoding == null || "".equals(encoding)) {
                encoding = "utf-8";
            }
            TaggerClient.communicateWithMaxentTaggerServer(host, port, encoding);
        } else {
            TaggerConfig config = new TaggerConfig(args);
            MaxentTagger tagger = new MaxentTagger(config.getModel(), config);
            MaxentTagger.TaggerWrapper wrapper = new MaxentTagger.TaggerWrapper(config, tagger);
            new MaxentTaggerServer(port, wrapper, config.getEncoding()).run();
        }
    }

    private static class TaggerClient {
        private TaggerClient() {
        }

        private static void communicateWithMaxentTaggerServer(String host, int port, String charset) throws IOException {
            String userInput;
            if (host == null) {
                host = "localhost";
            }
            BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in, charset));
            System.err.println("Input some text and press RETURN to POS tag it, or just RETURN to finish.");
            while ((userInput = stdIn.readLine()) != null && !userInput.matches("\\n?")) {
                try {
                    Socket socket = new Socket(host, port);
                    PrintWriter out2 = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), charset), true);
                    BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), charset));
                    PrintWriter stdOut = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, charset), true);
                    out2.println(userInput);
                    stdOut.println(in.readLine());
                    while (in.ready()) {
                        stdOut.println(in.readLine());
                    }
                    in.close();
                    socket.close();
                }
                catch (UnknownHostException e) {
                    System.err.print("Cannot find host: ");
                    System.err.println(host);
                    return;
                }
                catch (IOException e) {
                    System.err.print("I/O error in the connection to: ");
                    System.err.println(host);
                    return;
                }
            }
            stdIn.close();
        }
    }

    private class Session
    extends Thread {
        private final Socket client;
        private final BufferedReader in;
        private PrintWriter out;

        private Session(Socket socket) throws IOException {
            this.client = socket;
            this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream(), MaxentTaggerServer.this.charset));
            this.out = new PrintWriter(new OutputStreamWriter(this.client.getOutputStream(), MaxentTaggerServer.this.charset));
            this.start();
        }

        public void run() {
            if (MaxentTaggerServer.this.DEBUG) {
                System.err.println("Created new session");
            }
            try {
                String input = this.in.readLine();
                if (MaxentTaggerServer.this.DEBUG) {
                    EncodingPrintWriter.err.println("Receiving: \"" + input + '\"', MaxentTaggerServer.this.charset);
                }
                if (input != null) {
                    String output = MaxentTaggerServer.this.tagger.apply(input);
                    if (MaxentTaggerServer.this.DEBUG) {
                        EncodingPrintWriter.err.println("Sending: \"" + output + '\"', MaxentTaggerServer.this.charset);
                    }
                    this.out.print(output);
                    this.out.flush();
                }
                this.close();
            }
            catch (IOException e) {
                System.err.println("MaxentTaggerServer:Session: couldn't read input or error running POS tagger");
                e.printStackTrace(System.err);
            }
            catch (NullPointerException npe) {
                System.err.println("MaxentTaggerServer:Session: connection closed by peer");
                npe.printStackTrace(System.err);
            }
        }

        private void close() {
            try {
                this.in.close();
                this.out.close();
                this.client.close();
            }
            catch (Exception e) {
                System.err.println("MaxentTaggerServer:Session: can't close session");
                e.printStackTrace();
            }
        }
    }
}

